/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.entityblocks;

import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3749;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.entityblocks.LanternBlockEntity;
import net.vibzz.immersivewind.wind.WindManager;
import org.joml.Quaternionfc;

public class LanternBlockEntityRenderer
implements class_827<LanternBlockEntity, LanternRenderState> {
    private final class_776 blockRenderManager = class_310.method_1551().method_1541();

    public LanternBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public LanternRenderState createRenderState() {
        return new LanternRenderState();
    }

    public void updateRenderState(LanternBlockEntity blockEntity, LanternRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)state, tickProgress, cameraPos, crumblingOverlay);
        state.hasWorld = blockEntity.method_11002();
        if (!state.hasWorld) {
            return;
        }
        state.blockState = blockEntity.method_11010();
        state.isHanging = (Boolean)state.blockState.method_11654((class_2769)class_3749.field_16545);
        if (state.isHanging) {
            int windDirection = WindManager.getWindDirection();
            int windStrength = WindManager.getWindStrength();
            float windAngleRad = (float)Math.toRadians(windDirection);
            float windX = class_3532.method_15374((float)windAngleRad);
            float windZ = -class_3532.method_15362((float)windAngleRad);
            float windIntensity = (float)windStrength / 30.0f;
            float timeOffset = (float)(((Object)((Object)blockEntity)).hashCode() % 1000) * 0.1f;
            float correctedTicks = 0.0f;
            if (blockEntity.method_10997() != null) {
                correctedTicks = ((float)blockEntity.method_10997().method_8510() + tickProgress + timeOffset) % 12000.0f;
            }
            float sway = (float)blockEntity.swayTicks + tickProgress;
            float strength = sway / blockEntity.strengthDivisor;
            float animationTick = 0.0f;
            if (blockEntity.method_10997() != null) {
                animationTick = ((float)blockEntity.method_10997().method_8510() + tickProgress - sway + timeOffset) % 12000.0f * 0.1f;
            }
            float oscillation = class_3532.method_15374((float)animationTick);
            float oscillationPerp = class_3532.method_15362((float)(animationTick * 0.7f));
            float amplitudeWithWind = 0.2f * windIntensity * strength;
            float amplitudeAgainstWind = 0.12f * windIntensity * strength;
            float baseAmplitude = 0.05f * strength;
            float swingAmplitude = oscillation > 0.0f ? baseAmplitude + amplitudeWithWind : baseAmplitude + amplitudeAgainstWind;
            float swing = oscillation * swingAmplitude;
            float perpAmplitude = oscillationPerp > 0.0f ? baseAmplitude * 0.8f + amplitudeWithWind * 0.5f : baseAmplitude * 0.8f + amplitudeAgainstWind * 0.5f;
            float swingPerp = oscillationPerp * perpAmplitude;
            state.pitch = windZ * swing + windX * swingPerp;
            state.roll = windX * swing - windZ * swingPerp;
            float idleStrength = (1.0f - windIntensity) * 0.5f;
            state.pitch += class_3532.method_15374((float)(correctedTicks * 0.04f)) * 0.03f * idleStrength;
            state.roll += class_3532.method_15374((float)(correctedTicks * 0.06f)) * 0.02f * idleStrength;
        }
    }

    public void render(LanternRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (!ModConfig.getEnableSwayingLanterns()) {
            return;
        }
        if (!state.hasWorld || state.blockState == null) {
            return;
        }
        matrices.method_22903();
        if (state.isHanging) {
            float pivotY = 1.0f;
            matrices.method_22904(0.5, (double)pivotY, 0.5);
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(state.roll));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.pitch));
            matrices.method_22904(-0.5, (double)(-pivotY), -0.5);
        }
        class_1087 model = this.blockRenderManager.method_3349(state.blockState);
        class_1921 renderLayer = class_4696.method_23683((class_2680)state.blockState);
        int color = class_310.method_1551().method_1505().method_1697(state.blockState, null, null, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        queue.method_73484(matrices, renderLayer, model, r, g, b, state.field_62676, class_4608.field_21444, 0);
        matrices.method_22909();
    }

    public static class LanternRenderState
    extends class_11954 {
        public class_2680 blockState;
        public boolean isHanging;
        public boolean hasWorld;
        public float pitch;
        public float roll;
    }
}

