/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.particle.custom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_746;
import net.vibzz.immersivewind.wind.WindManager;

public class SnowFlakeParticle
extends class_3940 {
    private final class_4002 spriteProvider;
    private static int activeParticleCount = 0;
    private static final int MAX_ACTIVE_PARTICLES = 3000;
    private final float rotationSpeed;

    protected SnowFlakeParticle(class_638 world, double x, double y, double z, double xd, double yd, double zd, class_4002 spriteProvider, class_1058 sprite) {
        super(world, x, y, z, xd, yd, zd, sprite);
        SnowFlakeParticle.incrementParticleCount();
        this.spriteProvider = spriteProvider;
        this.method_74307(this.spriteProvider.method_18139(this.field_3840));
        this.field_17867 = 0.07f + this.field_3840.method_43057() * 0.01f;
        this.field_3847 = 30 + this.field_3840.method_43048(20);
        this.field_62636 = 0.0f;
        this.field_3852 = xd + (double)((this.field_3840.method_43057() * 2.0f - 1.0f) * 0.01f);
        this.field_3869 = yd;
        this.field_3850 = zd + (double)((this.field_3840.method_43057() * 2.0f - 1.0f) * 0.01f);
        this.rotationSpeed = (this.field_3840.method_43056() ? 0.1f : -0.1f) * this.field_3840.method_43057() * 0.2f;
        this.field_62637 = this.field_3840.method_43057() * ((float)Math.PI * 2);
    }

    public void method_3070() {
        double dz;
        double dy;
        double dx;
        double distSq;
        class_746 player;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.field_62638 = this.field_62637;
        this.field_62637 += this.rotationSpeed;
        if (this.field_3866 % 5 == 0) {
            float windDirection = WindManager.getWindDirection();
            int windStrength = WindManager.getWindStrength();
            float windFactorX = class_3532.method_15362((float)((float)Math.toRadians(windDirection))) * (float)windStrength * 5.0E-5f;
            float windFactorZ = class_3532.method_15374((float)((float)Math.toRadians(windDirection))) * (float)windStrength * 5.0E-5f;
            this.field_3852 = this.field_3852 * (double)0.9f + (double)windFactorX;
            this.field_3850 = this.field_3850 * (double)0.9f + (double)windFactorZ;
        }
        if ((player = class_310.method_1551().field_1724) != null && ((distSq = (dx = this.field_3874 - player.method_23317()) * dx + (dy = this.field_3854 - player.method_23318()) * dy + (dz = this.field_3871 - player.method_23321()) * dz) > 400.0 || this.field_3854 < player.method_23318() - 10.0)) {
            this.method_3085();
            return;
        }
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        if (!this.field_3851.method_8316(blockPos).method_15769()) {
            this.method_3085();
            return;
        }
        if (this.field_3866 >= this.field_3847 || this.field_3845) {
            this.method_3085();
            return;
        }
        this.field_62636 = this.calculateAlpha();
        this.field_3874 += this.field_3852;
        this.field_3854 += this.field_3869;
        this.field_3871 += this.field_3850;
        this.method_74306(this.spriteProvider);
        ++this.field_3866;
    }

    private float calculateAlpha() {
        if (this.field_3866 < 10) {
            return (float)this.field_3866 * 0.03f;
        }
        if (this.field_3866 > this.field_3847 - 10) {
            return 0.3f * (float)(this.field_3847 - this.field_3866) / 10.0f;
        }
        return 0.3f;
    }

    public void method_3085() {
        super.method_3085();
        SnowFlakeParticle.decrementParticleCount();
    }

    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    private static synchronized void incrementParticleCount() {
        ++activeParticleCount;
    }

    private static synchronized void decrementParticleCount() {
        activeParticleCount = Math.max(0, activeParticleCount - 1);
    }

    public static synchronized boolean canSpawnMoreParticles() {
        return activeParticleCount < 3000;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public Factory(class_4002 spriteSet) {
            this.sprites = spriteSet;
        }

        public class_703 createParticle(class_2400 particleType, class_638 world, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            if (!SnowFlakeParticle.canSpawnMoreParticles()) {
                return null;
            }
            return new SnowFlakeParticle(world, x, y, z, xd, -0.03, zd, this.sprites, this.sprites.method_18139(random));
        }
    }
}

