/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.sounds;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.vibzz.immersivewind.sounds.ModSounds;
import net.vibzz.immersivewind.sounds.PlayerLeafSoundInstance;

public class LeafSoundManager {
    private static final List<PlayerLeafSoundInstance> activeSounds = new ArrayList<PlayerLeafSoundInstance>();
    private static final int MAX_SOUNDS = 6;
    private static final int SEARCH_RADIUS = 16;
    private static final int MIN_DISTANCE_BETWEEN_SOUNDS = 6;
    private static int tickCounter = 0;
    private static final int UPDATE_INTERVAL = 60;

    public static void tick(class_1657 player) {
        if (player == null) {
            return;
        }
        Iterator<PlayerLeafSoundInstance> iterator = activeSounds.iterator();
        while (iterator.hasNext()) {
            PlayerLeafSoundInstance sound = iterator.next();
            if (!sound.method_4793()) continue;
            iterator.remove();
        }
        if (++tickCounter >= 60) {
            tickCounter = 0;
            LeafSoundManager.updateLeafSounds(player);
        }
    }

    private static void updateLeafSounds(class_1657 player) {
        class_1937 world = player.method_73183();
        if (world == null) {
            return;
        }
        class_1144 soundManager = class_310.method_1551().method_1483();
        class_2338 playerPos = player.method_24515();
        Iterator<PlayerLeafSoundInstance> iterator = activeSounds.iterator();
        while (iterator.hasNext()) {
            PlayerLeafSoundInstance sound = iterator.next();
            class_2338 pos = sound.getLeafPos();
            double distance = Math.sqrt(playerPos.method_10262((class_2382)pos));
            if (!(distance > 24.0) && world.method_8320(pos).method_26164(class_3481.field_15503)) continue;
            soundManager.method_4870((class_1113)sound);
            iterator.remove();
        }
        if (activeSounds.size() >= 6) {
            return;
        }
        HashSet<class_2338> currentPositions = new HashSet<class_2338>();
        for (PlayerLeafSoundInstance sound : activeSounds) {
            currentPositions.add(sound.getLeafPos());
        }
        List<class_2338> leafPositions = LeafSoundManager.findLeafClusters(world, playerPos);
        for (class_2338 leafPos : leafPositions) {
            if (activeSounds.size() >= 6) break;
            if (currentPositions.contains(leafPos)) continue;
            boolean tooClose = false;
            for (class_2338 existing : currentPositions) {
                if (!(Math.sqrt(existing.method_10262((class_2382)leafPos)) < 6.0)) continue;
                tooClose = true;
                break;
            }
            if (tooClose) continue;
            PlayerLeafSoundInstance newSound = new PlayerLeafSoundInstance(player, ModSounds.LEAF_SOUND, leafPos);
            activeSounds.add(newSound);
            currentPositions.add(leafPos);
            soundManager.method_4873((class_1113)newSound);
        }
    }

    private static List<class_2338> findLeafClusters(class_1937 world, class_2338 playerPos) {
        ArrayList<class_2338> clusters = new ArrayList<class_2338>();
        for (int x = -16; x <= 16; x += 4) {
            for (int y = -16; y <= 16; y += 4) {
                for (int z = -16; z <= 16; z += 4) {
                    class_2338 checkPos = playerPos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(checkPos);
                    if (!state.method_26164(class_3481.field_15503)) continue;
                    clusters.add(checkPos);
                }
            }
        }
        clusters.sort((a, b) -> {
            double distA = playerPos.method_10262((class_2382)a);
            double distB = playerPos.method_10262((class_2382)b);
            return Double.compare(distA, distB);
        });
        return clusters;
    }

    public static void stopAll() {
        class_1144 soundManager = class_310.method_1551().method_1483();
        for (PlayerLeafSoundInstance sound : activeSounds) {
            soundManager.method_4870((class_1113)sound);
        }
        activeSounds.clear();
        tickCounter = 0;
    }
}

