/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.sounds;

import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.util.WindRaycastDebugRenderer;
import net.vibzz.immersivewind.wind.WindManager;

public class PlayerWindSoundInstance
extends class_1101 {
    private final class_1657 player;
    private float targetVolume;
    private float occlusionValue = 1.0f;
    private float occlusionValueInterpolated = 1.0f;
    private int tickCounter = 0;
    private static final int RAYCAST_INTERVAL = 2;
    public static final double LOCAL_DETECTION_RADIUS = 20.0;
    private static final int NUM_LOCAL_SAMPLES = 60;
    private static final int NUM_DISTANT_SAMPLES = 10;
    private static final class_243[] LOCAL_SPHERE_DIRECTIONS = PlayerWindSoundInstance.generateFibonacciSphere();
    private static final class_243[] DISTANT_DIRECTIONS = PlayerWindSoundInstance.generateHorizontalCircle();
    private static final float INTERP_SPEED = 0.15f;
    private static final float LEAF_TRANSPARENCY = 0.7f;

    public PlayerWindSoundInstance(class_1657 player, class_3414 soundEvent) {
        super(soundEvent, class_3419.field_15256, class_5819.method_43047());
        this.player = player;
        this.field_5446 = true;
        this.field_5451 = 0;
        this.targetVolume = this.field_5442 = WindManager.calculateWindVolume();
        this.field_5440 = class_1113.class_1114.field_5478;
        this.field_18936 = true;
    }

    private static class_243[] generateFibonacciSphere() {
        class_243[] samples = new class_243[60];
        float phi = (float)((1.0 + Math.sqrt(5.0)) / 2.0);
        for (int i = 0; i < 60; ++i) {
            float y = 1.0f - (float)i / 59.0f * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = phi * (float)i * 2.0f * (float)Math.PI;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            samples[i] = new class_243((double)x, (double)y, (double)z).method_1029();
        }
        return samples;
    }

    private static class_243[] generateHorizontalCircle() {
        class_243[] samples = new class_243[10];
        for (int i = 0; i < 10; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 10.0);
            samples[i] = new class_243(Math.cos(angle), 0.0, Math.sin(angle)).method_1029();
        }
        return samples;
    }

    public void method_16896() {
        if (this.player.method_31481() || !ModConfig.getEnableWind()) {
            this.method_24876();
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 2) {
            this.tickCounter = 0;
            this.performWindDetection();
        }
        this.interpolateOcclusion();
        float dynamicWindVolume = WindManager.calculateWindVolume();
        float baseVolume = this.player.method_73183().method_27983() == class_1937.field_25179 ? dynamicWindVolume : 0.1f * dynamicWindVolume;
        this.targetVolume = baseVolume * this.occlusionValueInterpolated;
        this.field_5442 = Math.abs(this.field_5442 - this.targetVolume) > 0.01f ? (this.field_5442 += (this.targetVolume - this.field_5442) * 0.1f) : this.targetVolume;
    }

    private void performWindDetection() {
        if (this.player.method_73183() == null) {
            return;
        }
        class_1937 world = this.player.method_73183();
        class_243 playerPos = this.player.method_33571();
        if (WindRaycastDebugRenderer.isEnabled()) {
            WindRaycastDebugRenderer.clear();
        }
        class_243 windDirection = this.getWindDirectionVector();
        float localOpenness = this.calculateLocalOcclusion(world, playerPos, windDirection);
        float distantWindAccess = this.calculateDistantWindAccess(world, playerPos, windDirection);
        if (localOpenness < 0.15f) {
            this.occlusionValue = 0.0f;
            return;
        }
        this.occlusionValue = distantWindAccess > 0.5f ? Math.max(localOpenness * 0.7f, distantWindAccess * 0.5f) : localOpenness;
        this.occlusionValue = (float)Math.pow(this.occlusionValue, 1.5);
        if (this.occlusionValue < 0.08f) {
            this.occlusionValue = 0.0f;
        }
        this.occlusionValue = Math.max(0.0f, Math.min(1.0f, this.occlusionValue));
    }

    private class_243 getWindDirectionVector() {
        int windDegrees = WindManager.getWindDirection();
        double radians = Math.toRadians(windDegrees);
        double x = Math.sin(radians);
        double z = -Math.cos(radians);
        return new class_243(x, 0.0, z).method_1029();
    }

    private boolean isLeafBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_26164(class_3481.field_15503);
    }

    private RaycastResult performLeafAwareRaycast(class_1937 world, class_243 startPos, class_243 endPos) {
        class_243 currentPos = startPos;
        float accumulatedTransparency = 1.0f;
        int leafBlocksHit = 0;
        int MAX_LEAF_PENETRATION = 8;
        while (currentPos.method_1022(startPos) < 20.0) {
            class_3959 context = new class_3959(currentPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.player);
            class_3965 hitResult = world.method_17742(context);
            if (hitResult.method_17783() == class_239.class_240.field_1333) {
                return new RaycastResult(false, endPos, accumulatedTransparency, leafBlocksHit);
            }
            if (hitResult instanceof class_3965) {
                class_3965 blockHit = hitResult;
                class_2338 hitPos = blockHit.method_17777();
                if (this.isLeafBlock(world, hitPos)) {
                    accumulatedTransparency *= 0.7f;
                    if (++leafBlocksHit >= 8 || accumulatedTransparency < 0.1f) {
                        return new RaycastResult(true, hitResult.method_17784(), accumulatedTransparency, leafBlocksHit);
                    }
                    class_243 hitPoint = hitResult.method_17784();
                    class_243 direction = endPos.method_1020(startPos).method_1029();
                    currentPos = hitPoint.method_1019(direction.method_1021(0.1));
                    continue;
                }
                return new RaycastResult(true, hitResult.method_17784(), accumulatedTransparency, leafBlocksHit);
            }
            return new RaycastResult(true, hitResult.method_17784(), accumulatedTransparency, leafBlocksHit);
        }
        return new RaycastResult(false, endPos, accumulatedTransparency, leafBlocksHit);
    }

    private float calculateLocalOcclusion(class_1937 world, class_243 playerPos, class_243 windDirection) {
        int totalRays = 0;
        int completelyOpenRays = 0;
        float totalPartialOpenness = 0.0f;
        for (class_243 direction : LOCAL_SPHERE_DIRECTIONS) {
            class_243 endPos = playerPos.method_1019(direction.method_1021(20.0));
            RaycastResult result = this.performLeafAwareRaycast(world, playerPos, endPos);
            ++totalRays;
            if (!result.hitSolidBlock && result.transparency > 0.9f) {
                ++completelyOpenRays;
                totalPartialOpenness += result.transparency;
            } else if (!result.hitSolidBlock) {
                totalPartialOpenness += result.transparency;
                if (result.transparency > 0.5f) {
                    ++completelyOpenRays;
                }
            } else {
                double hitDistance = result.endPosition.method_1022(playerPos);
                float distanceOpenness = (float)(hitDistance / 20.0);
                float partialOpenness = distanceOpenness * result.transparency;
                totalPartialOpenness += partialOpenness * 0.3f;
            }
            boolean visuallyBlocked = result.hitSolidBlock || result.transparency < 0.5f;
            double hitDistance = result.endPosition.method_1022(playerPos);
            WindRaycastDebugRenderer.add(playerPos, result.endPosition, visuallyBlocked, hitDistance);
        }
        float unobstructedRatio = (float)completelyOpenRays / (float)totalRays;
        float averageOpenness = totalPartialOpenness / (float)totalRays;
        float baseOpenness = unobstructedRatio * 0.8f + averageOpenness * 0.2f;
        if (completelyOpenRays > 0) {
            float upwindBonus = this.calculateUpwindBonus(world, playerPos, windDirection);
            baseOpenness = Math.min(1.0f, baseOpenness + upwindBonus * 0.2f);
        }
        return baseOpenness;
    }

    private float calculateUpwindBonus(class_1937 world, class_243 playerPos, class_243 windDirection) {
        class_243 endPos = playerPos.method_1019(windDirection.method_1021(20.0));
        RaycastResult result = this.performLeafAwareRaycast(world, playerPos, endPos);
        if (!result.hitSolidBlock) {
            return result.transparency;
        }
        double hitDistance = result.endPosition.method_1022(playerPos);
        return (float)(hitDistance / 20.0) * result.transparency;
    }

    private float calculateDistantWindAccess(class_1937 world, class_243 playerPos, class_243 windDirection) {
        int totalRays = 0;
        int completelyOpenRays = 0;
        float totalPartialOpenness = 0.0f;
        for (class_243 direction : DISTANT_DIRECTIONS) {
            class_243 endPos = playerPos.method_1019(direction.method_1021(20.0));
            RaycastResult result = this.performLeafAwareRaycast(world, playerPos, endPos);
            ++totalRays;
            if (!result.hitSolidBlock && result.transparency > 0.5f) {
                ++completelyOpenRays;
                totalPartialOpenness += result.transparency;
            } else if (!result.hitSolidBlock) {
                totalPartialOpenness += result.transparency;
            } else {
                double hitDistance = result.endPosition.method_1022(playerPos);
                float partialOpenness = (float)(hitDistance / 20.0) * result.transparency;
                totalPartialOpenness += partialOpenness * 0.3f;
            }
            boolean visuallyBlocked = result.hitSolidBlock || result.transparency < 0.5f;
            double hitDistance = result.endPosition.method_1022(playerPos);
            WindRaycastDebugRenderer.add(playerPos, result.endPosition, visuallyBlocked, hitDistance);
        }
        float baseOpenness = totalPartialOpenness / (float)totalRays;
        if (completelyOpenRays > 0) {
            float upwindDistantBonus = this.calculateUpwindDistantBonus(world, playerPos, windDirection);
            baseOpenness = Math.min(1.0f, baseOpenness + upwindDistantBonus * 0.3f);
        }
        return baseOpenness;
    }

    private float calculateUpwindDistantBonus(class_1937 world, class_243 playerPos, class_243 windDirection) {
        class_243 endPos = playerPos.method_1019(windDirection.method_1021(20.0));
        RaycastResult result = this.performLeafAwareRaycast(world, playerPos, endPos);
        if (!result.hitSolidBlock) {
            return result.transparency;
        }
        double hitDistance = result.endPosition.method_1022(playerPos);
        if (hitDistance >= 20.0) {
            return result.transparency;
        }
        return (float)(hitDistance / 20.0) * result.transparency;
    }

    private void interpolateOcclusion() {
        float delta = this.occlusionValue - this.occlusionValueInterpolated;
        this.occlusionValueInterpolated = Math.abs(delta) > 0.001f ? (this.occlusionValueInterpolated += delta * 0.15f) : this.occlusionValue;
    }

    private static class RaycastResult {
        final boolean hitSolidBlock;
        final class_243 endPosition;
        final float transparency;
        final int leafBlocksHit;

        RaycastResult(boolean hitSolidBlock, class_243 endPosition, float transparency, int leafBlocksHit) {
            this.hitSolidBlock = hitSolidBlock;
            this.endPosition = endPosition;
            this.transparency = transparency;
            this.leafBlocksHit = leafBlocksHit;
        }
    }
}

