/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.wind;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.entityblocks.LanternBlockEntity;
import net.vibzz.immersivewind.network.WindNetworking;
import net.vibzz.immersivewind.particle.ParticleRegistry;
import net.vibzz.immersivewind.particle.spawners.WindWispSpawner;
import net.vibzz.immersivewind.wind.WindManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WindMod
implements ModInitializer {
    public static final String MOD_ID = "immersivewind";
    public static final String VERSION = FabricLoader.getInstance().getModContainer("immersivewind").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Version::getFriendlyString).orElse("unknown");
    public static final Logger LOGGER = LogManager.getLogger((String)"immersivewind");
    public static final class_2591<LanternBlockEntity> LANTERN_ENTITY = FabricBlockEntityTypeBuilder.create(LanternBlockEntity::new, (class_2248[])new class_2248[]{class_2246.field_16541, class_2246.field_61906.comp_4577(), class_2246.field_61906.comp_4581(), class_2246.field_61906.comp_4579(), class_2246.field_61906.comp_4583(), class_2246.field_61906.comp_4578(), class_2246.field_61906.comp_4582(), class_2246.field_61906.comp_4576(), class_2246.field_61906.comp_4580(), class_2246.field_22110}).build();
    private int tickCount = 0;
    private boolean isTickEventRegistered = false;
    private static final int SAVE_INTERVAL = 6000;

    public void onInitialize() {
        LOGGER.info("Initializing Immersive Winds {}", (Object)VERSION);
        LOGGER.info("Loading Immersive Winds config");
        ModConfig.loadConfig();
        LOGGER.info("Immersive Winds Config loaded");
        WindNetworking.register();
        WindNetworking.registerServerHandlers();
        LOGGER.info("Wind networking registered");
        ParticleRegistry.registerParticleTypes();
        LOGGER.info("Immersive Winds Particles registered");
        class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"lantern"), LANTERN_ENTITY);
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                WindManager.initializeWind((class_1937)world);
                LOGGER.info("Wind system initialized for overworld");
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            if (world.method_27983() == class_1937.field_25179) {
                WindManager.saveWindState((class_1937)world);
                LOGGER.info("Wind state saved for overworld");
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            class_3218 overworld = server.method_30002();
            if (overworld != null) {
                WindManager.saveWindState((class_1937)overworld);
                LOGGER.info("Wind state saved before server stop");
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (!this.isTickEventRegistered) {
                ServerTickEvents.START_WORLD_TICK.register(this::onWorldTick);
                this.isTickEventRegistered = true;
                LOGGER.info("Immersive Winds World tick event registered");
            }
        });
    }

    public void onWorldTick(class_3218 world) {
        if (world.method_27983() != class_1937.field_25179) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount % 3 == 1) {
            WindManager.updateServer((class_1937)world);
            WindNetworking.sendWindUpdate(world);
        }
        WindWispSpawner.updateWispsForWorld(world);
        if (this.tickCount % 20 == 0) {
            WindWispSpawner.spawnWispsInWorld(world);
        }
        if (this.tickCount % 6000 == 0) {
            WindManager.saveWindState((class_1937)world);
            if (ModConfig.getDebugMode()) {
                LOGGER.info("Wind state save completed");
            }
        }
        if (this.tickCount >= 2147477647) {
            this.tickCount = 0;
        }
    }
}

