/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.wind;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3675;
import net.minecraft.class_3999;
import net.minecraft.class_702;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.entityblocks.LanternBlockEntity;
import net.vibzz.immersivewind.entityblocks.LanternBlockEntityRenderer;
import net.vibzz.immersivewind.network.WindNetworking;
import net.vibzz.immersivewind.particle.ParticleRegistryClient;
import net.vibzz.immersivewind.particle.windwisps.CustomParticleTextureSheets;
import net.vibzz.immersivewind.particle.windwisps.CustomRenderPipelines;
import net.vibzz.immersivewind.particle.windwisps.CustomTrailRenderer;
import net.vibzz.immersivewind.sounds.ModSounds;
import net.vibzz.immersivewind.util.WindRaycastDebugRenderer;
import net.vibzz.immersivewind.wind.WindManager;
import net.vibzz.immersivewind.wind.WindMod;

public class WindModClient
implements ClientModInitializer {
    private static class_304 windDebugKey;

    public void onInitializeClient() {
        WindMod.LOGGER.info("Initializing ImmersiveWind client");
        WindNetworking.WindNetworkingClient.init();
        WindMod.LOGGER.info("Setting up server detection");
        WindModClient.registerConnectionEvents();
        WindModClient.registerWindEffects();
        WindMod.LOGGER.info("Creating particle factories");
        ParticleRegistryClient.registerParticleFactories();
        WindMod.LOGGER.info("Generating sounds");
        ModSounds.registerSoundTickers();
        WindMod.LOGGER.info("Sounds generated");
        if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            WindMod.LOGGER.info("ModMenu detected, initializing ModMenu integration.");
            this.loadModMenuIntegration();
        } else {
            WindMod.LOGGER.info("ModMenu not detected, skipping ModMenu integration.");
        }
        CustomRenderPipelines.register();
        ParticleRendererRegistry.register((class_3999)CustomParticleTextureSheets.CUSTOM_TRAIL, manager -> new CustomTrailRenderer((class_702)manager, CustomRenderPipelines.TRAIL, true));
        BlockEntityRendererRegistry.register(WindMod.LANTERN_ENTITY, LanternBlockEntityRenderer::new);
        windDebugKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.immersivewind.debug", class_3675.class_307.field_1668, 297, class_304.class_11900.field_62556));
        WindMod.LOGGER.info("Immersive Winds finished initializing, have fun!");
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"immersivewind", (String)"sound_reload");
            }

            public CompletableFuture<Void> method_25931(class_3302.class_11558 store, Executor prepareExecutor, class_3302.class_4045 reloadSynchronizer, Executor applyExecutor) {
                return reloadSynchronizer.method_18352(null).thenRunAsync(() -> {
                    class_310 client = class_310.method_1551();
                    if (client.field_1724 != null) {
                        ModSounds.stopAllWindSounds();
                        ModSounds.playWindSound((class_1657)client.field_1724);
                    }
                }, applyExecutor);
            }
        });
        ClientChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (!ModConfig.getEnableSwayingLanterns()) {
                return;
            }
            class_2826[] sections = chunk.method_12006();
            int bottomSectionY = chunk.method_32891();
            for (int sectionIndex = 0; sectionIndex < sections.length; ++sectionIndex) {
                class_2826 section = sections[sectionIndex];
                if (section == null || section.method_38292() || !section.method_19523(WindModClient::isVanillaLantern)) continue;
                int baseY = (bottomSectionY + sectionIndex) * 16;
                int chunkStartX = chunk.method_12004().method_8326();
                int chunkStartZ = chunk.method_12004().method_8328();
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            class_2338 pos;
                            class_2680 state = section.method_12254(x, y, z);
                            if (!WindModClient.isVanillaLantern(state) || chunk.method_8321(pos = new class_2338(chunkStartX + x, baseY + y, chunkStartZ + z)) != null) continue;
                            LanternBlockEntity be = new LanternBlockEntity(pos, state);
                            chunk.method_12007((class_2586)be);
                        }
                    }
                }
            }
        });
    }

    private static boolean isVanillaLantern(class_2680 state) {
        if (state.method_27852(class_2246.field_16541) || state.method_27852(class_2246.field_22110)) {
            return true;
        }
        return state.method_27852(class_2246.field_61906.comp_4577()) || state.method_27852(class_2246.field_61906.comp_4581()) || state.method_27852(class_2246.field_61906.comp_4579()) || state.method_27852(class_2246.field_61906.comp_4583()) || state.method_27852(class_2246.field_61906.comp_4578()) || state.method_27852(class_2246.field_61906.comp_4582()) || state.method_27852(class_2246.field_61906.comp_4576()) || state.method_27852(class_2246.field_61906.comp_4580());
    }

    public static void registerConnectionEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> WindNetworking.WindNetworkingClient.sendPingToServer(client));
    }

    private void loadModMenuIntegration() {
        try {
            Class.forName("net.vibzz.immersivewind.config.ModMenuIntegration");
            WindMod.LOGGER.info("ModMenu integration successfully initialized.");
        }
        catch (ClassNotFoundException e) {
            WindMod.LOGGER.warn("ModMenu integration class not found, skipping integration.");
        }
        catch (Exception e) {
            WindMod.LOGGER.error("Failed to initializeWind ModMenu integration.", (Throwable)e);
        }
    }

    public static void registerWindEffects() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null) {
                WindManager.updateClient((class_1937)client.field_1687);
            }
            while (windDebugKey.method_1436()) {
                WindRaycastDebugRenderer.toggle();
                if (client.field_1724 == null) continue;
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Wind Debug: " + (WindRaycastDebugRenderer.isEnabled() ? "\u00a7aON" : "\u00a7cOFF"))), true);
            }
        });
    }
}

