/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.particle.spawners;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.particle.ParticleRegistry;
import net.vibzz.immersivewind.particle.windwisps.TrailParticleEffect;
import net.vibzz.immersivewind.wind.WindManager;

public class WindWispSpawner {
    private static final Random random = new Random();
    private static final double SPAWN_RADIUS_MIN = 4.0;
    private static final double SPAWN_RADIUS_MAX = 15.0;
    private static final double SPAWN_HEIGHT_OFFSET = 16.0;
    private static final Map<UUID, WispData> activeWisps = new HashMap<UUID, WispData>();

    public static void updateWispsForWorld(class_3218 world) {
        WindWispSpawner.updateWisps(world);
    }

    public static void spawnWispsInWorld(class_3218 world) {
        WindWispSpawner.spawnWispsAroundPlayers(world);
    }

    private static void spawnWispsAroundPlayers(class_3218 world) {
        if (!ModConfig.getEnableWindWisps()) {
            return;
        }
        for (class_1657 player : world.method_18456()) {
            if (!WindWispSpawner.shouldSpawnWisp()) continue;
            WindWispSpawner.spawnWispNearPlayer(world, player);
        }
    }

    private static boolean shouldSpawnWisp() {
        return random.nextFloat() < 0.3f;
    }

    private static void spawnWispNearPlayer(class_3218 world, class_1657 player) {
        int blockZ;
        int blockY;
        double angle = random.nextDouble() * Math.PI * 2.0;
        double radius = class_3532.method_16436((double)random.nextDouble(), (double)4.0, (double)15.0);
        double heightOffset = (random.nextDouble() - 0.5) * 16.0;
        class_243 playerPos = player.method_33571();
        double x = playerPos.field_1352 + Math.cos(angle) * radius;
        double y = playerPos.field_1351 + heightOffset;
        double z = playerPos.field_1350 + Math.sin(angle) * radius;
        int blockX = (int)Math.floor(x);
        if (!world.method_8316(new class_2338(blockX, blockY = (int)Math.floor(y), blockZ = (int)Math.floor(z))).method_15769()) {
            return;
        }
        int topY = world.method_8624(class_2902.class_2903.field_13197, blockX, blockZ);
        if (blockY < topY) {
            return;
        }
        UUID wispId = UUID.randomUUID();
        WispData wispData = new WispData(new class_243(x, y, z), (WindManager.getWindDirection() + 270) % 360, 15.0f + random.nextFloat() * 10.0f, 0.05f + random.nextFloat() * 0.04f, world.method_8510(), 100 + random.nextInt(200));
        activeWisps.put(wispId, wispData);
        class_2390 invisibleDust = new class_2390(0xFFFFFF, 0.0f);
        world.method_14199((class_2394)invisibleDust, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void updateWisps(class_3218 world) {
        Iterator<Map.Entry<UUID, WispData>> iterator = activeWisps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, WispData> entry = iterator.next();
            WispData wisp = entry.getValue();
            long currentTime = world.method_8510();
            if (currentTime - wisp.spawnTime >= (long)wisp.lifespan) {
                iterator.remove();
                continue;
            }
            class_243 previousPosition = wisp.position;
            class_243 previousRotation = new class_243(0.0, (double)wisp.yaw, (double)wisp.pitch);
            WindWispSpawner.updateWispMovement(wisp, currentTime);
            wisp.previousPosition = previousPosition;
            world.method_14199((class_2394)TrailParticleEffect.create(ParticleRegistry.TRAIL, 1.0f, 1.0f, 1.0f, 0.0f, wisp.yaw, wisp.pitch, 0.0f, (float)previousRotation.field_1351, (float)previousRotation.field_1350, wisp.position, previousPosition, wisp.particleIndex++), wisp.position.field_1352, wisp.position.field_1351, wisp.position.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void updateWispMovement(WispData wisp, long currentTime) {
        float timeSinceSpawn = currentTime - wisp.spawnTime;
        float waveOffset = class_3532.method_15374((float)(timeSinceSpawn * wisp.waveFrequency)) * wisp.waveAmplitude;
        if (random.nextFloat() < 0.05f) {
            wisp.waveAmplitude = class_3532.method_15363((float)(wisp.waveAmplitude + (random.nextFloat() - 0.5f) * 2.0f), (float)10.0f, (float)30.0f);
        }
        wisp.yaw = wisp.baseYaw + waveOffset;
        wisp.pitch = class_3532.method_15374((float)(timeSinceSpawn * wisp.waveFrequency * 0.5f)) * 5.0f;
        float speed = 0.1f + (float)WindManager.getWindStrength() / 35.0f * 0.15f;
        float yawRad = wisp.yaw * ((float)Math.PI / 180);
        float pitchRad = wisp.pitch * ((float)Math.PI / 180);
        double motionX = -class_3532.method_15374((float)yawRad) * class_3532.method_15362((float)pitchRad) * speed;
        double motionY = -class_3532.method_15374((float)pitchRad) * speed;
        double motionZ = class_3532.method_15362((float)yawRad) * class_3532.method_15362((float)pitchRad) * speed;
        wisp.position = wisp.position.method_1031(motionX, motionY, motionZ);
    }

    private static class WispData {
        public class_243 position;
        public class_243 previousPosition;
        public final float baseYaw;
        public float waveAmplitude;
        public final float waveFrequency;
        public final long spawnTime;
        public final int lifespan;
        public float yaw;
        public float pitch;
        public int particleIndex;

        public WispData(class_243 position, float baseYaw, float waveAmplitude, float waveFrequency, long spawnTime, int lifespan) {
            this.position = position;
            this.previousPosition = position;
            this.baseYaw = baseYaw;
            this.waveAmplitude = waveAmplitude;
            this.waveFrequency = waveFrequency;
            this.spawnTime = spawnTime;
            this.lifespan = lifespan;
            this.yaw = baseYaw;
            this.pitch = 0.0f;
            this.particleIndex = 0;
        }
    }
}

