/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.sounds;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.sounds.LeafSoundManager;
import net.vibzz.immersivewind.sounds.PlayerWindSoundInstance;
import net.vibzz.immersivewind.wind.WindMod;

public class ModSounds {
    public static final class_3414 WIND_SOUND = ModSounds.registerSoundEvent("wind_sound");
    public static final class_3414 LEAF_SOUND = ModSounds.registerSoundEvent("leaf_sound");
    private static final Map<UUID, PlayerWindSoundInstance> activeWindSounds = new HashMap<UUID, PlayerWindSoundInstance>();
    private static final Map<UUID, class_5321<class_1937>> playerWorldMap = new HashMap<UUID, class_5321<class_1937>>();

    public static class_3414 registerSoundEvent(String name) {
        class_2960 id = class_2960.method_60655((String)"immersivewind", (String)name);
        return (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
    }

    public static void playWindSound(class_1657 player) {
        if (player == null) {
            WindMod.LOGGER.warn("Player is null, cannot play wind sound.");
            return;
        }
        UUID playerUUID = player.method_5667();
        class_310 client = class_310.method_1551();
        class_1144 soundManager = client.method_1483();
        if (activeWindSounds.containsKey(playerUUID) && !activeWindSounds.get(playerUUID).method_4793()) {
            return;
        }
        PlayerWindSoundInstance windSoundInstance = new PlayerWindSoundInstance(player, WIND_SOUND);
        activeWindSounds.put(playerUUID, windSoundInstance);
        soundManager.method_4873((class_1113)windSoundInstance);
    }

    public static void registerSoundTickers() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (class_310.method_1551().field_1724 != null) {
                class_746 player = class_310.method_1551().field_1724;
                ModSounds.stopAllSounds();
                playerWorldMap.put(player.method_5667(), (class_5321<class_1937>)player.method_37908().method_27983());
                ModSounds.playWindSound((class_1657)player);
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ModSounds.stopAllSounds();
            playerWorldMap.clear();
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                class_746 player = client.field_1724;
                LeafSoundManager.tick((class_1657)player);
                UUID playerUUID = player.method_5667();
                class_5321 currentWorld = player.method_37908().method_27983();
                class_5321<class_1937> previousWorld = playerWorldMap.get(playerUUID);
                if (previousWorld != currentWorld) {
                    ModSounds.stopAllSounds();
                    ModSounds.playWindSound((class_1657)player);
                    playerWorldMap.put(playerUUID, (class_5321<class_1937>)currentWorld);
                }
            }
        });
    }

    public static void stopAllWindSounds() {
        class_310 client = class_310.method_1551();
        class_1144 soundManager = client.method_1483();
        for (PlayerWindSoundInstance soundInstance : activeWindSounds.values()) {
            if (soundInstance == null || soundInstance.method_4793()) continue;
            soundManager.method_4870((class_1113)soundInstance);
        }
        activeWindSounds.clear();
    }

    public static void stopAllSounds() {
        ModSounds.stopAllWindSounds();
        LeafSoundManager.stopAll();
    }

    public static void stopSoundsIfDisabled() {
        if (!ModConfig.getEnableWind()) {
            ModSounds.stopAllWindSounds();
        }
    }
}

