/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.wind;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public class WindSaveData
extends class_18 {
    public static final String ID = "immersivewind_wind_data";
    private int windDirection;
    private int windStrength;
    private int weatherState;
    public static final Codec<WindSaveData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("wind_direction").orElse((Object)0).forGetter(WindSaveData::getWindDirection), (App)Codec.INT.fieldOf("wind_strength").orElse((Object)5).forGetter(WindSaveData::getWindStrength), (App)Codec.INT.fieldOf("weather_state").orElse((Object)0).forGetter(WindSaveData::getWeatherState)).apply((Applicative)instance, WindSaveData::new));
    public static final class_10741<WindSaveData> WIND_DATA_TYPE = new class_10741("immersivewind_wind_data", WindSaveData::new, CODEC, class_4284.field_19212);

    public WindSaveData(int windDirection, int windStrength, int weatherState) {
        this.windDirection = windDirection;
        this.windStrength = windStrength;
        this.weatherState = weatherState;
    }

    public WindSaveData() {
        this.windDirection = 0;
        this.windStrength = 5;
        this.weatherState = 0;
    }

    public static WindSaveData getServerState(MinecraftServer server) {
        if (server == null) {
            throw new IllegalStateException("Attempted to access wind save data with null server");
        }
        class_3218 serverWorld = server.method_3847(class_1937.field_25179);
        if (serverWorld == null) {
            throw new IllegalStateException("Overworld not available for wind save data");
        }
        class_26 persistentStateManager = serverWorld.method_17983();
        return (WindSaveData)persistentStateManager.method_17924(WIND_DATA_TYPE);
    }

    public void setWindData(int direction, int strength, int weather) {
        this.windDirection = direction;
        this.windStrength = strength;
        this.weatherState = weather;
        this.method_80();
    }

    public int getWindDirection() {
        return this.windDirection;
    }

    public int getWindStrength() {
        return this.windStrength;
    }

    public int getWeatherState() {
        return this.weatherState;
    }
}

