/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.particle.custom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_746;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.particle.ParticleRegistry;
import net.vibzz.immersivewind.wind.WindManager;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RainParticle
extends class_4003 {
    private final class_4002 spriteProvider;
    private static class_4002 staticSpriteProvider;
    private float windInfluenceX;
    private float windInfluenceZ;
    private boolean isDripping = false;
    private class_2350 wallFace = null;
    private double wallX;
    private double wallZ;
    private final float baseScale;
    private int leftWallAge = -1;
    private int hangDelayTicks = 0;

    public RainParticle(class_638 world, double x, double y, double z, class_4002 spriteProvider, double xd, double yd, double zd, boolean startAsDripping) {
        super(world, x, y, z, xd, yd, zd);
        this.spriteProvider = spriteProvider;
        this.method_18141(this.spriteProvider.method_18139(this.field_3840));
        class_2338 spawnPos = class_2338.method_49637((double)x, (double)y, (double)z);
        int heightmapY = world.method_8624(class_2902.class_2903.field_13197, spawnPos.method_10263(), spawnPos.method_10260());
        boolean startedAboveHeightmap = y >= (double)heightmapY;
        this.field_17867 = this.baseScale = 0.035f + this.field_3840.method_43057() * 0.03f;
        this.field_3847 = 100;
        this.field_3841 = 0.0f;
        this.updateWindInfluence();
        this.field_3852 = this.windInfluenceX;
        this.field_3869 = -0.5f + this.field_3840.method_43057() * -0.1f;
        this.field_3850 = this.windInfluenceZ;
        if (!startedAboveHeightmap && !startAsDripping) {
            this.field_3847 = 0;
            this.method_3085();
        }
        if (startAsDripping) {
            this.isDripping = true;
            this.leftWallAge = this.field_3866;
            this.hangDelayTicks = 10 + this.field_3840.method_43048(21);
            this.field_3847 = this.field_3866 + 60;
            this.field_17867 = this.baseScale * (0.8f + this.field_3840.method_43057() * 0.4f);
            this.field_3852 = 0.0;
            this.field_3869 = 0.0;
            this.field_3850 = 0.0;
            this.wallX = x;
            this.wallZ = z;
            this.wallFace = null;
            this.field_3841 = ModConfig.getRainAlpha();
        }
    }

    private void updateWindInfluence() {
        float windDirection = WindManager.getWindDirection();
        float windStrength = WindManager.getWindStrength();
        float windAngleRadX = (float)Math.toRadians(windDirection);
        float windAngleRadZ = (float)Math.toRadians(windDirection - 90.0f);
        this.windInfluenceX = class_3532.method_15362((float)windAngleRadX) * (windStrength / 36.0f) * 0.4f;
        this.windInfluenceZ = class_3532.method_15362((float)windAngleRadZ) * (windStrength / 36.0f) * 0.4f;
    }

    public int method_3068(float tint) {
        int scaledBlockLight = (int)(15.0f * this.field_3841);
        int scaledSkyLight = (int)(15.0f * this.field_3841);
        scaledBlockLight = class_3532.method_15340((int)scaledBlockLight, (int)0, (int)15);
        scaledSkyLight = class_3532.method_15340((int)scaledSkyLight, (int)0, (int)15);
        return scaledSkyLight << 20 | scaledBlockLight << 4;
    }

    public void method_3070() {
        class_746 player;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (!this.isDripping && this.field_3866 % 5 == 0) {
            this.updateWindInfluence();
            this.field_3852 = this.windInfluenceX;
            this.field_3850 = this.windInfluenceZ;
        }
        if ((player = class_310.method_1551().field_1724) != null) {
            double dz;
            double dy;
            double dx = this.field_3874 - player.method_23317();
            double distSq = dx * dx + (dy = this.field_3854 - player.method_23318()) * dy + (dz = this.field_3871 - player.method_23321()) * dz;
            if (distSq > 625.0) {
                this.method_3085();
                return;
            }
            if (this.field_3854 > 192.0) {
                this.method_3085();
                return;
            }
        }
        if (this.field_3866 >= this.field_3847) {
            this.method_3085();
            return;
        }
        if (this.isDripping) {
            this.handleDripping();
        } else {
            this.handleFalling();
        }
        this.field_3841 = this.calculateAlpha();
        this.field_3874 += this.field_3852;
        this.field_3854 += this.field_3869;
        this.field_3871 += this.field_3850;
        this.method_18142(this.spriteProvider);
        ++this.field_3866;
    }

    private void handleFalling() {
        class_2338 currentPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        class_243 currentVec = new class_243(this.field_3874, this.field_3854, this.field_3871);
        class_243 nextVec = currentVec.method_1031(this.field_3852, this.field_3869, this.field_3850);
        int steps = Math.max(1, (int)Math.ceil(nextVec.method_1020(currentVec).method_1033() / 0.1));
        for (int i = 1; i <= steps; ++i) {
            double worldHitBoxTopY;
            class_2350 hitFace;
            class_265 shape;
            double checkZ;
            double checkY;
            double t = (double)i / (double)steps;
            double checkX = class_3532.method_16436((double)t, (double)this.field_3874, (double)nextVec.field_1352);
            class_2338 checkPos = class_2338.method_49637((double)checkX, (double)(checkY = class_3532.method_16436((double)t, (double)this.field_3854, (double)nextVec.field_1351)), (double)(checkZ = class_3532.method_16436((double)t, (double)this.field_3871, (double)nextVec.field_1350)));
            class_3610 fluidState = this.field_3851.method_8316(checkPos);
            if (!fluidState.method_15769()) {
                this.spawnSplashParticle(checkPos, checkX, checkZ);
                this.method_3085();
                return;
            }
            class_2680 blockState = this.field_3851.method_8320(checkPos);
            if (blockState.method_26215() || (shape = blockState.method_26220((class_1922)this.field_3851, checkPos)).method_1110()) continue;
            double relX = checkX - (double)checkPos.method_10263();
            double relY = checkY - (double)checkPos.method_10264();
            double relZ = checkZ - (double)checkPos.method_10260();
            boolean hitShape = shape.method_1090().stream().anyMatch(box -> box.method_1008(relX, relY, relZ));
            if (!hitShape) continue;
            double hitBoxMaxY = 0.0;
            for (class_238 box2 : shape.method_1090()) {
                if (!box2.method_1008(relX, relY, relZ)) continue;
                hitBoxMaxY = box2.field_1325;
                break;
            }
            if ((hitFace = this.field_3854 > (worldHitBoxTopY = (double)checkPos.method_10264() + hitBoxMaxY) + 0.001 ? class_2350.field_11036 : this.determineHitFace(currentPos, checkPos)) == class_2350.field_11043 || hitFace == class_2350.field_11035 || hitFace == class_2350.field_11034 || hitFace == class_2350.field_11039) {
                if (blockState.method_26164(class_3481.field_15503) || blockState.method_26164(class_3481.field_29822) || blockState.method_26164(class_3481.field_15462) || blockState.method_26164(class_3481.field_20339) || blockState.method_26164(class_3481.field_20341) || blockState.method_27852(class_2246.field_10336)) {
                    this.method_3085();
                    return;
                }
                this.startDripping(hitFace);
                return;
            }
            if (blockState.method_26164(class_3481.field_15462) || blockState.method_26164(class_3481.field_20339) || blockState.method_26164(class_3481.field_20341) || blockState.method_27852(class_2246.field_10336)) {
                this.method_3085();
                return;
            }
            this.spawnSplashParticle(checkPos, checkX, checkZ);
            this.method_3085();
            return;
        }
        if (this.field_3845) {
            this.spawnSplashParticle(currentPos.method_10074(), this.field_3874, this.field_3871);
            this.method_3085();
        }
    }

    private class_2350 determineHitFace(class_2338 from, class_2338 to) {
        if (to.method_10264() < from.method_10264()) {
            return class_2350.field_11036;
        }
        if (to.method_10264() > from.method_10264()) {
            return class_2350.field_11033;
        }
        if (to.method_10263() > from.method_10263()) {
            return class_2350.field_11039;
        }
        if (to.method_10263() < from.method_10263()) {
            return class_2350.field_11034;
        }
        if (to.method_10260() > from.method_10260()) {
            return class_2350.field_11043;
        }
        if (to.method_10260() < from.method_10260()) {
            return class_2350.field_11035;
        }
        return null;
    }

    private void startDripping(class_2350 face) {
        this.isDripping = true;
        this.wallFace = face;
        this.field_3847 = this.field_3866 + 60;
        this.leftWallAge = -1;
        this.field_17867 = this.baseScale * (0.8f + this.field_3840.method_43057() * 0.4f);
        this.hangDelayTicks = 10 + this.field_3840.method_43048(21);
        this.wallX = this.field_3874;
        this.wallZ = this.field_3871;
        double offset = 0.01;
        switch (face) {
            case field_11043: {
                this.field_3871 = Math.ceil(this.field_3871) - offset;
                break;
            }
            case field_11035: {
                this.field_3871 = Math.floor(this.field_3871) + offset;
                break;
            }
            case field_11034: {
                this.field_3874 = Math.floor(this.field_3874) + offset;
                break;
            }
            case field_11039: {
                this.field_3874 = Math.ceil(this.field_3874) - offset;
            }
        }
        this.field_3852 = 0.0;
        this.field_3869 = -0.1f - this.field_3840.method_43057() * 0.05f;
        this.field_3850 = 0.0;
        double wiggle = (this.field_3840.method_43058() - 0.5) * 0.01;
        if (face == class_2350.field_11043 || face == class_2350.field_11035) {
            this.field_3852 = wiggle;
        } else {
            this.field_3850 = wiggle;
        }
    }

    private void handleDripping() {
        class_265 shape;
        class_265 wallShape;
        class_2338 currentPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        class_2338 nextPos = class_2338.method_49637((double)(this.field_3874 + this.field_3852), (double)(this.field_3854 + this.field_3869), (double)(this.field_3871 + this.field_3850));
        if (this.wallFace == null) {
            int ticksSinceLeftWall;
            if (this.leftWallAge == -1) {
                this.leftWallAge = this.field_3866;
            }
            if ((ticksSinceLeftWall = this.field_3866 - this.leftWallAge) <= this.hangDelayTicks) {
                this.field_3869 = 0.0;
                this.field_3852 = 0.0;
                this.field_3850 = 0.0;
            } else {
                float timeFactor = Math.min((float)(ticksSinceLeftWall - this.hangDelayTicks) * 0.03f, 0.7f);
                this.field_3869 = -0.1f - timeFactor;
                this.field_3852 = 0.0;
                this.field_3850 = 0.0;
            }
            class_3610 fluidState = this.field_3851.method_8316(nextPos);
            if (!fluidState.method_15769()) {
                this.spawnSplashParticle(nextPos, this.field_3874, this.field_3871);
                this.method_3085();
                return;
            }
            class_2680 blockState = this.field_3851.method_8320(nextPos);
            if (!blockState.method_26215() && !blockState.method_26220((class_1922)this.field_3851, nextPos).method_1110()) {
                this.spawnSplashParticle(nextPos, this.field_3874, this.field_3871);
                this.method_3085();
                return;
            }
            if (this.field_3845) {
                this.spawnSplashParticle(currentPos.method_10074(), this.field_3874, this.field_3871);
                this.method_3085();
            }
            return;
        }
        class_2338 wallCheckPos = currentPos.method_10093(this.wallFace.method_10153());
        class_2680 wallState = this.field_3851.method_8320(wallCheckPos);
        boolean onValidWallSurface = false;
        if (!wallState.method_26215() && !(wallShape = wallState.method_26220((class_1922)this.field_3851, wallCheckPos)).method_1110()) {
            double relX = this.field_3874 - (double)wallCheckPos.method_10263();
            double relY = this.field_3854 - (double)wallCheckPos.method_10264();
            double relZ = this.field_3871 - (double)wallCheckPos.method_10260();
            onValidWallSurface = wallShape.method_1090().stream().anyMatch(box -> switch (this.wallFace) {
                case class_2350.field_11043 -> {
                    if (relZ >= box.field_1321 - 0.1 && relZ <= box.field_1324 && relX >= box.field_1323 && relX <= box.field_1320 && relY >= box.field_1322 && relY <= box.field_1325) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11035 -> {
                    if (relZ >= box.field_1321 && relZ <= box.field_1324 + 0.1 && relX >= box.field_1323 && relX <= box.field_1320 && relY >= box.field_1322 && relY <= box.field_1325) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11034 -> {
                    if (relX >= box.field_1323 && relX <= box.field_1320 + 0.1 && relZ >= box.field_1321 && relZ <= box.field_1324 && relY >= box.field_1322 && relY <= box.field_1325) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11039 -> {
                    if (relX >= box.field_1323 - 0.1 && relX <= box.field_1320 && relZ >= box.field_1321 && relZ <= box.field_1324 && relY >= box.field_1322 && relY <= box.field_1325) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            });
        }
        if (!onValidWallSurface) {
            int ticksSinceLeftWall;
            if (this.leftWallAge == -1) {
                this.leftWallAge = this.field_3866;
            }
            if ((ticksSinceLeftWall = this.field_3866 - this.leftWallAge) <= this.hangDelayTicks) {
                this.field_3869 = 0.0;
                this.field_3852 = 0.0;
                this.field_3850 = 0.0;
            } else {
                float timeFactor = Math.min((float)(ticksSinceLeftWall - this.hangDelayTicks) * 0.03f, 0.7f);
                this.field_3869 = -0.1f - timeFactor;
                this.field_3852 = 0.0;
                this.field_3850 = 0.0;
            }
        } else {
            this.leftWallAge = -1;
            switch (this.wallFace) {
                case field_11043: 
                case field_11035: {
                    this.field_3874 = this.wallX;
                    break;
                }
                case field_11034: 
                case field_11039: {
                    this.field_3871 = this.wallZ;
                }
            }
        }
        class_3610 fluidState = this.field_3851.method_8316(nextPos);
        if (!fluidState.method_15769()) {
            this.spawnSplashParticle(nextPos, this.field_3874, this.field_3871);
            this.method_3085();
            return;
        }
        class_2680 blockState = this.field_3851.method_8320(nextPos);
        if (!blockState.method_26215() && !(shape = blockState.method_26220((class_1922)this.field_3851, nextPos)).method_1110()) {
            double relX = this.field_3874 + this.field_3852 - (double)nextPos.method_10263();
            double relY = this.field_3854 + this.field_3869 - (double)nextPos.method_10264();
            double relZ = this.field_3871 + this.field_3850 - (double)nextPos.method_10260();
            boolean hitShape = shape.method_1090().stream().anyMatch(box -> box.method_1008(relX, relY, relZ));
            if (hitShape) {
                this.spawnSplashParticle(nextPos, this.field_3874, this.field_3871);
                this.method_3085();
                return;
            }
        }
        if (this.field_3845) {
            this.spawnSplashParticle(currentPos.method_10074(), this.field_3874, this.field_3871);
            this.method_3085();
        }
    }

    private void spawnSplashParticle(class_2338 hitPos, double hitX, double hitZ) {
        if (!ModConfig.getEnableRainHitParticles()) {
            return;
        }
        if (this.field_3840.method_43048(3) != 0) {
            return;
        }
        class_2680 blockState = this.field_3851.method_8320(hitPos);
        class_3610 fluidState = this.field_3851.method_8316(hitPos);
        class_2400 particleEffect = fluidState.method_15767(class_3486.field_15518) || blockState.method_27852(class_2246.field_10092) || class_3922.method_23896((class_2680)blockState) ? class_2398.field_11251 : (fluidState.method_15767(class_3486.field_15517) ? ParticleRegistry.WATER_RIPPLE : ParticleRegistry.GROUND_RIPPLE);
        double d = class_3532.method_15350((double)(hitX - (double)hitPos.method_10263()), (double)0.01, (double)0.99);
        double e = class_3532.method_15350((double)(hitZ - (double)hitPos.method_10260()), (double)0.01, (double)0.99);
        class_265 voxelShape = blockState.method_26220((class_1922)this.field_3851, hitPos);
        double yOffset = 0.0;
        if (!voxelShape.method_1110()) {
            for (class_238 box : voxelShape.method_1090()) {
                if (!(d >= box.field_1323) || !(d <= box.field_1320) || !(e >= box.field_1321) || !(e <= box.field_1324)) continue;
                yOffset = Math.max(yOffset, box.field_1325);
            }
        }
        double fluidHeight = fluidState.method_15763((class_1922)this.field_3851, hitPos);
        double finalYOffset = Math.max(yOffset, fluidHeight);
        this.field_3851.method_8406((class_2394)particleEffect, (double)hitPos.method_10263() + d, (double)hitPos.method_10264() + finalYOffset, (double)hitPos.method_10260() + e, 0.0, 0.0, 0.0);
    }

    private float calculateAlpha() {
        float baseAlpha = ModConfig.getRainAlpha();
        if (ModConfig.getEnableRainBasedAlphaLighting()) {
            class_2338 particlePos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
            int blockLight = this.field_3851.method_8314(class_1944.field_9282, particlePos);
            baseAlpha = 0.3f + (float)blockLight / 15.0f * 0.7f;
        }
        if (this.isDripping) {
            if (this.field_3866 > this.field_3847 - 5) {
                return baseAlpha * ((float)(this.field_3847 - this.field_3866) / 5.0f);
            }
            return baseAlpha;
        }
        if (this.field_3866 < 5) {
            return baseAlpha * ((float)this.field_3866 / 5.0f);
        }
        if (this.field_3866 > this.field_3847 - 5) {
            return baseAlpha * ((float)(this.field_3847 - this.field_3866) / 5.0f);
        }
        return baseAlpha;
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        class_243 camPos = camera.method_19326();
        float offsetX = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - camPos.method_10216());
        float offsetY = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - camPos.method_10214());
        float offsetZ = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - camPos.method_10215());
        Vector3f deltaMotion = new Vector3f((float)this.field_3852, (float)this.field_3869, (float)this.field_3850);
        if (this.isDripping && deltaMotion.lengthSquared() < 1.0E-4f) {
            deltaMotion.set(0.0f, -1.0f, 0.0f);
        } else if (deltaMotion.lengthSquared() < 1.0E-4f) {
            deltaMotion.set(0.0f, -0.01f, 0.0f);
        }
        deltaMotion.normalize();
        float angle = (float)Math.acos(class_3532.method_15363((float)deltaMotion.y, (float)-1.0f, (float)1.0f));
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x());
        float axisLengthSq = axis.lengthSquared();
        if (axisLengthSq > 1.0E-4f) {
            axis.normalize();
        } else {
            axis.set(1.0f, 0.0f, 0.0f);
            angle = 0.0f;
        }
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, -axis.y, axis.z);
        quaternion.mul((Quaternionfc)new Quaternionf().rotateY((float)(Math.atan2(transformedOffset.x, transformedOffset.z) + Math.PI)));
        float stretchFactor = 1.0f;
        this.renderStretchedQuad(vertexConsumer, quaternion, offsetX, offsetY, offsetZ, tickDelta, stretchFactor);
    }

    private void renderStretchedQuad(class_4588 vertexConsumer, Quaternionf quaternion, float x, float y, float z, float tickDelta, float stretch) {
        float size = this.method_18132(tickDelta);
        float u0 = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();
        int light = this.method_3068(tickDelta);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, -stretch, size, u1, v1, light);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, 1.0f, stretch, size, u1, v0, light);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, stretch, size, u0, v0, light);
        this.renderVertex(vertexConsumer, quaternion, x, y, z, -1.0f, -stretch, size, u0, v1, light);
    }

    private void renderVertex(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float size, float u, float v, int light) {
        Vector3f vec = new Vector3f(xOffset, yOffset, 0.0f);
        vec.rotate((Quaternionfc)quaternion);
        vec.mul(size);
        vec.add(x, y, z);
        buffer.method_22912(vec.x(), vec.y(), vec.z()).method_22913(u, v).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841).method_60803(light);
    }

    public static class_4002 getStaticSpriteProvider() {
        return staticSpriteProvider;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public Factory(class_4002 spriteSet) {
            this.sprites = spriteSet;
            staticSpriteProvider = spriteSet;
        }

        public class_703 createParticle(class_2400 particleType, class_638 world, double x, double y, double z, double dx, double dy, double dz) {
            return new RainParticle(world, x, y, z, this.sprites, dx, dy, dz, false);
        }
    }
}

