/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.config;

import java.util.HashSet;
import java.util.Set;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.wind.WindMod;

public class ParticleWhitelist {
    private static final Set<String> WHITELIST = new HashSet<String>();
    private static final Set<String> DEFAULT_WHITELIST = new HashSet<String>(){
        {
            this.add("minecraft:smoke");
            this.add("minecraft:poof");
            this.add("minecraft:large_smoke");
            this.add("minecraft:campfire_cosy_smoke");
            this.add("minecraft:campfire_signal_smoke");
            this.add("minecraft:white_smoke");
            this.add("minecraft:gust");
            this.add("minecraft:gust_emitter");
            this.add("minecraft:gust_emitter_large");
            this.add("minecraft:gust_emitter_small");
            this.add("minecraft:small_gust");
            this.add("minecraft:gust_dust");
            this.add("minecraft:small_flame");
            this.add("minecraft:flame");
            this.add("minecraft:soul_fire_flame");
            this.add("minecraft:dust_plume");
            this.add("minecraft:dust_pillar");
        }
    };

    public static boolean isWhitelisted(String registryId) {
        boolean result = WHITELIST.contains(registryId);
        if (ModConfig.getParticleDebugMode() && !result) {
            WindMod.LOGGER.info("[ParticleWhitelist] Particle registryId not in whitelist: {}", (Object)registryId);
        }
        return result;
    }

    public static void addWhitelist(String registryId) {
        WHITELIST.add(registryId);
        if (ModConfig.getParticleDebugMode()) {
            WindMod.LOGGER.info("[ParticleWhitelist] Added to whitelist: {}", (Object)registryId);
        }
    }

    public static void removeWhitelist(String registryId) {
        WHITELIST.remove(registryId);
        if (ModConfig.getParticleDebugMode()) {
            WindMod.LOGGER.info("[ParticleWhitelist] Removed from whitelist: {}", (Object)registryId);
        }
    }

    public static void setWhitelist(Set<String> whitelist) {
        WHITELIST.clear();
        WHITELIST.addAll(whitelist);
        if (ModConfig.getParticleDebugMode()) {
            WindMod.LOGGER.info("[ParticleWhitelist] Set whitelist to: {}", whitelist);
        }
    }

    public static Set<String> getWhitelist() {
        return new HashSet<String>(WHITELIST);
    }

    public static Set<String> getDefaultWhitelist() {
        return new HashSet<String>(DEFAULT_WHITELIST);
    }

    static {
        WHITELIST.addAll(DEFAULT_WHITELIST);
    }
}

