/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.wind.WindManager;
import net.vibzz.immersivewind.wind.WindMod;

public class WindNetworking {
    public static final class_2960 WIND_SYNC = new class_2960("immersivewind", "wind_sync");
    public static final class_2960 IW_PING = new class_2960("immersivewind", "iw_ping");
    public static final class_2960 IW_PONG = new class_2960("immersivewind", "iw_pong");
    private static long lastServerSendTime = 0L;

    public static void register() {
        WindMod.LOGGER.info("Registering Wind networking...");
        PayloadTypeRegistry.playS2C().register(WindSyncPayload.ID, WindSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(WindSyncPayload.ID, WindSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ModPingPayload.ID, ModPingPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ModPongPayload.ID, ModPongPayload.CODEC);
        WindMod.LOGGER.info("Networking registered successfully!");
    }

    public static void registerServerHandlers() {
        ServerPlayNetworking.registerGlobalReceiver(ModPingPayload.ID, (payload, context) -> {
            if (ModConfig.getDebugMode()) {
                WindMod.LOGGER.info("Received mod ping from client, sending pong");
            }
            ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new ModPongPayload());
        });
    }

    public static void sendWindUpdate(class_3218 world) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastServerSendTime >= 1000L) {
            float weather = world.method_8546() ? 2.0f : (world.method_8419() ? 1.0f : 0.0f);
            WindSyncPayload payload = new WindSyncPayload(WindManager.currentWindDirection, WindManager.targetWindDirection, WindManager.currentWindStrength, WindManager.targetWindStrength, weather);
            for (class_3222 player : PlayerLookup.world((class_3218)world)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
            lastServerSendTime = currentTime;
            WindMod.LOGGER.debug("Sent wind update to clients - Dir: {} -> {}, Str: {} -> {}", (Object)WindManager.currentWindDirection, (Object)WindManager.targetWindDirection, (Object)WindManager.currentWindStrength, (Object)WindManager.targetWindStrength);
        }
    }

    public record WindSyncPayload(int currentDirection, int targetDirection, int currentStrength, int targetStrength, float weather) implements class_8710
    {
        public static final class_8710.class_9154<WindSyncPayload> ID = new class_8710.class_9154(WIND_SYNC);
        public static final class_9139<class_2540, WindSyncPayload> CODEC = new class_9139<class_2540, WindSyncPayload>(){

            public WindSyncPayload decode(class_2540 buf) {
                return new WindSyncPayload(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readFloat());
            }

            public void encode(class_2540 buf, WindSyncPayload value) {
                buf.method_53002(value.currentDirection());
                buf.method_53002(value.targetDirection());
                buf.method_53002(value.currentStrength());
                buf.method_53002(value.targetStrength());
                buf.method_52941(value.weather());
            }
        };

        public class_8710.class_9154<WindSyncPayload> method_56479() {
            return ID;
        }
    }

    public record ModPingPayload() implements class_8710
    {
        public static final class_8710.class_9154<ModPingPayload> ID = new class_8710.class_9154(IW_PING);
        public static final class_9139<class_2540, ModPingPayload> CODEC = class_9139.method_56431((Object)new ModPingPayload());

        public class_8710.class_9154<ModPingPayload> method_56479() {
            return ID;
        }
    }

    public record ModPongPayload() implements class_8710
    {
        public static final class_8710.class_9154<ModPongPayload> ID = new class_8710.class_9154(IW_PONG);
        public static final class_9139<class_2540, ModPongPayload> CODEC = class_9139.method_56431((Object)new ModPongPayload());

        public class_8710.class_9154<ModPongPayload> method_56479() {
            return ID;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class WindNetworkingClient {
        private static long lastUpdateTime = 0L;
        private static boolean isUpdating = false;
        private static boolean serverHasMod = false;
        private static boolean pingSent = false;
        private static long pingSentTime = 0L;
        private static final long PING_TIMEOUT = 5000L;

        public static boolean isServerModded() {
            return serverHasMod;
        }

        public static void setServerHasMod(boolean hasMod, String context) {
            serverHasMod = hasMod;
            WindMod.LOGGER.info("Immersive Winds mod status detected ({}): {}", (Object)context, (Object)(hasMod ? "INSTALLED" : "NOT INSTALLED"));
        }

        public static void sendPingToServer(class_310 client) {
            if (client.method_1562() != null && !client.method_1542() && !pingSent) {
                ClientPlayNetworking.send((class_8710)new ModPingPayload());
                pingSent = true;
                pingSentTime = System.currentTimeMillis();
            }
            if (client.method_1542()) {
                WindNetworkingClient.setServerHasMod(true, "Singleplayer");
            }
        }

        public static void checkPingTimeout(class_310 client) {
            if (client.method_1562() != null && !client.method_1542() && pingSent && !serverHasMod && System.currentTimeMillis() - pingSentTime > 5000L) {
                WindNetworkingClient.setServerHasMod(false, "Multiplayer Server");
                pingSent = false;
            }
        }

        public static void init() {
            WindMod.LOGGER.info("Initializing client-side wind networking...");
            ClientPlayNetworking.registerGlobalReceiver(ModPongPayload.ID, (payload, context) -> WindNetworkingClient.setServerHasMod(true, "Multiplayer Server"));
            ClientPlayNetworking.registerGlobalReceiver(WindSyncPayload.ID, (payload, context) -> {
                if (isUpdating) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastUpdateTime >= 1000L) {
                    isUpdating = true;
                    context.client().execute(() -> {
                        try {
                            if (ModConfig.getDebugMode()) {
                                WindMod.LOGGER.info("Received wind update from server - Direction: {} -> {}, Strength: {} -> {}", (Object)payload.currentDirection(), (Object)payload.targetDirection(), (Object)payload.currentStrength(), (Object)payload.targetStrength());
                            }
                            WindManager.receiveWindFromServer(payload.currentDirection(), payload.currentStrength(), payload.targetDirection(), payload.targetStrength());
                            lastUpdateTime = currentTime;
                        }
                        finally {
                            isUpdating = false;
                        }
                    });
                }
            });
            WindMod.LOGGER.info("Client-side wind networking initialized!");
        }
    }
}

