/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.vibzz.immersivewind.config.ParticleWhitelist;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"ImmersiveWind");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("immersivewind.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static float fogRainMultiplier = 1.0f;
    private static float fogThunderMultiplier = 2.0f;
    private static boolean debugMode = false;
    private static boolean particleDebugMode = false;
    private static boolean enableWind = true;
    private static boolean enableWindWisps = true;
    private static boolean enableRainHitParticles = true;
    private static boolean enableDripSplashParticles = true;
    private static int rainBoxSize = 15;
    private static int rainBoxHeight = 15;
    private static double rainParticleCount = 200.0;
    private static boolean lockWindDirection = false;
    private static int lockedWindDirection = 0;
    private static boolean lockWindStrength = false;
    private static int lockedWindStrength = 5;
    private static float rainAlpha = 0.6f;
    private static boolean enableRainBasedAlphaLighting = false;

    public static void loadConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                ConfigData configData = (ConfigData)GSON.fromJson(json, ConfigData.class);
                if (configData != null) {
                    fogRainMultiplier = configData.fogRainMultiplier;
                    fogThunderMultiplier = configData.fogThunderMultiplier;
                    enableWind = configData.enableWind;
                    enableWindWisps = configData.enableWindWisps;
                    enableRainHitParticles = configData.enableRainHitParticles;
                    enableDripSplashParticles = configData.enableSplashParticles;
                    rainBoxSize = configData.rainBoxSize;
                    rainBoxHeight = configData.rainBoxHeight;
                    rainParticleCount = configData.rainParticleCount;
                    lockWindDirection = configData.lockWindDirection;
                    lockedWindDirection = configData.lockedWindDirection;
                    lockWindStrength = configData.lockWindStrength;
                    lockedWindStrength = configData.lockedWindStrength;
                    debugMode = configData.debugMode;
                    particleDebugMode = configData.particleDebugMode;
                    rainAlpha = configData.rainAlpha;
                    enableRainBasedAlphaLighting = configData.enableRainBasedAlphaLighting;
                    if (configData.particleWhitelist != null) {
                        ParticleWhitelist.setWhitelist(configData.particleWhitelist);
                        if (particleDebugMode) {
                            LOGGER.info("Loaded particle blacklist: {}", configData.particleWhitelist);
                        }
                    }
                }
            } else {
                ModConfig.saveConfig();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config file", (Throwable)e);
        }
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            ConfigData configData = new ConfigData();
            configData.enableWind = enableWind;
            configData.enableWindWisps = enableWindWisps;
            configData.enableRainHitParticles = enableRainHitParticles;
            configData.enableSplashParticles = enableDripSplashParticles;
            configData.fogRainMultiplier = fogRainMultiplier;
            configData.fogThunderMultiplier = fogThunderMultiplier;
            configData.rainBoxSize = rainBoxSize;
            configData.rainBoxHeight = rainBoxHeight;
            configData.rainParticleCount = rainParticleCount;
            configData.lockWindDirection = lockWindDirection;
            configData.lockedWindDirection = lockedWindDirection;
            configData.lockWindStrength = lockWindStrength;
            configData.lockedWindStrength = lockedWindStrength;
            configData.debugMode = debugMode;
            configData.particleDebugMode = particleDebugMode;
            configData.particleWhitelist = ParticleWhitelist.getWhitelist();
            configData.rainAlpha = rainAlpha;
            configData.enableRainBasedAlphaLighting = enableRainBasedAlphaLighting;
            String json = GSON.toJson((Object)configData);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            if (particleDebugMode) {
                LOGGER.info("Saved config with particle blacklist: {}", configData.particleWhitelist);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public static float getFogRainMultiplier() {
        return fogRainMultiplier;
    }

    public static void setFogRainMultiplier(float value) {
        fogRainMultiplier = Math.min(Math.max(value, 0.0f), 5.0f);
    }

    public static float getFogThunderMultiplier() {
        return fogThunderMultiplier;
    }

    public static void setFogThunderMultiplier(float value) {
        fogThunderMultiplier = Math.min(Math.max(value, 0.0f), 5.0f);
    }

    public static boolean getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(boolean value) {
        debugMode = value;
    }

    public static boolean getParticleDebugMode() {
        return particleDebugMode;
    }

    public static void setParticleDebugMode(boolean value) {
        particleDebugMode = value;
    }

    public static float getRainBoxSize() {
        return rainBoxSize;
    }

    public static void setRainBoxSize(int value) {
        rainBoxSize = value;
    }

    public static float getRainBoxHeight() {
        return rainBoxHeight;
    }

    public static void setRainBoxHeight(int value) {
        rainBoxHeight = value;
    }

    public static double getRainParticleCount() {
        return rainParticleCount;
    }

    public static void setRainParticleCount(double value) {
        rainParticleCount = value;
    }

    public static boolean getEnableWind() {
        return enableWind;
    }

    public static void setEnableWind(boolean value) {
        enableWind = value;
    }

    public static boolean getEnableWindWisps() {
        return enableWindWisps;
    }

    public static void setEnableWindWisps(boolean value) {
        enableWindWisps = value;
    }

    public static boolean getEnableRainHitParticles() {
        return enableRainHitParticles;
    }

    public static void setEnableRainHitParticles(boolean value) {
        enableRainHitParticles = value;
    }

    public static boolean getEnableDripSplashParticles() {
        return enableDripSplashParticles;
    }

    public static void setEnableDripSplashParticles(boolean value) {
        enableDripSplashParticles = value;
    }

    public static boolean getLockWindDirection() {
        return lockWindDirection;
    }

    public static void setLockWindDirection(boolean value) {
        lockWindDirection = value;
    }

    public static int getLockedWindDirection() {
        return lockedWindDirection;
    }

    public static void setLockedWindDirection(int value) {
        lockedWindDirection = Math.max(0, Math.min(359, value));
    }

    public static boolean getLockWindStrength() {
        return lockWindStrength;
    }

    public static void setLockWindStrength(boolean value) {
        lockWindStrength = value;
    }

    public static int getLockedWindStrength() {
        return lockedWindStrength;
    }

    public static void setLockedWindStrength(int value) {
        lockedWindStrength = Math.max(0, Math.min(30, value));
    }

    public static float getRainAlpha() {
        return rainAlpha;
    }

    public static void setRainAlpha(float value) {
        rainAlpha = Math.max(0.0f, Math.min(1.0f, value));
    }

    public static boolean getEnableRainBasedAlphaLighting() {
        return enableRainBasedAlphaLighting;
    }

    public static void setEnableRainBasedAlphaLighting(boolean value) {
        enableRainBasedAlphaLighting = value;
    }

    public static class ConfigData {
        boolean enableWind = true;
        boolean enableWindWisps = true;
        boolean enableRainHitParticles = true;
        boolean enableSplashParticles = true;
        float fogRainMultiplier = 1.0f;
        float fogThunderMultiplier = 2.0f;
        int rainBoxSize = 15;
        int rainBoxHeight = 25;
        double rainParticleCount = 200.0;
        boolean debugMode = false;
        boolean particleDebugMode = false;
        Set<String> particleWhitelist = new HashSet<String>();
        boolean lockWindDirection = false;
        int lockedWindDirection = 0;
        boolean lockWindStrength = false;
        int lockedWindStrength = 5;
        float rainAlpha = 0.6f;
        boolean enableRainBasedAlphaLighting = false;
    }
}

