/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.entityblocks;

import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3749;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.vibzz.immersivewind.entityblocks.LanternBlockEntity;
import net.vibzz.immersivewind.wind.WindManager;
import org.joml.Quaternionfc;

public class LanternBlockEntityRenderer
implements class_827<LanternBlockEntity, LanternRenderState> {
    private static final class_2960 LANTERN_TEXTURE = class_2960.method_60655((String)"immersivewind", (String)"textures/block/lantern.png");
    private static final class_2960 SOUL_LANTERN_TEXTURE = class_2960.method_60655((String)"immersivewind", (String)"textures/block/soul_lantern.png");
    private final class_630 hangingLantern;
    private final class_630 standingLantern;

    public LanternBlockEntityRenderer(class_5614.class_5615 ctx) {
        class_5609 hangingData = new class_5609();
        class_5610 hangingPartData = hangingData.method_32111();
        hangingPartData.method_32117("body", class_5606.method_32108().method_32101(0, 12).method_32097(0.0f, 0.0f, 0.0f, 6.0f, 7.0f, 6.0f), class_5603.method_32091((float)5.0f, (float)1.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        hangingPartData.method_32117("top", class_5606.method_32108().method_32101(0, 3).method_32097(0.0f, 0.0f, 0.0f, 4.0f, 2.0f, 4.0f), class_5603.method_32091((float)6.0f, (float)8.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        hangingPartData.method_32117("connecting_chain", class_5606.method_32108().method_32101(18, 0).method_32097(-0.45f, 0.0f, 1.0f, 3.0f, 4.0f, 0.0f), class_5603.method_32091((float)6.5f, (float)11.0f, (float)8.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        hangingPartData.method_32117("hooks", class_5606.method_32108().method_32101(18, 2).method_32097(-1.0f, 0.0f, -0.45f, 0.0f, 6.0f, 3.0f), class_5603.method_32091((float)8.0f, (float)10.0f, (float)6.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        this.hangingLantern = hangingPartData.method_32112(24, 25);
        class_5609 standingData = new class_5609();
        class_5610 standingPartData = standingData.method_32111();
        standingPartData.method_32117("body", class_5606.method_32108().method_32101(0, 12).method_32097(0.0f, 0.0f, 0.0f, 6.0f, 7.0f, 6.0f), class_5603.method_32091((float)5.0f, (float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        standingPartData.method_32117("top", class_5606.method_32108().method_32101(0, 3).method_32097(0.0f, 0.0f, 0.0f, 4.0f, 2.0f, 4.0f), class_5603.method_32091((float)6.0f, (float)7.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        standingPartData.method_32117("standing_hook1", class_5606.method_32108().method_32101(18, 0).method_32097(-0.45f, -3.0f, 1.0f, 3.0f, 4.0f, 0.0f), class_5603.method_32091((float)6.5f, (float)10.0f, (float)8.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        standingPartData.method_32117("standing_hook2", class_5606.method_32108().method_32101(18, 0).method_32097(-0.45f, -3.0f, -1.0f, 3.0f, 4.0f, 0.0f), class_5603.method_32091((float)6.5f, (float)10.0f, (float)8.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        this.standingLantern = standingPartData.method_32112(24, 25);
    }

    public LanternRenderState createRenderState() {
        return new LanternRenderState();
    }

    public void updateRenderState(LanternBlockEntity blockEntity, LanternRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)state, tickProgress, cameraPos, crumblingOverlay);
        state.hasWorld = blockEntity.method_11002();
        if (!state.hasWorld) {
            return;
        }
        state.isHanging = (Boolean)blockEntity.method_11010().method_11654((class_2769)class_3749.field_16545);
        state.isSoulLantern = blockEntity.method_11010().method_27852(class_2246.field_22110);
        if (state.isHanging) {
            int windDirection = WindManager.getWindDirection();
            int windStrength = WindManager.getWindStrength();
            float windAngleRad = (float)Math.toRadians(windDirection);
            float windX = class_3532.method_15374((float)windAngleRad);
            float windZ = -class_3532.method_15362((float)windAngleRad);
            float windIntensity = (float)windStrength / 30.0f;
            float timeOffset = (float)(((Object)((Object)blockEntity)).hashCode() % 1000) * 0.1f;
            float correctedTicks = 0.0f;
            if (blockEntity.method_10997() != null) {
                correctedTicks = ((float)blockEntity.method_10997().method_8510() + tickProgress + timeOffset) % 12000.0f;
            }
            float sway = (float)blockEntity.swayTicks + tickProgress;
            float strength = sway / blockEntity.strengthDivisor;
            float animationTick = 0.0f;
            if (blockEntity.method_10997() != null) {
                animationTick = ((float)blockEntity.method_10997().method_8510() + tickProgress - sway + timeOffset) % 12000.0f * 0.1f;
            }
            float animationTick7 = animationTick * 0.7f;
            float animationTick3 = animationTick * 0.3f;
            float chainOscillation = class_3532.method_15374((float)animationTick);
            float chainOscillationPerp = class_3532.method_15362((float)animationTick7);
            float chainAmplitudeWithWind = 0.75f * windIntensity * strength;
            float chainAmplitudeAgainstWind = 0.54f * windIntensity * strength;
            float baseAmplitude = 0.05f * strength;
            float chainSwingAmplitude = chainOscillation > 0.0f ? baseAmplitude + chainAmplitudeWithWind : baseAmplitude + chainAmplitudeAgainstWind;
            float chainSwing = chainOscillation * chainSwingAmplitude;
            float chainPerpAmplitude = chainOscillationPerp > 0.0f ? baseAmplitude * 0.8f + chainAmplitudeWithWind * 0.5f : baseAmplitude * 0.8f + chainAmplitudeAgainstWind * 0.5f;
            float chainSwingPerp = chainOscillationPerp * chainPerpAmplitude;
            state.chainPitch = windZ * chainSwing + windX * chainSwingPerp;
            state.chainRoll = windX * chainSwing - windZ * chainSwingPerp;
            state.chainYaw = class_3532.method_15362((float)animationTick3) * 0.2f * strength * windIntensity;
            float idleStrength = (1.0f - windIntensity) * 0.5f;
            state.chainPitch += class_3532.method_15374((float)(correctedTicks * 0.04f)) * 0.03f * idleStrength;
            state.chainRoll += class_3532.method_15374((float)(correctedTicks * 0.06f)) * 0.02f * idleStrength;
            float lanternOscillation = class_3532.method_15374((float)(animationTick * 0.8f + 0.5f));
            float lanternOscillationPerp = class_3532.method_15362((float)(animationTick7 * 0.8f + 0.3f));
            float lanternAmplitudeWithWind = 0.15f * windIntensity * strength;
            float lanternAmplitudeAgainstWind = 0.1f * windIntensity * strength;
            float lanternBaseAmplitude = 0.05f * strength;
            float lanternSwingAmplitude = lanternOscillation > 0.0f ? lanternBaseAmplitude + lanternAmplitudeWithWind : lanternBaseAmplitude + lanternAmplitudeAgainstWind;
            float lanternSwing = lanternOscillation * lanternSwingAmplitude;
            float lanternPerpAmplitude = lanternOscillationPerp > 0.0f ? lanternBaseAmplitude * 0.8f + lanternAmplitudeWithWind * 0.5f : lanternBaseAmplitude * 0.8f + lanternAmplitudeAgainstWind * 0.5f;
            float lanternSwingPerp = lanternOscillationPerp * lanternPerpAmplitude;
            state.lanternPitch = windZ * lanternSwing + windX * lanternSwingPerp;
            state.lanternRoll = windX * lanternSwing - windZ * lanternSwingPerp;
            state.lanternYaw = class_3532.method_15362((float)(animationTick3 * 0.9f + 0.2f)) * 0.15f * strength * windIntensity;
        }
    }

    public void render(LanternRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (!state.hasWorld) {
            return;
        }
        matrices.method_22903();
        if (state.isHanging) {
            float chainPivotY = 0.875f;
            matrices.method_22904(0.5, (double)chainPivotY, 0.5);
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(state.chainRoll));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.chainPitch));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.chainYaw));
            matrices.method_22904(-0.5, (double)(-chainPivotY), -0.5);
            class_630 connectingChain = this.hangingLantern.method_32086("connecting_chain");
            class_630 hooks = this.hangingLantern.method_32086("hooks");
            class_2960 texture = state.isSoulLantern ? SOUL_LANTERN_TEXTURE : LANTERN_TEXTURE;
            class_1921 renderLayer = class_1921.method_23576((class_2960)texture);
            queue.method_73491(connectingChain, matrices, renderLayer, state.field_62676, class_4608.field_21444, null);
            queue.method_73491(hooks, matrices, renderLayer, state.field_62676, class_4608.field_21444, null);
            float lanternPivotY = 0.5625f;
            matrices.method_22904(0.5, (double)lanternPivotY, 0.5);
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotation(state.lanternRoll));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(state.lanternPitch));
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.lanternYaw));
            matrices.method_22904(-0.5, (double)(-lanternPivotY), -0.5);
            class_630 body = this.hangingLantern.method_32086("body");
            class_630 top = this.hangingLantern.method_32086("top");
            queue.method_73491(body, matrices, renderLayer, state.field_62676, class_4608.field_21444, null);
            queue.method_73491(top, matrices, renderLayer, state.field_62676, class_4608.field_21444, null);
        } else {
            class_2960 texture = state.isSoulLantern ? SOUL_LANTERN_TEXTURE : LANTERN_TEXTURE;
            class_1921 renderLayer = class_1921.method_23576((class_2960)texture);
            queue.method_73491(this.standingLantern, matrices, renderLayer, state.field_62676, class_4608.field_21444, null);
        }
        matrices.method_22909();
    }

    public static class LanternRenderState
    extends class_11954 {
        public boolean isHanging;
        public boolean isSoulLantern;
        public boolean hasWorld;
        public float chainPitch;
        public float chainRoll;
        public float chainYaw;
        public float lanternPitch;
        public float lanternRoll;
        public float lanternYaw;
    }
}

