/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.particle.windwisps;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class TrailParticleSubmittable
implements class_11659.class_11947,
class_11942 {
    private final List<TrailVertex> vertices = new ArrayList<TrailVertex>();
    private final RenderPipeline pipeline;
    private final class_2960 textureAtlas;
    private final boolean translucent;
    private int cachedIndexCount;
    private GpuBufferSlice cachedDynamicTransforms;

    public TrailParticleSubmittable(RenderPipeline pipeline, boolean translucent) {
        this(pipeline, class_1059.field_17898, translucent);
    }

    public TrailParticleSubmittable(RenderPipeline pipeline, class_2960 textureAtlas, boolean translucent) {
        this.pipeline = pipeline;
        this.textureAtlas = textureAtlas;
        this.translucent = translucent;
    }

    public void addVertex(float x, float y, float z, float u, float v, float r, float g, float b, float a, int light) {
        this.vertices.add(new TrailVertex(x, y, z, u, v, r, g, b, a, light));
    }

    public boolean isEmpty() {
        return this.vertices.isEmpty();
    }

    public void clear() {
        this.vertices.clear();
    }

    public void method_74316() {
        this.vertices.clear();
    }

    @Nullable
    public class_11944.class_12041 method_74755(class_11977.class_12051 cache) {
        if (this.vertices.isEmpty()) {
            return null;
        }
        int vertexCount = this.vertices.size();
        int indexCount = vertexCount / 4 * 6;
        try (class_9799 allocator = class_9799.method_72201((int)(vertexCount * class_290.field_1584.getVertexSize()));){
            class_287 builder = new class_287(allocator, VertexFormat.class_5596.field_27382, class_290.field_1584);
            for (TrailVertex v : this.vertices) {
                builder.method_22912(v.x, v.y, v.z).method_22913(v.u, v.v).method_22915(v.r, v.g, v.b, v.a).method_60803(v.light);
            }
            class_9801 builtBuffer = builder.method_60794();
            if (builtBuffer == null) {
                TrailVertex v;
                v = null;
                return v;
            }
            cache.method_74835(builtBuffer.method_60818());
            RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382).method_68274(indexCount);
            GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
            this.cachedIndexCount = indexCount;
            this.cachedDynamicTransforms = dynamicTransforms;
            class_11944.class_12041 class_120412 = new class_11944.class_12041(indexCount, dynamicTransforms, Collections.emptyMap());
            return class_120412;
        }
    }

    public void method_74324(class_11944.class_12041 buffers, class_11977.class_12051 cache, RenderPass renderPass, class_1060 textureManager, boolean translucentPass) {
        if (translucentPass != this.translucent) {
            return;
        }
        RenderSystem.class_5590 indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        renderPass.setVertexBuffer(0, cache.method_74834());
        renderPass.setIndexBuffer(indexBuffer.method_68274(this.cachedIndexCount), indexBuffer.method_31924());
        renderPass.setUniform("DynamicTransforms", this.cachedDynamicTransforms);
        renderPass.setPipeline(this.pipeline);
        renderPass.bindSampler("Sampler0", textureManager.method_4619(this.textureAtlas).method_71659());
        renderPass.drawIndexed(0, 0, this.cachedIndexCount, 1);
    }

    public void submit(class_11659 queue, class_12075 cameraRenderState) {
        if (!this.vertices.isEmpty()) {
            queue.method_74315((class_11659.class_11947)this);
        }
    }

    private record TrailVertex(float x, float y, float z, float u, float v, float r, float g, float b, float a, int light) {
    }
}

