/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.wind;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.network.WindNetworking;
import net.vibzz.immersivewind.sounds.ModSounds;
import net.vibzz.immersivewind.wind.WindMod;
import net.vibzz.immersivewind.wind.WindSaveData;

public class WindManager {
    private static final Random RANDOM = new Random();
    private static final long WIND_CHANGE_COOLDOWN_TICKS = 300L;
    private static final long INTERPOLATION_TICKS = 240L;
    private static final long SOUND_UPDATE_INTERVAL = 1000L;
    public static volatile int currentWindDirection = 0;
    public static volatile int targetWindDirection = 0;
    public static volatile int currentWindStrength = 5;
    public static volatile int targetWindStrength = 5;
    private static int startWindDirection = 0;
    private static int startWindStrength = 5;
    private static long interpolationStartTick = 0L;
    private static long lastWindUpdateTick = 0L;
    public static volatile int currentWeatherState = 0;
    private static int previousWeatherState = 0;
    public static boolean clientReceivedServerData = false;
    private static long lastSoundUpdateTime = 0L;
    private static float previousDirectionChange = 0.0f;

    public static void initializeWind(class_1937 world) {
        long currentTime;
        WindMod.LOGGER.info("Initializing wind system");
        WindSaveData saveData = WindSaveData.getServerState(world.method_8503());
        WindManager.setWindValues(saveData.getWindDirection(), saveData.getWindStrength(), saveData.getWeatherState());
        lastWindUpdateTick = currentTime = world.method_8510();
        interpolationStartTick = currentTime;
        WindManager.saveWindState(world);
        WindMod.LOGGER.info("Wind loaded from save data - Direction: {}, Strength: {}, Weather: {}", (Object)currentWindDirection, (Object)currentWindStrength, (Object)currentWeatherState);
        WindMod.LOGGER.info("Wind initialized");
    }

    @Environment(value=EnvType.CLIENT)
    public static void updateClient(class_1937 world) {
        class_310 client = class_310.method_1551();
        WindNetworking.WindNetworkingClient.checkPingTimeout(client);
        WindManager.interpolateWind(world);
        WindManager.updateSounds(world);
    }

    public static void updateServer(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        long currentTick = world.method_8510();
        int newWeatherState = WindManager.getWeatherState(world);
        boolean directionLocked = ModConfig.getLockWindDirection();
        boolean strengthLocked = ModConfig.getLockWindStrength();
        if (directionLocked || strengthLocked) {
            int lockedStr;
            int lockedDir = directionLocked ? ModConfig.getLockedWindDirection() : targetWindDirection;
            int n = lockedStr = strengthLocked ? ModConfig.getLockedWindStrength() : targetWindStrength;
            if (targetWindDirection != lockedDir || targetWindStrength != lockedStr) {
                WindManager.setTargetValues(lockedDir, lockedStr);
                interpolationStartTick = currentTick;
                if (ModConfig.getDebugMode()) {
                    if (directionLocked && strengthLocked) {
                        WindMod.LOGGER.info("Wind locked - Direction: {}\u00b0, Strength: {}", (Object)lockedDir, (Object)lockedStr);
                    } else if (directionLocked) {
                        WindMod.LOGGER.info("Wind direction locked to: {}\u00b0", (Object)lockedDir);
                    } else {
                        WindMod.LOGGER.info("Wind strength locked to: {}", (Object)lockedStr);
                    }
                }
            }
            if (newWeatherState != previousWeatherState) {
                WindManager.handleWeatherChangeWithLocks(world, newWeatherState, currentTick, directionLocked, strengthLocked);
            }
            WindManager.interpolateWind(world);
            WindManager.saveWindState(world);
            return;
        }
        if (newWeatherState != previousWeatherState) {
            WindManager.handleWeatherChange(world, newWeatherState, currentTick);
            return;
        }
        if (currentTick - lastWindUpdateTick >= 300L) {
            WindManager.updateWindValues(world, currentTick);
        }
        WindManager.interpolateWind(world);
        WindManager.saveWindState(world);
    }

    private static void handleWeatherChangeWithLocks(class_1937 world, int newWeatherState, long currentTick, boolean directionLocked, boolean strengthLocked) {
        if (ModConfig.getDebugMode()) {
            WindMod.LOGGER.info("Weather changed with locked parameters: {} -> {}", (Object)previousWeatherState, (Object)newWeatherState);
        }
        currentWeatherState = previousWeatherState = newWeatherState;
        int newDirection = directionLocked ? ModConfig.getLockedWindDirection() : WindManager.generateWindDirection();
        int newStrength = strengthLocked ? ModConfig.getLockedWindStrength() : WindManager.generateWindStrength(world);
        WindManager.setTargetValues(newDirection, newStrength);
        lastWindUpdateTick = interpolationStartTick = currentTick;
        if (ModConfig.getDebugMode()) {
            String dirMsg = directionLocked ? " (locked at " + newDirection + "\u00b0)" : " -> " + newDirection;
            String strMsg = strengthLocked ? " (locked at " + newStrength + ")" : " -> " + newStrength;
            WindMod.LOGGER.info("Updated wind - Dir{}, Str{}", (Object)dirMsg, (Object)strMsg);
        }
    }

    public static void receiveWindFromServer(int direction, int strength, int targetDir, int targetStr) {
        currentWindDirection = direction;
        currentWindStrength = strength;
        targetWindDirection = targetDir;
        targetWindStrength = targetStr;
        clientReceivedServerData = true;
    }

    public static void interpolateWind(class_1937 world) {
        long elapsedTicks = world.method_8510() - interpolationStartTick;
        if (elapsedTicks >= 240L) {
            currentWindDirection = targetWindDirection;
            currentWindStrength = targetWindStrength;
        } else {
            float progress = WindManager.smoothStep((float)elapsedTicks / 240.0f);
            WindManager.interpolateValues(progress);
        }
    }

    public static int getWindDirection() {
        return currentWindDirection;
    }

    public static int getWindStrength() {
        return currentWindStrength;
    }

    public static float calculateWindVolume() {
        return Math.min(1.0f, (float)currentWindStrength / 30.0f);
    }

    public static void saveWindState(class_1937 world) {
        if (!world.method_8608() && world.method_8503() != null) {
            WindSaveData saveData = WindSaveData.getServerState(world.method_8503());
            saveData.setWindData(currentWindDirection, currentWindStrength, currentWeatherState);
        }
    }

    private static void setWindValues(int direction, int strength, int weatherState) {
        targetWindDirection = startWindDirection = direction;
        currentWindDirection = startWindDirection;
        targetWindStrength = startWindStrength = strength;
        currentWindStrength = startWindStrength;
        currentWeatherState = weatherState;
    }

    private static void setTargetValues(int direction, int strength) {
        targetWindDirection = direction;
        targetWindStrength = strength;
        startWindDirection = currentWindDirection;
        startWindStrength = currentWindStrength;
    }

    private static int getWeatherState(class_1937 world) {
        if (world.method_8546()) {
            return 2;
        }
        if (world.method_8419()) {
            return 1;
        }
        return 0;
    }

    private static void handleWeatherChange(class_1937 world, int newWeatherState, long currentTick) {
        if (ModConfig.getDebugMode()) {
            WindMod.LOGGER.info("Weather changed: {} -> {}", (Object)previousWeatherState, (Object)newWeatherState);
        }
        currentWeatherState = previousWeatherState = newWeatherState;
        WindManager.updateWindValues(world, currentTick);
    }

    private static void updateWindValues(class_1937 world, long currentTick) {
        int newDirection = WindManager.generateWindDirection();
        int newStrength = WindManager.generateWindStrength(world);
        WindManager.setTargetValues(newDirection, newStrength);
        lastWindUpdateTick = interpolationStartTick = currentTick;
        if (ModConfig.getDebugMode()) {
            WindMod.LOGGER.info("Updated wind on server - Dir: {} -> {}, Str: {} -> {}", (Object)currentWindDirection, (Object)newDirection, (Object)currentWindStrength, (Object)newStrength);
        }
    }

    private static int generateWindDirection() {
        float change = RANDOM.nextFloat() < 0.7f && Math.abs(previousDirectionChange) > 5.0f ? previousDirectionChange * (0.3f + RANDOM.nextFloat() * 0.4f) + (RANDOM.nextFloat() * 20.0f - 10.0f) : RANDOM.nextFloat() * 60.0f - 30.0f;
        previousDirectionChange = change = class_3532.method_15363((float)change, (float)-45.0f, (float)45.0f);
        return WindManager.normalizeAngle(Math.round((float)currentWindDirection + change));
    }

    private static int generateWindStrength(class_1937 world) {
        float roll;
        int baseStrength = world.method_8546() ? ((roll = RANDOM.nextFloat()) < 0.7f ? RANDOM.nextInt(16) + 15 : RANDOM.nextInt(14) + 1) : (world.method_8419() ? ((roll = RANDOM.nextFloat()) < 0.65f ? RANDOM.nextInt(13) + 8 : (RANDOM.nextBoolean() ? RANDOM.nextInt(7) + 1 : RANDOM.nextInt(10) + 21)) : ((roll = RANDOM.nextFloat()) < 0.9f ? RANDOM.nextInt(12) + 1 : RANDOM.nextInt(18) + 13));
        return baseStrength;
    }

    private static void interpolateValues(float progress) {
        float easedProgress = WindManager.easeInOutCubic(progress);
        int angleDiff = targetWindDirection - startWindDirection;
        if (angleDiff > 180) {
            angleDiff -= 360;
        }
        if (angleDiff < -180) {
            angleDiff += 360;
        }
        currentWindDirection = WindManager.normalizeAngle(Math.round((float)startWindDirection + (float)angleDiff * easedProgress));
        int strengthDiff = targetWindStrength - startWindStrength;
        currentWindStrength = Math.round((float)startWindStrength + (float)strengthDiff * easedProgress);
    }

    private static void updateSounds(class_1937 world) {
        long currentTime = world.method_8510();
        if (currentTime - lastSoundUpdateTime >= 1000L) {
            for (class_1657 player : world.method_18456()) {
                ModSounds.playWindSound(player);
            }
            lastSoundUpdateTime = currentTime;
        }
    }

    private static int normalizeAngle(int angle) {
        return (angle % 360 + 360) % 360;
    }

    private static float easeInOutCubic(float t) {
        return t < 0.5f ? 4.0f * t * t * t : (float)(1.0 - Math.pow(-2.0f * t + 2.0f, 3.0) / 2.0);
    }

    private static float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }
}

