/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.wind;

import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.vibzz.immersivewind.util.WindRaycastDebugRenderer;
import net.vibzz.immersivewind.wind.WindManager;

public class WindParticleManager {
    private static final double DETECTION_DISTANCE = 15.0;
    private static final float ENCLOSED_THRESHOLD = 0.15f;
    private static final float BLOCKED_THRESHOLD = 0.3f;
    private final class_638 world;

    public WindParticleManager(class_638 world) {
        this.world = world;
    }

    public class_243 getWindEffect(class_2338 pos, class_243 velocity) {
        class_243 resultEffect;
        float windOpenness;
        double windZ;
        if (!this.world.method_27983().equals(class_1937.field_25179)) {
            return class_243.field_1353;
        }
        class_243 particlePos = class_243.method_24953((class_2382)pos);
        double angleRadians = Math.toRadians(WindManager.getWindDirection() + 90);
        double windStrength = (double)WindManager.getWindStrength() * 0.01;
        double windX = Math.sin(angleRadians) * windStrength;
        class_243 windVec = new class_243(windX, 0.0, windZ = -Math.cos(angleRadians) * windStrength);
        class_243 windDir = windVec.method_1027() > 0.0 ? windVec.method_1029() : class_243.field_1353;
        boolean hasVelocity = velocity.method_37268() > 1.0E-4;
        class_243 velocityDir = hasVelocity ? new class_243(velocity.field_1352, 0.0, velocity.field_1350).method_1029() : windDir;
        float velocityOpenness = this.checkDirectionOpenness(particlePos, velocityDir, "velocity");
        float averageOpenness = (velocityOpenness + (windOpenness = this.checkDirectionOpenness(particlePos, windDir, "wind"))) / 2.0f;
        float effectiveOpenness = (float)Math.pow(averageOpenness, 1.5);
        if (effectiveOpenness < 0.15f) {
            return class_243.field_1353;
        }
        if (windOpenness > 0.8f) {
            resultEffect = windVec;
        } else if (windOpenness > 0.3f) {
            resultEffect = windVec.method_1021((double)windOpenness);
        } else {
            float deflectOpenness;
            class_243 deflectDir;
            float rightOpenness;
            class_243 perpLeft = new class_243(-windDir.field_1350, 0.0, windDir.field_1352);
            class_243 perpRight = new class_243(windDir.field_1350, 0.0, -windDir.field_1352);
            float leftOpenness = this.checkDirectionOpenness(particlePos, perpLeft, "deflect-L");
            if (leftOpenness > (rightOpenness = this.checkDirectionOpenness(particlePos, perpRight, "deflect-R"))) {
                deflectDir = perpLeft;
                deflectOpenness = leftOpenness;
            } else {
                deflectDir = perpRight;
                deflectOpenness = rightOpenness;
            }
            if (deflectOpenness > 0.5f) {
                float deflectionStrength = 1.0f - windOpenness;
                double deflectedX = windX * (double)windOpenness + deflectDir.field_1352 * windStrength * (double)deflectionStrength * (double)deflectOpenness;
                double deflectedZ = windZ * (double)windOpenness + deflectDir.field_1350 * windStrength * (double)deflectionStrength * (double)deflectOpenness;
                resultEffect = new class_243(deflectedX, 0.0, deflectedZ);
            } else {
                resultEffect = windVec.method_1021((double)(windOpenness * 0.2f));
            }
        }
        return resultEffect.method_1021((double)effectiveOpenness);
    }

    private float checkDirectionOpenness(class_243 pos, class_243 direction, String debugLabel) {
        if (direction.method_1027() < 1.0E-4) {
            return 1.0f;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return 1.0f;
        }
        class_243 end = pos.method_1019(direction.method_1021(15.0));
        class_3965 hit = this.world.method_17742(new class_3959(pos, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)player));
        boolean didHit = hit.method_17783() != class_239.class_240.field_1333;
        double hitDistance = didHit ? hit.method_17784().method_1022(pos) : 15.0;
        class_243 actualEnd = didHit ? hit.method_17784() : end;
        WindRaycastDebugRenderer.add(pos, actualEnd, didHit, hitDistance, 15.0);
        if (!didHit) {
            return 1.0f;
        }
        return (float)(hitDistance / 15.0);
    }
}

