/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.particle.windwisps;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7833;
import net.vibzz.immersivewind.particle.windwisps.TrailParticleEffect;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ProjectileTrailParticle
extends class_4003 {
    private final class_4002 spriteProvider;
    float roll;
    float yaw;
    float pitch;
    float prevRoll;
    float prevYaw;
    float prevPitch;
    class_243 position;
    class_243 prevPosition;
    float startGap;
    float endGap;
    float gap;
    float prevGap;
    float prevAlpha;
    float startAlpha;
    float endAlpha;
    int index;
    ArrayList<class_243> prevPositions = new ArrayList();
    ArrayList<Quaternionf> angles = new ArrayList();
    ArrayList<Float> tickDeltas = new ArrayList();

    protected ProjectileTrailParticle(class_638 clientWorld, double x, double y, double z, class_4002 spriteProvider) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.spriteProvider = spriteProvider;
        this.method_18142(spriteProvider);
        this.field_3847 = 8;
        this.field_17867 = 0.03f;
        this.method_3080(1.0f, 1.0f);
    }

    public int method_3068(float tint) {
        return 0xF000F0;
    }

    public void setStartGap(float start, float end) {
        this.startGap = start;
        this.endGap = end;
        this.gap = start;
        this.prevGap = start;
    }

    public void setStartAlpha(float start, float end) {
        this.startAlpha = start;
        this.endAlpha = end;
        this.field_3841 = start;
        this.prevAlpha = start;
    }

    public void method_3070() {
        this.prevGap = this.gap;
        this.prevAlpha = this.field_3841;
        this.gap = this.gap == (float)(this.field_3847 - 1) ? this.endGap : class_3532.method_16439((float)(((float)this.field_3866 + 1.0f) / (float)this.field_3847), (float)this.startGap, (float)this.endGap);
        this.field_3841 = class_3532.method_16439((float)(((float)this.field_3866 + 1.0f) / (float)this.field_3847), (float)this.startAlpha, (float)this.endAlpha);
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        } else {
            this.method_18142(this.spriteProvider);
        }
    }

    public void setStart(class_243 pos, class_243 angles) {
        this.prevPosition = pos;
        Quaternionf quaternionf = class_7833.field_40716.rotationDegrees((float)angles.field_1351 - 90.0f).mul((Quaternionfc)class_7833.field_40718.rotationDegrees((float)angles.field_1350 + 90.0f)).mul((Quaternionfc)class_7833.field_40714.rotationDegrees((float)angles.field_1352)).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
        this.angles.add(quaternionf);
        this.prevPositions.add(pos);
        this.tickDeltas.add(Float.valueOf(0.0f));
    }

    protected float getGap(float tickDelta) {
        float headGap = this.startGap - this.startGap / (float)Math.min(this.field_3866 + this.index, this.field_3847) * (float)Math.min(this.field_3866, this.field_3847);
        float tailGap = this.startGap - this.startGap / (float)Math.min(this.field_3866 + this.index, this.field_3847) * (float)Math.min(this.field_3866 + 1, this.field_3847);
        return tickDelta == 0.0f ? tailGap : (tickDelta == 1.0f ? headGap : class_3532.method_16439((float)tickDelta, (float)tailGap, (float)headGap));
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        if (this.field_3866 == 0) {
            if (this.prevPositions.isEmpty()) {
                this.setStart(this.prevPosition, new class_243((double)this.prevRoll, (double)this.prevYaw, (double)this.prevPitch));
            } else if (this.tickDeltas.isEmpty() || this.tickDeltas.get(this.tickDeltas.size() - 1).floatValue() != tickDelta) {
                float yaw = class_3532.method_16439((float)tickDelta, (float)this.prevYaw, (float)this.yaw);
                float pitch = class_3532.method_16439((float)tickDelta, (float)this.prevPitch, (float)this.pitch);
                float roll = class_3532.method_16439((float)tickDelta, (float)this.prevRoll, (float)this.roll);
                quaternionf = class_7833.field_40716.rotationDegrees(yaw - 90.0f).mul((Quaternionfc)class_7833.field_40718.rotationDegrees(pitch + 90.0f)).mul((Quaternionfc)class_7833.field_40714.rotationDegrees(roll)).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                float pX = (float)class_3532.method_16436((double)tickDelta, (double)this.prevPosition.field_1352, (double)this.position.field_1352);
                float pY = (float)class_3532.method_16436((double)tickDelta, (double)this.prevPosition.field_1351, (double)this.position.field_1351);
                float pZ = (float)class_3532.method_16436((double)tickDelta, (double)this.prevPosition.field_1350, (double)this.position.field_1350);
                class_243 pos = new class_243((double)pX, (double)pY, (double)pZ);
                if (this.field_3839 != 0.0f) {
                    quaternionf.rotateZ(class_3532.method_16439((float)tickDelta, (float)this.field_3857, (float)this.field_3839));
                }
                this.angles.add(quaternionf);
                this.prevPositions.add(pos);
                this.tickDeltas.add(Float.valueOf(tickDelta));
            }
        } else if (!this.tickDeltas.isEmpty() && this.tickDeltas.get(this.tickDeltas.size() - 1).floatValue() != 1.0f) {
            quaternionf = class_7833.field_40716.rotationDegrees(this.yaw - 90.0f).mul((Quaternionfc)class_7833.field_40718.rotationDegrees(this.pitch + 90.0f)).mul((Quaternionfc)class_7833.field_40714.rotationDegrees(this.roll)).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
            class_243 pos = new class_243(this.position.field_1352, this.position.field_1351, this.position.field_1350);
            if (this.field_3839 != 0.0f) {
                quaternionf.rotateZ(class_3532.method_16439((float)1.0f, (float)this.field_3857, (float)this.field_3839));
            }
            this.angles.add(quaternionf);
            this.prevPositions.add(pos);
            this.tickDeltas.add(Float.valueOf(1.0f));
        }
        for (int i = 0; i < this.prevPositions.size() - 1; ++i) {
            this.addQuad(vertexConsumer, camera, i);
        }
    }

    protected void addQuad(class_4588 vertexConsumer, class_4184 camera, int index) {
        class_243 pos1 = this.prevPositions.get(index);
        class_243 pos2 = this.prevPositions.get(index + 1);
        Quaternionf baseAngle1 = this.angles.get(index);
        Quaternionf baseAngle2 = this.angles.get(index + 1);
        float tickDelta1 = this.tickDeltas.get(index).floatValue();
        float tickDelta2 = this.tickDeltas.get(index + 1).floatValue();
        class_243 midpoint = pos1.method_1019(pos2).method_1021(0.5);
        Quaternionf fullRotation = this.createFullViewBillboard(camera.method_19326(), midpoint);
        Quaternionf angle1 = new Quaternionf((Quaternionfc)baseAngle1).mul((Quaternionfc)fullRotation);
        Quaternionf angle2 = new Quaternionf((Quaternionfc)baseAngle2).mul((Quaternionfc)fullRotation);
        float j = this.method_18132(tickDelta1);
        float j2 = this.method_18132(tickDelta2);
        float k = this.method_18133();
        float l = this.method_18134();
        float m = this.method_18135();
        float n = this.method_18136();
        int o = this.method_3068(tickDelta1);
        int o2 = this.method_3068(tickDelta2);
        pos1 = pos1.method_1020(camera.method_19326());
        pos2 = pos2.method_1020(camera.method_19326());
        this.addVertices(vertexConsumer, angle1, (float)pos1.field_1352, (float)pos1.field_1351, (float)pos1.field_1350, this.getGap(tickDelta1), j, k, class_3532.method_16439((float)tickDelta1, (float)n, (float)m), o, class_3532.method_16439((float)tickDelta1, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle1, (float)pos1.field_1352, (float)pos1.field_1351, (float)pos1.field_1350, -this.getGap(tickDelta1), j, l, class_3532.method_16439((float)tickDelta1, (float)n, (float)m), o, class_3532.method_16439((float)tickDelta1, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle2, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, -this.getGap(tickDelta2), j2, l, class_3532.method_16439((float)tickDelta2, (float)n, (float)m), o2, class_3532.method_16439((float)tickDelta2, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle2, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, this.getGap(tickDelta2), j2, k, class_3532.method_16439((float)tickDelta2, (float)n, (float)m), o2, class_3532.method_16439((float)tickDelta2, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle2, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, this.getGap(tickDelta2), j2, k, class_3532.method_16439((float)tickDelta2, (float)n, (float)m), o2, class_3532.method_16439((float)tickDelta2, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle2, (float)pos2.field_1352, (float)pos2.field_1351, (float)pos2.field_1350, -this.getGap(tickDelta2), j2, l, class_3532.method_16439((float)tickDelta2, (float)n, (float)m), o2, class_3532.method_16439((float)tickDelta2, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle1, (float)pos1.field_1352, (float)pos1.field_1351, (float)pos1.field_1350, -this.getGap(tickDelta1), j, l, class_3532.method_16439((float)tickDelta1, (float)n, (float)m), o, class_3532.method_16439((float)tickDelta1, (float)this.field_3841, (float)this.prevAlpha));
        this.addVertices(vertexConsumer, angle1, (float)pos1.field_1352, (float)pos1.field_1351, (float)pos1.field_1350, this.getGap(tickDelta1), j, k, class_3532.method_16439((float)tickDelta1, (float)n, (float)m), o, class_3532.method_16439((float)tickDelta1, (float)this.field_3841, (float)this.prevAlpha));
    }

    private void addVertices(class_4588 vertexConsumer, Quaternionf quaternionf, float f, float g, float h, float i, float k, float l, float m, int n, float alpha) {
        Vector3f vector3f = new Vector3f(i, 0.0f, 0.0f).rotate((Quaternionfc)quaternionf).mul(k).add(f, g, h);
        vertexConsumer.method_22912(vector3f.x(), vector3f.y(), vector3f.z()).method_22913(l, m).method_22915(this.field_3861, this.field_3842, this.field_3859, alpha).method_60803(n);
    }

    private Quaternionf createFullViewBillboard(class_243 cameraPos, class_243 particlePos) {
        class_243 particleToCamera = cameraPos.method_1020(particlePos);
        double horizontalDistance = Math.sqrt(particleToCamera.field_1352 * particleToCamera.field_1352 + particleToCamera.field_1350 * particleToCamera.field_1350);
        float yaw = (float)Math.toDegrees(Math.atan2(particleToCamera.field_1350, particleToCamera.field_1352));
        float pitch = (float)Math.toDegrees(Math.atan2(particleToCamera.field_1351, horizontalDistance));
        Quaternionf rotation = class_7833.field_40716.rotationDegrees(yaw);
        rotation.mul((Quaternionfc)class_7833.field_40714.rotationDegrees(pitch));
        rotation.mul((Quaternionfc)class_7833.field_40718.rotationDegrees(0.0f));
        return rotation;
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Factory
    implements class_707<TrailParticleEffect> {
        private final class_4002 spriteProvider;
        float startSize;
        float endSize;
        float startAlpha;
        float endAlpha;
        int maxAge;

        public Factory(class_4002 spriteProvider, float startSize, float endSize, float startAlpha, float endAlpha, int maxAge) {
            this.spriteProvider = spriteProvider;
            this.startSize = startSize;
            this.endSize = endSize;
            this.startAlpha = startAlpha;
            this.endAlpha = endAlpha;
            this.maxAge = maxAge;
        }

        public class_703 createParticle(TrailParticleEffect parameters, class_638 clientWorld, double x, double y, double z, double xd, double yd, double zd) {
            ProjectileTrailParticle streakParticle = new ProjectileTrailParticle(clientWorld, x, y, z, this.spriteProvider);
            int color = parameters.color();
            streakParticle.method_3084((float)class_5253.class_5254.method_27765((int)color) / 255.0f, (float)class_5253.class_5254.method_27766((int)color) / 255.0f, (float)class_5253.class_5254.method_27767((int)color) / 255.0f);
            class_243 ryp = parameters.RYP();
            streakParticle.roll = (float)ryp.field_1352;
            streakParticle.yaw = (float)ryp.field_1351;
            streakParticle.pitch = (float)ryp.field_1350;
            class_243 prevRyp = parameters.prev_RYP();
            streakParticle.prevRoll = (float)prevRyp.field_1352;
            streakParticle.prevYaw = (float)prevRyp.field_1351;
            streakParticle.prevPitch = (float)prevRyp.field_1350;
            streakParticle.position = parameters.pos();
            streakParticle.prevPosition = parameters.prev_pos();
            streakParticle.index = parameters.index();
            streakParticle.field_3847 = this.maxAge;
            streakParticle.setStartGap(this.startSize / 2.0f, this.endSize / 2.0f);
            float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
            streakParticle.setStartAlpha(this.startAlpha * alpha, this.endAlpha * alpha);
            return streakParticle;
        }
    }
}

