/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.entityblocks;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.wind.WindManager;
import net.vibzz.immersivewind.wind.WindMod;

public class LanternBlockEntity
extends class_2586 {
    public int swayTicks;
    public float strengthDivisor = 35.0f;
    protected int baselineSwayTicks;
    protected final int tickDisplacement;
    private float windExposure = 1.0f;
    private float windExposureInterpolated = 1.0f;
    private int occlusionTickCounter = 0;
    private static final int OCCLUSION_CHECK_INTERVAL = 10;
    private static final double DETECTION_RADIUS = 15.0;
    private static final int NUM_SAMPLES = 12;
    private static final float LEAF_TRANSPARENCY = 0.7f;
    private static final float INTERP_SPEED = 0.1f;
    private static final class_243[] SPHERE_DIRECTIONS = LanternBlockEntity.generateHorizontalCircle();

    public LanternBlockEntity(class_2338 pos, class_2680 state) {
        super(WindMod.LANTERN_ENTITY, pos, state);
        if (ModConfig.getDebugMode()) {
            WindMod.LOGGER.info("Created LanternBlockEntity at {}", (Object)pos);
        }
        this.swayTicks = 0;
        this.baselineSwayTicks = 0;
        this.tickDisplacement = Math.abs(pos.method_10263() + pos.method_10264() + pos.method_10260()) % 6;
    }

    private static class_243[] generateHorizontalCircle() {
        class_243[] samples = new class_243[12];
        for (int i = 0; i < 12; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / 12.0);
            samples[i] = new class_243(Math.cos(angle), 0.0, Math.sin(angle)).method_1029();
        }
        return samples;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, LanternBlockEntity entity) {
        if (!world.field_9236) {
            return;
        }
        ++entity.occlusionTickCounter;
        if (entity.occlusionTickCounter >= 10) {
            entity.occlusionTickCounter = 0;
            entity.calculateWindExposure(world);
        }
        entity.interpolateExposure();
        int windStrength = WindManager.getWindStrength();
        float exposedWindStrength = (float)windStrength * entity.windExposureInterpolated;
        entity.baselineSwayTicks = Math.round(exposedWindStrength * 0.87f);
        if (entity.swayTicks > entity.baselineSwayTicks) {
            --entity.swayTicks;
        }
        if (entity.swayTicks < entity.baselineSwayTicks) {
            ++entity.swayTicks;
        }
    }

    private void calculateWindExposure(class_1937 world) {
        class_1657 nearestPlayer = world.method_18459((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 64.0, false);
        if (nearestPlayer == null) {
            this.windExposure = 1.0f;
            return;
        }
        class_243 lanternPos = class_243.method_24953((class_2382)this.field_11867);
        class_243 windDir = this.getWindDirectionVector();
        int openRays = 0;
        float totalOpenness = 0.0f;
        for (class_243 dir : SPHERE_DIRECTIONS) {
            class_243 startPos = lanternPos.method_1019(dir.method_1021(0.6));
            class_243 endPos = lanternPos.method_1019(dir.method_1021(15.0));
            RaycastResult result = this.performLeafAwareRaycast(world, startPos, endPos, (class_1297)nearestPlayer);
            if (!result.hitSolid && result.transparency > 0.5f) {
                ++openRays;
                totalOpenness += result.transparency;
                continue;
            }
            if (!result.hitSolid) {
                totalOpenness += result.transparency;
                continue;
            }
            double hitDist = result.hitPos.method_1022(lanternPos);
            totalOpenness += (float)(hitDist / 15.0) * result.transparency * 0.3f;
        }
        float openRatio = (float)openRays / 12.0f;
        float avgOpenness = totalOpenness / 12.0f;
        float baseExposure = openRatio * 0.7f + avgOpenness * 0.3f;
        float upwindBonus = this.calculateUpwindBonus(world, lanternPos, windDir, (class_1297)nearestPlayer);
        this.windExposure = (baseExposure = Math.min(1.0f, baseExposure + upwindBonus * 0.3f)) > 0.4f ? 0.6f + (baseExposure - 0.4f) * 0.67f : baseExposure * 1.5f;
        this.windExposure = Math.max(0.08f, Math.min(1.0f, this.windExposure));
    }

    private float calculateUpwindBonus(class_1937 world, class_243 lanternPos, class_243 windDir, class_1297 entity) {
        class_243 startPos = lanternPos.method_1019(windDir.method_1021(0.6));
        class_243 endPos = lanternPos.method_1019(windDir.method_1021(15.0));
        RaycastResult result = this.performLeafAwareRaycast(world, startPos, endPos, entity);
        if (!result.hitSolid) {
            return result.transparency;
        }
        double hitDist = result.hitPos.method_1022(lanternPos);
        return (float)(hitDist / 15.0) * result.transparency;
    }

    private class_243 getWindDirectionVector() {
        int windDegrees = WindManager.getWindDirection();
        double radians = Math.toRadians(windDegrees);
        return new class_243(Math.sin(radians), 0.0, -Math.cos(radians)).method_1029();
    }

    private RaycastResult performLeafAwareRaycast(class_1937 world, class_243 start, class_243 end, class_1297 entity) {
        class_243 current = start;
        float transparency = 1.0f;
        int leafHits = 0;
        int MAX_LEAVES = 6;
        while (current.method_1022(start) < 15.0) {
            class_3959 ctx = new class_3959(current, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
            class_3965 hit = world.method_17742(ctx);
            if (hit.method_17783() == class_239.class_240.field_1333) {
                return new RaycastResult(false, end, transparency);
            }
            if (hit instanceof class_3965) {
                class_3965 blockHit = hit;
                class_2338 hitPos = blockHit.method_17777();
                class_2680 hitState = world.method_8320(hitPos);
                if (hitState.method_26164(class_3481.field_15503)) {
                    transparency *= 0.7f;
                    if (++leafHits >= 6 || transparency < 0.1f) {
                        return new RaycastResult(true, hit.method_17784(), transparency);
                    }
                    class_243 direction = end.method_1020(start).method_1029();
                    current = hit.method_17784().method_1019(direction.method_1021(0.1));
                    continue;
                }
                return new RaycastResult(true, hit.method_17784(), transparency);
            }
            return new RaycastResult(true, hit.method_17784(), transparency);
        }
        return new RaycastResult(false, end, transparency);
    }

    private void interpolateExposure() {
        float delta = this.windExposure - this.windExposureInterpolated;
        this.windExposureInterpolated = Math.abs(delta) > 0.001f ? (this.windExposureInterpolated += delta * 0.1f) : this.windExposure;
    }

    public float getWindExposure() {
        return this.windExposureInterpolated;
    }

    private static class RaycastResult {
        final boolean hitSolid;
        final class_243 hitPos;
        final float transparency;

        RaycastResult(boolean hitSolid, class_243 hitPos, float transparency) {
            this.hitSolid = hitSolid;
            this.hitPos = hitPos;
            this.transparency = transparency;
        }
    }
}

