/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.config.ParticleWhitelist;
import net.vibzz.immersivewind.sounds.ModSounds;
import net.vibzz.immersivewind.util.WindRaycastDebugRenderer;
import net.vibzz.immersivewind.wind.WindMod;

public class ModMenuIntegration
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)class_2561.method_43470((String)("Immersive Winds " + WindMod.VERSION))).setParentScreen(parent).setSavingRunnable(ModConfig::saveConfig);
            ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"General"));
            ConfigCategory weather = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Weather"));
            ConfigCategory particles = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Particles"));
            ConfigCategory advanced = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Advanced"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            this.buildGeneralCategory(general, entryBuilder);
            this.buildWeatherCategory(weather, entryBuilder);
            this.buildParticlesCategory(particles, entryBuilder);
            this.buildAdvancedCategory(advanced, entryBuilder);
            return builder.build();
        };
    }

    private void buildGeneralCategory(ConfigCategory general, ConfigEntryBuilder entryBuilder) {
        general.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Wind Settings")).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Wind Sound"), ModConfig.getEnableWind()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enable wind sound")}).setSaveConsumer(newValue -> {
            ModConfig.setEnableWind(newValue);
            ModConfig.saveConfig();
            if (newValue.booleanValue()) {
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null) {
                    ModSounds.playWindSound((class_1657)client.field_1724);
                }
            } else {
                ModSounds.stopSoundsIfDisabled();
            }
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Wind Wisps"), ModConfig.getEnableWindWisps()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Enable wind wisp particles")}).setSaveConsumer(newValue -> {
            ModConfig.setEnableWindWisps(newValue);
            ModConfig.saveConfig();
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Lock Wind Direction"), ModConfig.getLockWindDirection()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Prevent wind direction from changing automatically\n\u2022 Enable this to manually set a fixed wind direction")}).setSaveConsumer(newValue -> {
            ModConfig.setLockWindDirection(newValue);
            ModConfig.saveConfig();
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Wind Direction"), ModConfig.getLockedWindDirection(), 0, 359).setDefaultValue(0).setTextGetter(value -> class_2561.method_43470((String)(value + "\u00b0 (" + this.getCardinalDirection((int)value) + ")"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Set the wind direction when locked\n\u2022 0\u00b0 = East\n\u2022 90\u00b0 = South\n\u2022 180\u00b0 = West\n\u2022 270\u00b0 = North\n\n\u26a0 Only works when 'Lock Wind Direction' is enabled")}).setSaveConsumer(newValue -> {
            if (ModConfig.getLockWindDirection()) {
                ModConfig.setLockedWindDirection(newValue);
                ModConfig.saveConfig();
            }
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Lock Wind Strength"), ModConfig.getLockWindStrength()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Prevent wind strength from changing automatically\n\u2022 Enable this to manually set a fixed wind strength")}).setSaveConsumer(newValue -> {
            ModConfig.setLockWindStrength(newValue);
            ModConfig.saveConfig();
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Wind Strength"), ModConfig.getLockedWindStrength(), 1, 30).setDefaultValue(5).setTextGetter(value -> class_2561.method_43470((String)(value + " (" + this.getWindStrengthDescription((int)value) + ")"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Set the wind strength when locked\n\u2022 1 = No wind\n\u2022 1-10 = Mild wind\n\u2022 10-20 = Moderate wind\n\u2022 20-30 = Heavy wind\n\n\u26a0 Only works when 'Lock Wind Strength' is enabled")}).setSaveConsumer(newValue -> {
            if (ModConfig.getLockWindStrength()) {
                ModConfig.setLockedWindStrength(newValue);
                ModConfig.saveConfig();
            }
        }).build());
    }

    private void buildWeatherCategory(ConfigCategory weather, ConfigEntryBuilder entryBuilder) {
        this.buildRainSection(weather, entryBuilder);
        this.buildRainVisibilitySection(weather, entryBuilder);
        this.buildFogSection(weather, entryBuilder);
    }

    private void buildRainSection(ConfigCategory weather, ConfigEntryBuilder entryBuilder) {
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Weather Customization")).build());
        this.addSectionSeparator(weather, entryBuilder, "Rain Configuration");
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Rain Box Spawn Size"), (int)ModConfig.getRainBoxSize(), 1, 15).setDefaultValue(10).setTextGetter(value -> class_2561.method_43470((String)(value + " blocks"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Size of the rain simulation around the player")}).setSaveConsumer(newValue -> {
            ModConfig.setRainBoxSize(newValue);
            ModConfig.saveConfig();
        }).build());
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Rain Spawn Height"), (int)ModConfig.getRainBoxHeight(), 1, 15).setDefaultValue(15).setTextGetter(value -> class_2561.method_43470((String)(value + " blocks"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Height of the rain starting area\n\u2022 Higher values = Rain appears from higher up")}).setSaveConsumer(newValue -> {
            ModConfig.setRainBoxHeight(newValue);
            ModConfig.saveConfig();
        }).build());
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Rain Particle Amount"), (int)ModConfig.getRainParticleCount(), 5, 150).setDefaultValue(70).setTextGetter(value -> class_2561.method_43470((String)(value + " particles"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Number of particles to spawn\n\u2022 Particles are spread based on Rain Box size")}).setSaveConsumer(newValue -> {
            ModConfig.setRainParticleCount(newValue.intValue());
            ModConfig.saveConfig();
        }).build());
    }

    private void buildRainVisibilitySection(ConfigCategory weather, ConfigEntryBuilder entryBuilder) {
        this.addSectionSeparator(weather, entryBuilder, "Rain Visibility");
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Light-Based Opacity"), ModConfig.getEnableRainBasedAlphaLighting()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Make rain particles brighter near light\n\u2022 Enable for more realistic rain lighting effects")}).setSaveConsumer(newValue -> {
            ModConfig.setEnableRainBasedAlphaLighting(newValue);
            ModConfig.saveConfig();
        }).build());
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Rain Opacity"), (int)(ModConfig.getRainAlpha() * 100.0f), 0, 100).setDefaultValue(80).setTextGetter(value -> class_2561.method_43470((String)(value + "%"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Base opacity of rain particles\n\u2022 0% = Invisible\n\u2022 60% = Default\n\u2022 100% = Fully opaque\n\n\u26a0 Only applies when Light-Based Opacity is disabled")}).setSaveConsumer(newValue -> {
            float actualValue = (float)newValue.intValue() / 100.0f;
            ModConfig.setRainAlpha(actualValue);
            ModConfig.saveConfig();
        }).build());
    }

    private void buildFogSection(ConfigCategory weather, ConfigEntryBuilder entryBuilder) {
        this.addSectionSeparator(weather, entryBuilder, "Fog Configuration");
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Fog Intensity"), (int)(ModConfig.getFogRainMultiplier() * 10.0f), 0, 50).setDefaultValue(2).setTextGetter(value -> class_2561.method_43470((String)String.format("%.1fx", Float.valueOf((float)value.intValue() / 10.0f)))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Fog intensity during rain")}).setSaveConsumer(newValue -> {
            float actualValue = (float)newValue.intValue() / 10.0f;
            ModConfig.setFogRainMultiplier(actualValue);
            ModConfig.saveConfig();
        }).build());
        weather.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Fog Thunder Intensity"), (int)(ModConfig.getFogThunderMultiplier() * 10.0f), 0, 50).setDefaultValue(5).setTextGetter(value -> class_2561.method_43470((String)String.format("%.1fx", Float.valueOf((float)value.intValue() / 10.0f)))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Fog intensity during thunder")}).setSaveConsumer(newValue -> {
            float actualValue = (float)newValue.intValue() / 10.0f;
            ModConfig.setFogThunderMultiplier(actualValue);
            ModConfig.saveConfig();
        }).build());
    }

    private void buildParticlesCategory(ConfigCategory particles, ConfigEntryBuilder entryBuilder) {
        particles.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Particle System Configuration")).build());
        particles.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Rain Hit Particles"), ModConfig.getEnableRainHitParticles()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show splash particles when rain hits surfaces")}).setSaveConsumer(newValue -> {
            ModConfig.setEnableRainHitParticles(newValue);
            ModConfig.saveConfig();
        }).build());
        particles.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Drip Splash Particles"), ModConfig.getEnableDripSplashParticles()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"Show splash particles from water drops from blocks")}).setSaveConsumer(newValue -> {
            ModConfig.setEnableDripSplashParticles(newValue);
            ModConfig.saveConfig();
        }).build());
        this.addSectionSeparator(particles, entryBuilder, "Particle Whitelist System");
        particles.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Control which particles are affected by wind")).build());
        Map<String, List<ParticleInfo>> particlesByNamespace = this.groupParticlesByNamespace();
        for (Map.Entry<String, List<ParticleInfo>> entry : particlesByNamespace.entrySet()) {
            String namespace = entry.getKey();
            List<ParticleInfo> namespaceParticles = entry.getValue();
            SubCategoryBuilder subCategoryBuilder = entryBuilder.startSubCategory((class_2561)class_2561.method_43470((String)(namespace.toUpperCase() + " Particles")));
            String namespaceDescription = this.getNamespaceDescription(namespace);
            if (!namespaceDescription.isEmpty()) {
                subCategoryBuilder.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)namespaceDescription)).build());
            }
            for (ParticleInfo particle : namespaceParticles) {
                boolean isWhitelisted = ParticleWhitelist.isWhitelisted(particle.registryId);
                BooleanListEntry toggleEntry = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)particle.displayName), isWhitelisted).setDefaultValue(ParticleWhitelist.getDefaultWhitelist().contains(particle.registryId)).setTooltip(new class_2561[]{class_2561.method_43470((String)("Particle ID: " + particle.registryId))}).setSaveConsumer(newValue -> {
                    if (newValue.booleanValue()) {
                        ParticleWhitelist.addWhitelist(particle.registryId);
                    } else {
                        ParticleWhitelist.removeWhitelist(particle.registryId);
                    }
                    ModConfig.saveConfig();
                }).build();
                subCategoryBuilder.add((AbstractConfigListEntry)toggleEntry);
            }
            particles.addEntry((AbstractConfigListEntry)subCategoryBuilder.build());
        }
    }

    private void buildAdvancedCategory(ConfigCategory advanced, ConfigEntryBuilder entryBuilder) {
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Debug and Technical Options")).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"WARNING: Debug modes can cause performance issues!")).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Debug Mode"), ModConfig.getDebugMode()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Use this for extra info in crash logs\n\u2022 Use for only debugging\n\u2022 Submit a GitHub Issue if needed")}).setSaveConsumer(newValue -> {
            ModConfig.setDebugMode(newValue);
            ModConfig.saveConfig();
        }).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Particle Debug"), ModConfig.getParticleDebugMode()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"DO NOT ENABLE FOR CRASH LOGS\nDO NOT SUBMIT LOGS WITH THIS\n\u2022 Shows detailed particle information\n\u2022 Used for testing whitelist settings")}).setSaveConsumer(newValue -> {
            ModConfig.setParticleDebugMode(newValue);
            ModConfig.saveConfig();
        }).build());
        this.addSectionSeparator(advanced, entryBuilder, "Raycast Debug Visualization");
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Visualize wind detection raycasts in-game (F8 toggles off/on)")).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Show Sound Occlusion Raycasts"), WindRaycastDebugRenderer.isSoundRaycastsEnabled()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Visualize the spherical raycasts around the player\n\u2022 Used for wind sound occlusion detection\n\u2022 Green = Clear path\n\u2022 Red/Yellow = Blocked path\n\n\u26a0 May impact performance")}).setSaveConsumer(WindRaycastDebugRenderer::setSoundRaycastsEnabled).build());
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Show Particle Wind Raycasts"), WindRaycastDebugRenderer.isParticleRaycastsEnabled()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Visualize particle wind deflection raycasts\n\u2022 Shows how particles detect obstacles\n\u2022 Cyan = Clear path\n\u2022 Red/Magenta = Blocked path\n\n\u26a0 May impact performance significantly")}).setSaveConsumer(WindRaycastDebugRenderer::setParticleRaycastsEnabled).build());
        this.addSectionSeparator(advanced, entryBuilder, "Support Information");
        advanced.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"Having issues? \nReport issues at: github.com/wVibzz/ImmersiveWinds/issues")).build());
    }

    private void addSectionSeparator(ConfigCategory category, ConfigEntryBuilder entryBuilder, String sectionName) {
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)"")).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43470((String)("\u2501\u2501\u2501 " + sectionName + " \u2501\u2501\u2501"))).build());
    }

    private String getNamespaceDescription(String namespace) {
        return switch (namespace.toLowerCase()) {
            case "minecraft" -> "Core Minecraft particles";
            case "immersivewind" -> "Particles added by this mod (can ignore)";
            default -> "Particles from " + namespace + " mod";
        };
    }

    private Map<String, List<ParticleInfo>> groupParticlesByNamespace() {
        HashMap particlesByNamespace = new HashMap();
        class_7923.field_41180.forEach(particleType -> {
            class_2960 id = class_7923.field_41180.method_10221(particleType);
            if (id != null) {
                String namespace = id.method_12836();
                String registryId = id.toString();
                String displayName = this.formatDisplayName(id.method_12832());
                particlesByNamespace.computeIfAbsent(namespace, k -> new ArrayList()).add(new ParticleInfo(registryId, displayName));
            }
        });
        for (List particles : particlesByNamespace.values()) {
            particles.sort((a, b) -> a.displayName.compareToIgnoreCase(b.displayName));
        }
        return new TreeMap<String, List<ParticleInfo>>(particlesByNamespace);
    }

    private String formatDisplayName(String path) {
        return Arrays.stream(path.split("_")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase()).reduce((a, b) -> a + " " + b).orElse(path);
    }

    private String getCardinalDirection(int angle) {
        if ((double)angle >= 337.5 || (double)angle < 22.5) {
            return "E";
        }
        if ((double)angle >= 22.5 && (double)angle < 67.5) {
            return "SE";
        }
        if ((double)angle >= 67.5 && (double)angle < 112.5) {
            return "S";
        }
        if ((double)angle >= 112.5 && (double)angle < 157.5) {
            return "SW";
        }
        if ((double)angle >= 157.5 && (double)angle < 202.5) {
            return "W";
        }
        if ((double)angle >= 202.5 && (double)angle < 247.5) {
            return "NW";
        }
        if ((double)angle >= 247.5 && (double)angle < 292.5) {
            return "N";
        }
        if ((double)angle >= 292.5 && (double)angle < 337.5) {
            return "NE";
        }
        return "";
    }

    private String getWindStrengthDescription(int strength) {
        if (strength == 1) {
            return "None";
        }
        if (strength <= 10) {
            return "Light";
        }
        if (strength <= 20) {
            return "Moderate";
        }
        return "Strong";
    }

    private static class ParticleInfo {
        final String registryId;
        final String displayName;

        ParticleInfo(String registryId, String displayName) {
            this.registryId = registryId;
            this.displayName = displayName;
        }
    }
}

