/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.particle.spawners;

import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.vibzz.immersivewind.config.ModConfig;
import net.vibzz.immersivewind.particle.ParticleRegistry;
import net.vibzz.immersivewind.particle.custom.FogParticle;
import net.vibzz.immersivewind.particle.custom.SnowFlakeParticle;
import net.vibzz.immersivewind.wind.WindManager;

public class WeatherParticleSpawner {
    private static final class_2338.class_2339 MUTABLE_POS = new class_2338.class_2339();
    private static final double SPAWN_RADIUS = ModConfig.getRainBoxSize() + 2.0f;
    private static final double SPAWN_HEIGHT_ABOVE = ModConfig.getRainBoxHeight();
    private static final double SPAWN_HEIGHT_BELOW = 5.0;
    private static final float RAIN_FOG_SPAWN_CHANCE = 0.05f * ModConfig.getFogRainMultiplier();
    private static long lastSpawnTime = 0L;
    private static final long SPAWN_INTERVAL = 5L;

    public static void spawnAtmosphericWeather(class_638 world, float rainGradient) {
        class_310 client = class_310.method_1551();
        if (client.method_1493()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastSpawnTime < 5L) {
            return;
        }
        lastSpawnTime = currentTime;
        class_746 player = client.field_1724;
        if (player == null || rainGradient <= 0.01f) {
            return;
        }
        float windDirection = WindManager.getWindDirection();
        float windStrength = WindManager.getWindStrength();
        float windAngleRadX = (float)Math.toRadians(windDirection);
        float windAngleRadZ = (float)Math.toRadians(windDirection - 90.0f);
        float windInfluenceX = class_3532.method_15362((float)windAngleRadX) * (windStrength / 36.0f) * 0.4f;
        float windInfluenceZ = class_3532.method_15362((float)windAngleRadZ) * (windStrength / 36.0f) * 0.4f;
        double windVelX = class_3532.method_15362((float)((float)Math.toRadians(windDirection))) * 0.01f * windStrength;
        double windVelZ = class_3532.method_15374((float)((float)Math.toRadians(windDirection))) * 0.01f * windStrength;
        WeatherParticleSpawner.spawnRainParticles(world, (class_1657)player, rainGradient, windInfluenceX, windInfluenceZ);
        WeatherParticleSpawner.spawnSnowAndFog(world, (class_1657)player, rainGradient, windVelX, windVelZ);
    }

    private static void spawnRainParticles(class_638 world, class_1657 player, float rainGradient, float windInfluenceX, float windInfluenceZ) {
        float horizontalRadius = ModConfig.getRainBoxSize();
        float verticalRange = ModConfig.getRainBoxHeight();
        class_5819 random = class_5819.method_43047();
        float spawnVolume = (float)Math.PI * horizontalRadius * horizontalRadius * verticalRange;
        float volumeScale = spawnVolume / ((float)Math.PI * ModConfig.getRainBoxSize() * ModConfig.getRainBoxSize() * ModConfig.getRainBoxHeight());
        int spawnAttempts = (int)(ModConfig.getRainParticleCount() * (double)volumeScale * (double)rainGradient * (double)rainGradient);
        spawnAttempts = class_3532.method_15340((int)spawnAttempts, (int)5, (int)150);
        for (int i = 0; i < spawnAttempts; ++i) {
            double fallVelocity;
            float theta = random.method_43057() * ((float)Math.PI * 2);
            float phi = (float)Math.acos(2.0f * random.method_43057() - 1.0f);
            float distance = (float)Math.pow(random.method_43057(), 0.3333333333333333) * horizontalRadius;
            float offsetX = distance * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
            float offsetZ = distance * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
            float offsetY = random.method_43057() * verticalRange;
            double spawnX = player.method_23317() + (double)offsetX;
            double spawnY = player.method_23320() + (double)offsetY;
            double spawnZ = player.method_23321() + (double)offsetZ;
            double fallDistance = spawnY - player.method_23320();
            double fallTime = fallDistance / Math.abs(fallVelocity = -0.5);
            class_2338 spawnPos = class_2338.method_49637((double)(spawnX -= (double)windInfluenceX * fallTime), (double)spawnY, (double)(spawnZ -= (double)windInfluenceZ * fallTime));
            class_1959 biome = (class_1959)world.method_23753(spawnPos).comp_349();
            if (biome.method_48162(spawnPos) != class_1959.class_1963.field_9382) continue;
            world.method_8406((class_2394)ParticleRegistry.RAIN_PARTICLE, spawnX += (random.method_43058() - 0.5) * 0.3, spawnY, spawnZ += (random.method_43058() - 0.5) * 0.3, (random.method_43058() - 0.5) * 0.02, fallVelocity, (random.method_43058() - 0.5) * 0.02);
        }
    }

    private static void spawnSnowAndFog(class_638 world, class_1657 player, float rainGradient, double windVelX, double windVelZ) {
        int snowParticlesToSpawn = (int)(15.0f * rainGradient);
        int fogParticlesToSpawn = (int)(15.0f * rainGradient);
        if (world.method_8546()) {
            snowParticlesToSpawn *= 60;
            fogParticlesToSpawn = (int)((float)fogParticlesToSpawn * ModConfig.getFogThunderMultiplier());
        } else if (world.method_8419()) {
            snowParticlesToSpawn *= 30;
            fogParticlesToSpawn = (int)((float)fogParticlesToSpawn * ModConfig.getFogRainMultiplier());
        }
        boolean canSpawnSnow = SnowFlakeParticle.canSpawnMoreParticles();
        boolean canSpawnFog = FogParticle.canSpawnMoreParticles();
        double rainFogVelY = -0.45;
        double snowFogVelY = 0.0;
        if (canSpawnSnow) {
            WeatherParticleSpawner.spawnSnowInSphere(world, player, snowParticlesToSpawn, windVelX, windVelZ);
        }
        if (canSpawnFog) {
            WeatherParticleSpawner.spawnFogInSphere(world, player, fogParticlesToSpawn, windVelX, windVelZ, rainFogVelY, snowFogVelY);
        }
        if (canSpawnSnow) {
            WeatherParticleSpawner.spawnSnowWindDirectional(world, player, (int)((double)snowParticlesToSpawn * 1.5), windVelX, windVelZ);
        }
        if (canSpawnFog) {
            WeatherParticleSpawner.spawnFogWindDirectional(world, player, (int)((double)fogParticlesToSpawn * 1.5), windVelX, windVelZ, rainFogVelY, snowFogVelY);
        }
    }

    private static void spawnSnowInSphere(class_638 world, class_1657 player, int count, double windVelX, double windVelZ) {
        for (int i = 0; i < count; ++i) {
            class_1959 biome;
            double spawnAngle = (double)world.field_9229.method_43057() * Math.PI * 2.0;
            double spawnDist = Math.sqrt(world.field_9229.method_43058()) * SPAWN_RADIUS;
            double spawnX = player.method_23317() + Math.cos(spawnAngle) * spawnDist;
            double spawnZ = player.method_23321() + Math.sin(spawnAngle) * spawnDist;
            double spawnY = player.method_23318() + world.field_9229.method_43058() * (SPAWN_HEIGHT_ABOVE + 5.0) - 5.0;
            MUTABLE_POS.method_10103((int)spawnX, (int)spawnY, (int)spawnZ);
            int groundY = world.method_8624(class_2902.class_2903.field_13197, MUTABLE_POS.method_10263(), MUTABLE_POS.method_10260());
            if (spawnY < (double)groundY || (biome = (class_1959)world.method_23753((class_2338)MUTABLE_POS).comp_349()).method_48162((class_2338)MUTABLE_POS) != class_1959.class_1963.field_9383) continue;
            class_310.method_1551().field_1713.method_3056((class_2394)ParticleRegistry.SNOW_FLAKE, spawnX, spawnY, spawnZ, windVelX, 0.0, windVelZ);
        }
    }

    private static void spawnFogInSphere(class_638 world, class_1657 player, int count, double windVelX, double windVelZ, double rainFogVelY, double snowFogVelY) {
        for (int i = 0; i < count; ++i) {
            double spawnAngle = (double)world.field_9229.method_43057() * Math.PI * 2.0;
            double spawnDist = Math.sqrt(world.field_9229.method_43058()) * SPAWN_RADIUS;
            double spawnX = player.method_23317() + Math.cos(spawnAngle) * spawnDist;
            double spawnZ = player.method_23321() + Math.sin(spawnAngle) * spawnDist;
            double spawnY = player.method_23318() + world.field_9229.method_43058() * (SPAWN_HEIGHT_ABOVE + 5.0) - 5.0;
            MUTABLE_POS.method_10103((int)spawnX, (int)spawnY, (int)spawnZ);
            int groundY = world.method_8624(class_2902.class_2903.field_13197, MUTABLE_POS.method_10263(), MUTABLE_POS.method_10260());
            if (spawnY < (double)groundY) continue;
            class_1959 biome = (class_1959)world.method_23753((class_2338)MUTABLE_POS).comp_349();
            class_1959.class_1963 precipitation = biome.method_48162((class_2338)MUTABLE_POS);
            if (precipitation == class_1959.class_1963.field_9382) {
                if (world.field_9229.method_43057() > RAIN_FOG_SPAWN_CHANCE) continue;
                class_310.method_1551().field_1713.method_3056((class_2394)ParticleRegistry.IW_FOG, spawnX, spawnY, spawnZ, windVelX, rainFogVelY, windVelZ);
                continue;
            }
            if (precipitation != class_1959.class_1963.field_9383) continue;
            class_310.method_1551().field_1713.method_3056((class_2394)ParticleRegistry.IW_FOG, spawnX, spawnY, spawnZ, windVelX, snowFogVelY, windVelZ);
        }
    }

    private static void spawnSnowWindDirectional(class_638 world, class_1657 player, int count, double windVelX, double windVelZ) {
        for (int i = 0; i < count; ++i) {
            class_1959 biome;
            class_2680 blockState;
            double sectorAngle = (double)world.field_9229.method_43057() * Math.PI * 2.0;
            double spawnDist = (0.3 + 0.7 * world.field_9229.method_43058()) * SPAWN_RADIUS;
            double spawnX = player.method_23317() + Math.cos(sectorAngle) * spawnDist;
            double spawnZ = player.method_23321() + Math.sin(sectorAngle) * spawnDist;
            double spawnY = player.method_23318() + world.field_9229.method_43058() * (SPAWN_HEIGHT_ABOVE + 5.0) - 5.0;
            MUTABLE_POS.method_10103((int)spawnX, (int)spawnY, (int)spawnZ);
            int groundY = world.method_8624(class_2902.class_2903.field_13197, MUTABLE_POS.method_10263(), MUTABLE_POS.method_10260());
            if (spawnY < (double)groundY || (blockState = world.method_8320((class_2338)MUTABLE_POS)).method_26212((class_1922)world, (class_2338)MUTABLE_POS) || !blockState.method_26227().method_15769() || (biome = (class_1959)world.method_23753((class_2338)MUTABLE_POS).comp_349()).method_48162((class_2338)MUTABLE_POS) != class_1959.class_1963.field_9383) continue;
            class_310.method_1551().field_1713.method_3056((class_2394)ParticleRegistry.SNOW_FLAKE, spawnX, spawnY, spawnZ, windVelX, 0.0, windVelZ);
        }
    }

    private static void spawnFogWindDirectional(class_638 world, class_1657 player, int count, double windVelX, double windVelZ, double rainFogVelY, double snowFogVelY) {
        for (int i = 0; i < count; ++i) {
            class_2680 blockState;
            double sectorAngle = (double)world.field_9229.method_43057() * Math.PI * 2.0;
            double spawnDist = (0.3 + 0.7 * world.field_9229.method_43058()) * SPAWN_RADIUS;
            double spawnX = player.method_23317() + Math.cos(sectorAngle) * spawnDist;
            double spawnZ = player.method_23321() + Math.sin(sectorAngle) * spawnDist;
            double spawnY = player.method_23318() + world.field_9229.method_43058() * (SPAWN_HEIGHT_ABOVE + 5.0) - 5.0;
            MUTABLE_POS.method_10103((int)spawnX, (int)spawnY, (int)spawnZ);
            int groundY = world.method_8624(class_2902.class_2903.field_13197, MUTABLE_POS.method_10263(), MUTABLE_POS.method_10260());
            if (spawnY < (double)groundY || (blockState = world.method_8320((class_2338)MUTABLE_POS)).method_26212((class_1922)world, (class_2338)MUTABLE_POS) || !blockState.method_26227().method_15769()) continue;
            class_1959 biome = (class_1959)world.method_23753((class_2338)MUTABLE_POS).comp_349();
            class_1959.class_1963 precipitation = biome.method_48162((class_2338)MUTABLE_POS);
            if (precipitation == class_1959.class_1963.field_9382) {
                if (world.field_9229.method_43057() > RAIN_FOG_SPAWN_CHANCE) continue;
                class_310.method_1551().field_1713.method_3056((class_2394)ParticleRegistry.IW_FOG, spawnX, spawnY, spawnZ, windVelX, rainFogVelY, windVelZ);
                continue;
            }
            if (precipitation != class_1959.class_1963.field_9383) continue;
            class_310.method_1551().field_1713.method_3056((class_2394)ParticleRegistry.IW_FOG, spawnX, spawnY, spawnZ, windVelX, snowFogVelY, windVelZ);
        }
    }
}

