/*
 * Decompiled with CFR 0.152.
 */
package net.vibzz.immersivewind.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_863;

public class WindRaycastDebugRenderer {
    private static final List<RayData> soundRays = new ArrayList<RayData>();
    private static final List<RayData> particleRays = new ArrayList<RayData>();
    private static boolean soundRaycastsEnabled = false;
    private static boolean particleRaycastsEnabled = false;

    public static void setSoundRaycastsEnabled(boolean enabled) {
        soundRaycastsEnabled = enabled;
        if (!enabled) {
            soundRays.clear();
        }
    }

    public static boolean isSoundRaycastsEnabled() {
        return soundRaycastsEnabled;
    }

    public static void setParticleRaycastsEnabled(boolean enabled) {
        particleRaycastsEnabled = enabled;
        if (!enabled) {
            particleRays.clear();
        }
    }

    public static boolean isParticleRaycastsEnabled() {
        return particleRaycastsEnabled;
    }

    public static void toggle() {
        boolean newState = !soundRaycastsEnabled && !particleRaycastsEnabled;
        WindRaycastDebugRenderer.setSoundRaycastsEnabled(newState);
        WindRaycastDebugRenderer.setParticleRaycastsEnabled(newState);
    }

    public static boolean isEnabled() {
        return soundRaycastsEnabled || particleRaycastsEnabled;
    }

    public static void add(class_243 start, class_243 end, boolean hit, double distance) {
        if (soundRaycastsEnabled) {
            soundRays.add(new RayData(start, end, hit, distance));
        }
    }

    public static void add(class_243 start, class_243 end, boolean hit, double distance, double maxDistance) {
        if (particleRaycastsEnabled) {
            particleRays.add(new RayData(start, end, hit, distance, maxDistance));
        }
    }

    public static void clear() {
        soundRays.clear();
        particleRays.clear();
    }

    public static void clearSoundRays() {
        soundRays.clear();
    }

    public static void clearParticleRays() {
        particleRays.clear();
    }

    public static void render(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        class_2338 endPos;
        float b;
        float g;
        float r;
        if (soundRaycastsEnabled && !soundRays.isEmpty()) {
            for (RayData ray : soundRays) {
                if (ray.hit) {
                    float t = (float)(ray.distance / ray.maxDistance);
                    r = 1.0f;
                    g = t;
                    b = 0.0f;
                } else {
                    r = 0.0f;
                    g = 1.0f;
                    b = 0.0f;
                }
                endPos = class_2338.method_49638((class_2374)ray.end);
                class_863.method_23103((class_4587)matrices, (class_4597)vertexConsumers, (class_2338)endPos, (float)0.1f, (float)r, (float)g, (float)b, (float)0.8f);
            }
        }
        if (particleRaycastsEnabled && !particleRays.isEmpty()) {
            for (RayData ray : particleRays) {
                if (ray.hit) {
                    float t = (float)(ray.distance / ray.maxDistance);
                    r = 1.0f;
                    g = 0.0f;
                    b = t;
                } else {
                    r = 0.0f;
                    g = 0.5f;
                    b = 1.0f;
                }
                endPos = class_2338.method_49638((class_2374)ray.end);
                class_863.method_23103((class_4587)matrices, (class_4597)vertexConsumers, (class_2338)endPos, (float)0.08f, (float)r, (float)g, (float)b, (float)0.8f);
            }
        }
    }

    public static class RayData {
        public final class_243 start;
        public final class_243 end;
        public final boolean hit;
        public final double distance;
        public final double maxDistance;

        public RayData(class_243 start, class_243 end, boolean hit, double distance) {
            this(start, end, hit, distance, 20.0);
        }

        public RayData(class_243 start, class_243 end, boolean hit, double distance, double maxDistance) {
            this.start = start;
            this.end = end;
            this.hit = hit;
            this.distance = distance;
            this.maxDistance = maxDistance;
        }
    }
}

