/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.config;

import com.moandjiezana.toml.Toml;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import me.drex.antixray.common.AntiXray;
import me.drex.antixray.common.config.Config;
import me.drex.antixray.common.util.EngineMode;
import me.drex.antixray.common.util.controller.ChunkPacketBlockController;
import me.drex.antixray.common.util.controller.DisabledChunkPacketBlockController;
import me.drex.antixray.common.util.controller.HideChunkPacketBlockController;
import me.drex.antixray.common.util.controller.ObfuscateChunkPacketBlockController;
import me.drex.antixray.common.util.controller.ObfuscateLayerChunkPacketBlockController;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class WorldConfig {
    public boolean enabled = false;
    public boolean usePermission = false;
    public EngineMode engineMode = EngineMode.HIDE;
    public int maxBlockHeight = 64;
    public int updateRadius = 2;
    public boolean lavaObscures = false;
    public Set<class_2248> hiddenBlocks = new HashSet<class_2248>();
    public Set<class_2248> replacementBlocks = new HashSet<class_2248>();

    public WorldConfig(class_2960 location) {
        Toml defaultToml = Config.toml;
        this.loadValues(defaultToml);
        Toml worldToml = defaultToml.getTable(location.method_12832());
        if (worldToml != null) {
            this.loadValues(worldToml);
        } else {
            this.loadValues(defaultToml.getTable("'" + String.valueOf(location) + "'"));
            this.loadValues(defaultToml.getTable("\"" + String.valueOf(location) + "\""));
        }
    }

    private void loadValues(Toml toml) {
        EngineMode mode;
        if (toml == null) {
            return;
        }
        if (toml.contains("enabled")) {
            this.enabled = toml.getBoolean("enabled");
        }
        if (toml.contains("usePermission")) {
            this.usePermission = toml.getBoolean("usePermission");
        }
        if (toml.contains("engineMode") && (mode = EngineMode.getById(Math.toIntExact(toml.getLong("engineMode")))) != null) {
            this.engineMode = mode;
        }
        if (toml.contains("maxBlockHeight")) {
            this.maxBlockHeight = Math.toIntExact(toml.getLong("maxBlockHeight")) >> 4 << 4;
        }
        if (toml.contains("updateRadius")) {
            this.updateRadius = Math.toIntExact(toml.getLong("updateRadius"));
        }
        if (toml.contains("lavaObscures")) {
            this.lavaObscures = toml.getBoolean("lavaObscures");
        }
        if (toml.contains("hiddenBlocks")) {
            this.hiddenBlocks = this.parseBlocks(toml.getList("hiddenBlocks"));
        }
        if (toml.contains("replacementBlocks")) {
            this.replacementBlocks = this.parseBlocks(toml.getList("replacementBlocks"));
        }
    }

    private Set<class_2248> parseBlocks(List<String> blocks) {
        HashSet<class_2248> result = new HashSet<class_2248>();
        for (String blockId : blocks) {
            try {
                StringReader stringReader = new StringReader(blockId);
                boolean isTag = false;
                Consumer<class_2248> blockConsumer = result::add;
                if (stringReader.canRead() && stringReader.peek() == '!') {
                    blockConsumer = result::remove;
                    stringReader.skip();
                }
                if (stringReader.canRead() && stringReader.peek() == '#') {
                    isTag = true;
                    stringReader.skip();
                }
                class_2960 location = class_2960.method_12835((StringReader)stringReader);
                if (isTag) {
                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)location);
                    Optional optional = class_7923.field_41175.method_46733(tagKey);
                    if (optional.isPresent()) {
                        for (class_6880 holder : (class_6885.class_6888)optional.get()) {
                            blockConsumer.accept((class_2248)holder.comp_349());
                        }
                        continue;
                    }
                    AntiXray.LOGGER.warn("Unknown block tag id: \"{}\"", (Object)blockId);
                    continue;
                }
                Optional optional = class_7923.field_41175.method_17966(location);
                optional.ifPresentOrElse(blockConsumer, () -> AntiXray.LOGGER.warn("Unknown block id: \"{}\"", (Object)blockId));
            }
            catch (CommandSyntaxException exception) {
                AntiXray.LOGGER.warn("Failed to parse block: \"{}\"", (Object)blockId, (Object)exception);
            }
        }
        return result;
    }

    public ChunkPacketBlockController createChunkPacketBlockController(class_1937 level) {
        if (!this.enabled) {
            return DisabledChunkPacketBlockController.NO_OPERATION_INSTANCE;
        }
        return switch (this.engineMode) {
            default -> throw new MatchException(null, null);
            case EngineMode.HIDE -> new HideChunkPacketBlockController(level, this.hiddenBlocks, this.maxBlockHeight, this.updateRadius, this.lavaObscures, this.usePermission);
            case EngineMode.OBFUSCATE -> new ObfuscateChunkPacketBlockController(level, this.replacementBlocks, this.hiddenBlocks, this.maxBlockHeight, this.updateRadius, this.lavaObscures, this.usePermission);
            case EngineMode.OBFUSCATE_LAYER -> new ObfuscateLayerChunkPacketBlockController(level, this.replacementBlocks, this.hiddenBlocks, this.maxBlockHeight, this.updateRadius, this.lavaObscures, this.usePermission);
        };
    }
}

