/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.util.controller;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import me.drex.antixray.common.AntiXray;
import me.drex.antixray.common.util.BitStorageReader;
import me.drex.antixray.common.util.BitStorageWriter;
import me.drex.antixray.common.util.ChunkPacketInfo;
import me.drex.antixray.common.util.ChunkPacketInfoAntiXray;
import me.drex.antixray.common.util.controller.ChunkPacketBlockController;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2812;
import net.minecraft.class_2816;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2835;
import net.minecraft.class_2837;
import net.minecraft.class_2846;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_6558;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public abstract class ChunkPacketBlockControllerAntiXray
implements ChunkPacketBlockController {
    protected static final class_2837<class_2680> GLOBAL_BLOCKSTATE_PALETTE = new class_2816((class_2359)class_2248.field_10651);
    private static final class_2826 EMPTY_SECTION = null;
    private static final ThreadLocal<boolean[]> SOLID = ThreadLocal.withInitial(() -> new boolean[class_2248.field_10651.method_10204()]);
    private static final ThreadLocal<boolean[]> OBFUSCATE = ThreadLocal.withInitial(() -> new boolean[class_2248.field_10651.method_10204()]);
    private static final ThreadLocal<boolean[][]> CURRENT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT_NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    protected final int maxBlockHeight;
    private final int maxBlockHeightUpdatePosition;
    private final int updateRadius;
    private final boolean usePermission;
    private final Object2BooleanOpenHashMap<class_2680> solidGlobal = new Object2BooleanOpenHashMap(class_2248.field_10651.method_10204());
    private final Object2BooleanOpenHashMap<class_2680> obfuscateGlobal = new Object2BooleanOpenHashMap(class_2248.field_10651.method_10204());
    private final class_2826[] emptyNearbyChunkSections = new class_2826[]{EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION};
    private final ThreadLocal<int[]> presetBlockStateBits = ThreadLocal.withInitial(() -> new int[this.getPresetBlockStatesLength()]);

    protected ChunkPacketBlockControllerAntiXray(class_1937 level, Set<class_2248> toObfuscate, int maxBlockHeight, int updateRadius, boolean lavaObscures, boolean usePermission) {
        this.maxBlockHeight = maxBlockHeight;
        this.updateRadius = updateRadius;
        this.usePermission = usePermission;
        for (class_2248 block : toObfuscate) {
            if (block.method_9564().method_26215()) continue;
            for (class_2680 blockState2 : block.method_9595().method_11662()) {
                this.obfuscateGlobal.put((Object)blockState2, true);
            }
        }
        class_2812 emptyChunk = new class_2812(level, new class_1923(0, 0), (class_6880)level.method_30349().method_30530(class_7924.field_41236).method_46747(class_1972.field_9451));
        class_2248.field_10651.iterator().forEachRemaining(blockState -> this.solidGlobal.put(blockState, ChunkPacketBlockControllerAntiXray.isSolid(emptyChunk, blockState, lavaObscures)));
        this.maxBlockHeightUpdatePosition = maxBlockHeight + updateRadius - 1;
    }

    @Override
    public boolean shouldModify(class_3222 player) {
        return !this.usePermission || !player.method_75004().hasPermission((class_12087)new class_12087.class_12089(class_12094.field_63198)) && !AntiXray.INSTANCE.hasBypassPermission(player);
    }

    public ChunkPacketInfoAntiXray getChunkPacketInfo(class_2672 chunkPacket, class_2818 chunk) {
        return new ChunkPacketInfoAntiXray(chunkPacket, chunk, this);
    }

    @Override
    public void onBlockChange(class_3218 level, class_2338 blockPos, class_2680 newBlockState, class_2680 oldBlockState, int flags, int maxUpdateDepth) {
        if (oldBlockState != null && this.solidGlobal.getOrDefault((Object)oldBlockState, false) && !this.solidGlobal.getOrDefault((Object)newBlockState, false) && blockPos.method_10264() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(level, blockPos);
        }
    }

    @Override
    public void modifyBlocks(class_2672 chunkPacket, ChunkPacketInfo<class_2680> chunkPacketInfo) {
        class_3218 serverLevel;
        if (!(chunkPacketInfo instanceof ChunkPacketInfoAntiXray)) {
            chunkPacket.antixray$setReady(true);
            return;
        }
        ChunkPacketInfoAntiXray antiXrayInfo = (ChunkPacketInfoAntiXray)chunkPacketInfo;
        class_1937 class_19372 = chunkPacketInfo.getChunk().method_12200();
        if (class_19372 instanceof class_3218 && !(serverLevel = (class_3218)class_19372).method_8503().method_18854()) {
            serverLevel.method_8503().execute(() -> this.modifyBlocks(chunkPacket, chunkPacketInfo));
            return;
        }
        class_2818 chunk = chunkPacketInfo.getChunk();
        int x = chunk.method_12004().field_9181;
        int z = chunk.method_12004().field_9180;
        class_3215 chunkCache = ((class_3218)chunk.method_12200()).method_14178();
        antiXrayInfo.setNearbyChunks(this.getChunkAccess(chunkCache, x - 1, z), this.getChunkAccess(chunkCache, x + 1, z), this.getChunkAccess(chunkCache, x, z - 1), this.getChunkAccess(chunkCache, x, z + 1));
        class_156.method_18349().execute((Runnable)((Object)chunkPacketInfo));
    }

    private class_2791 getChunkAccess(class_3215 chunkCache, int chunkX, int chunkZ) {
        class_3193 chunkHolder = chunkCache.method_14131(class_1923.method_8331((int)chunkX, (int)chunkZ));
        if (chunkHolder != null) {
            class_2791 chunkAccess = chunkHolder.method_60471();
            if (chunkAccess != null) {
                return chunkAccess;
            }
            AntiXray.LOGGER.warn("Chunk at [{}, {}] not available, falling back to getChunk", (Object)chunkX, (Object)chunkZ);
        } else {
            AntiXray.LOGGER.warn("Chunk at [{}, {}] not visible, falling back to getChunk", (Object)chunkX, (Object)chunkZ);
        }
        return chunkCache.method_12121(chunkX, chunkZ, class_2806.field_12805, true);
    }

    @Override
    public void onPlayerLeftClickBlock(class_3225 serverPlayerGameMode, class_2338 blockPos, class_2846.class_2847 action, class_2350 direction, int worldHeight) {
        if (blockPos.method_10264() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(serverPlayerGameMode.field_14007, blockPos);
        }
    }

    private void updateNearbyBlocks(class_3218 level, class_2338 blockPos) {
        int i;
        for (i = 0; i <= this.updateRadius; ++i) {
            this.updateNearbyBlocks2d(level, blockPos.method_10086(this.updateRadius - i), i);
        }
        for (i = 0; i < this.updateRadius; ++i) {
            this.updateNearbyBlocks2d(level, blockPos.method_10087(this.updateRadius - i), i);
        }
    }

    private void updateNearbyBlocks2d(class_3218 level, class_2338 blockPos, int diamondSize) {
        int j;
        int i;
        for (i = 0; i <= diamondSize; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                this.updateBlock(level, blockPos.method_10069(diamondSize - i, 0, j - i));
            }
        }
        for (i = 0; i < diamondSize; ++i) {
            for (j = 0; j < 2 * i + 1; ++j) {
                this.updateBlock(level, blockPos.method_10069(-diamondSize + i, 0, j - i));
            }
        }
    }

    protected abstract int getPresetBlockStatesLength();

    protected abstract int[] getPresetBlockStateBits(class_1937 var1, int var2);

    private void updateBlock(class_3218 level, class_2338 pos) {
        class_2818 chunk = level.method_14178().method_12126(pos.method_10263() >> 4, pos.method_10260() >> 4, false);
        if (chunk != null && this.obfuscateGlobal.getOrDefault((Object)chunk.method_8320(pos), false)) {
            level.method_14178().method_14128(pos);
        }
    }

    public void obfuscate(ChunkPacketInfoAntiXray chunkPacketInfoAntiXray) {
        int[] presetBlockStateBits = this.presetBlockStateBits.get();
        boolean[] solid = SOLID.get();
        boolean[] obfuscate = OBFUSCATE.get();
        boolean[][] current = CURRENT.get();
        boolean[][] next = NEXT.get();
        boolean[][] nextNext = NEXT_NEXT.get();
        BitStorageReader bitStorageReader = new BitStorageReader();
        BitStorageWriter bitStorageWriter = new BitStorageWriter();
        class_2826[] nearbyChunkSections = new class_2826[4];
        class_2818 chunk = chunkPacketInfoAntiXray.getChunk();
        class_1937 level = chunk.method_12200();
        int maxChunkSectionIndex = Math.min((this.maxBlockHeight >> 4) - chunk.method_32891(), chunk.method_32890() - 1);
        bitStorageReader.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        bitStorageWriter.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        int numberOfBlocks = presetBlockStateBits.length;
        for (int chunkSectionIndex = 0; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
            int x;
            int z;
            if (!chunkPacketInfoAntiXray.isWritten(chunkSectionIndex) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == null) continue;
            if (chunkPacketInfoAntiXray.getPalette(chunkSectionIndex) instanceof class_2816) {
                presetBlockStateBits = this.getPresetBlockStateBits(level, chunkSectionIndex + chunk.method_32891() << 4);
            } else {
                class_2680[] presetBlockStates = (class_2680[])chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex);
                for (int i = 0; i < presetBlockStateBits.length; ++i) {
                    presetBlockStateBits[i] = chunkPacketInfoAntiXray.getPalette(chunkSectionIndex).method_12291((Object)presetBlockStates[i], class_2835.method_74153());
                }
            }
            bitStorageWriter.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
            if (chunkSectionIndex == 0 || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex - 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex - 1) == null) {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), solid, this.solidGlobal);
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), obfuscate, this.obfuscateGlobal);
                class_2826 belowChunkSection = null;
                boolean skipFirstLayer = chunkSectionIndex == 0 || (belowChunkSection = chunk.method_12006()[chunkSectionIndex - 1]) == EMPTY_SECTION;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        current[z][x] = true;
                        next[z][x] = skipFirstLayer || this.isTransparent(belowChunkSection, x, 15, z);
                    }
                }
                bitStorageWriter.setBits(0);
                this.obfuscateLayer(-1, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, this.emptyNearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            bitStorageWriter.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
            nearbyChunkSections[0] = chunkPacketInfoAntiXray.getNearbyChunks()[0] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[0].method_12006()[chunkSectionIndex];
            nearbyChunkSections[1] = chunkPacketInfoAntiXray.getNearbyChunks()[1] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[1].method_12006()[chunkSectionIndex];
            nearbyChunkSections[2] = chunkPacketInfoAntiXray.getNearbyChunks()[2] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[2].method_12006()[chunkSectionIndex];
            nearbyChunkSections[3] = chunkPacketInfoAntiXray.getNearbyChunks()[3] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[3].method_12006()[chunkSectionIndex];
            for (int y = 0; y < 15; ++y) {
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                this.obfuscateLayer(y, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            if (chunkSectionIndex == maxChunkSectionIndex || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex + 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex + 1) == null) {
                class_2826 aboveChunkSection;
                if (chunkSectionIndex != chunk.method_32890() - 1 && (aboveChunkSection = chunk.method_12006()[chunkSectionIndex + 1]) != EMPTY_SECTION) {
                    boolean[][] temp = current;
                    current = next;
                    next = nextNext;
                    nextNext = temp;
                    for (z = 0; z < 16; ++z) {
                        for (x = 0; x < 16; ++x) {
                            if (!this.isTransparent(aboveChunkSection, x, 0, z)) continue;
                            current[z][x] = true;
                        }
                    }
                    bitStorageReader.setBits(0);
                    solid[0] = true;
                    this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
                }
            } else {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex + 1));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex + 1));
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), solid, this.solidGlobal);
                this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), obfuscate, this.obfuscateGlobal);
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscate, presetBlockStateBits, current, next, nextNext, nearbyChunkSections, this.layerIntSupplier(numberOfBlocks));
            }
            bitStorageWriter.flush();
        }
        chunkPacketInfoAntiXray.getChunkPacket().antixray$setReady(true);
    }

    private void obfuscateLayer(int y, BitStorageReader bitStorageReader, BitStorageWriter bitStorageWriter, boolean[] solid, boolean[] obfuscate, int[] presetBlockStateBits, boolean[][] current, boolean[][] next, boolean[][] nextNext, class_2826[] nearbyChunkSections, IntSupplier random) {
        for (int z = 0; z <= 15; ++z) {
            for (int x = 0; x <= 15; ++x) {
                int bits = bitStorageReader.read();
                nextNext[z][x] = !solid[bits];
                if (nextNext[z][x]) {
                    bitStorageWriter.skip();
                    if (x > 0) {
                        next[z][x - 1] = true;
                    }
                    if (x < 15) {
                        next[z][x + 1] = true;
                    }
                    if (z > 0) {
                        next[z - 1][x] = true;
                    }
                    if (z < 15) {
                        next[z + 1][x] = true;
                    }
                } else {
                    boolean posZ;
                    boolean negX = x == 0 && this.isTransparent(nearbyChunkSections[0], 15, y, z);
                    boolean posX = x == 15 && this.isTransparent(nearbyChunkSections[1], 0, y, z);
                    boolean negZ = z == 0 && this.isTransparent(nearbyChunkSections[2], x, y, 15);
                    boolean bl = posZ = z == 15 && this.isTransparent(nearbyChunkSections[3], x, y, 0);
                    if (current[z][x] || negX || posX || negZ || posZ) {
                        bitStorageWriter.skip();
                    } else {
                        bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    }
                }
                if (obfuscate[bits]) continue;
                next[z][x] = true;
            }
        }
    }

    private boolean isTransparent(class_2826 chunkSection, int x, int y, int z) {
        if (chunkSection == EMPTY_SECTION) {
            return true;
        }
        try {
            return !this.solidGlobal.getOrDefault((Object)chunkSection.method_12254(x, y, z), false);
        }
        catch (class_6558 e) {
            return true;
        }
    }

    private void readPalette(class_2837<class_2680> palette, boolean[] temp, Object2BooleanOpenHashMap<class_2680> global) {
        try {
            for (int i = 0; i < palette.method_12197(); ++i) {
                temp[i] = global.getOrDefault(palette.method_12288(i), false);
            }
        }
        catch (class_6558 class_65582) {
            // empty catch block
        }
    }

    public IntSupplier layerIntSupplier(final int numberOfBlocks) {
        return numberOfBlocks == 1 ? () -> 0 : new IntSupplier(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int getAsInt() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }
        };
    }

    private static boolean isSolid(class_2812 emptyChunk, class_2680 blockState, boolean lavaObscures) {
        return blockState.method_26234((class_1922)emptyChunk, class_2338.field_10980) && blockState.method_26225() || lavaObscures && blockState == class_2246.field_10164.method_9564();
    }
}

