/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.drex.antixray.common.util.Arguments;
import me.drex.antixray.common.util.ChunkPacketInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.Configuration;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.Strategy;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class PalettedContainerMixin<T> {
    @Unique
    private T[] antiXray$presetValues;
    @Shadow
    private volatile PalettedContainer.Data<T> data;
    @Shadow
    @Final
    private Strategy<T> strategy;

    @Shadow
    public abstract int onResize(int var1, T var2);

    @Shadow
    protected abstract PalettedContainer.Data<T> createOrReuseData(PalettedContainer.Data<T> var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"unpack(Lnet/minecraft/world/level/chunk/Strategy;Lnet/minecraft/world/level/chunk/PalettedContainerRO$PackedData;)Lcom/mojang/serialization/DataResult;"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/chunk/Strategy;Lnet/minecraft/world/level/chunk/Configuration;Lnet/minecraft/util/BitStorage;Lnet/minecraft/world/level/chunk/Palette;)Lnet/minecraft/world/level/chunk/PalettedContainer;")})
    private static <T> PalettedContainer<T> addPaletteEntryListArgument(Strategy<T> strategy, Configuration configuration, BitStorage bitStorage, Palette<T> palette, Operation<PalettedContainer<T>> original, @Local List<T> paletteEntries) {
        List<?> previous = Arguments.PALETTE_ENTRIES.get();
        try {
            Arguments.PALETTE_ENTRIES.set(paletteEntries);
            PalettedContainer palettedContainer = (PalettedContainer)original.call(new Object[]{strategy, configuration, bitStorage, palette});
            return palettedContainer;
        }
        finally {
            Arguments.PALETTE_ENTRIES.set(previous);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/Strategy;Lnet/minecraft/world/level/chunk/Configuration;Lnet/minecraft/util/BitStorage;Lnet/minecraft/world/level/chunk/Palette;)V"}, at={@At(value="TAIL")})
    private void addPresetValuesWithEntries(Strategy<T> strategy, Configuration configuration, BitStorage bitStorage, Palette<T> palette, CallbackInfo ci) {
        Configuration.Simple simpleFactory;
        this.antiXray$presetValues = Arguments.PRESET_VALUES.get();
        List<?> paletteEntries = Arguments.PALETTE_ENTRIES.get();
        if (this.antiXray$presetValues != null && paletteEntries != null && (configuration instanceof Configuration.Simple && (simpleFactory = (Configuration.Simple)configuration).factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY ? this.data.palette().valueFor(0) != Blocks.AIR.defaultBlockState() : !(configuration instanceof Configuration.Global))) {
            int maxSize = 1 << configuration.bitsInMemory();
            for (T presetValue : this.antiXray$presetValues) {
                if (this.data.palette().getSize() >= maxSize) {
                    HashSet allValues = new HashSet(paletteEntries);
                    allValues.addAll(Arrays.asList(this.antiXray$presetValues));
                    int newBits = Mth.ceillog2((int)allValues.size());
                    if (newBits <= configuration.bitsInMemory()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.data.palette().idFor(presetValue, (PaletteResize)((PalettedContainer)this));
            }
        }
    }

    @Inject(method={"<init>(Ljava/lang/Object;Lnet/minecraft/world/level/chunk/Strategy;)V"}, at={@At(value="TAIL")})
    public void addPresetValuesInit(Object object, Strategy<T> strategy, CallbackInfo ci) {
        this.antiXray$presetValues = Arguments.PRESET_VALUES.get();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/PalettedContainer;)V"}, at={@At(value="TAIL")})
    public void addPresetValuesInit(PalettedContainer<T> palettedContainer, CallbackInfo ci) {
        this.antiXray$presetValues = Arguments.PRESET_VALUES.get();
    }

    @Redirect(method={"onResize(ILjava/lang/Object;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer;createOrReuseData(Lnet/minecraft/world/level/chunk/PalettedContainer$Data;I)Lnet/minecraft/world/level/chunk/PalettedContainer$Data;"))
    private PalettedContainer.Data<T> addPresetValues(PalettedContainer<T> container, PalettedContainer.Data<T> data, int bits, int i, T objectAdded) {
        Configuration.Simple simpleFactory;
        Configuration configuration;
        if (this.antiXray$presetValues != null && objectAdded != null && (configuration = data.configuration()) instanceof Configuration.Simple && (simpleFactory = (Configuration.Simple)configuration).factory() == Strategy.SINGLE_VALUE_PALETTE_FACTORY) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.antiXray$presetValues);
            duplicates += presetValues.contains(objectAdded) ? 1 : 0;
            int n = presetValues.contains(data.palette().valueFor(0)) ? 1 : 0;
            int size = 1 << this.strategy.getConfigurationForBitCount(bits).bitsInMemory();
            bits = Mth.ceillog2((int)(size + presetValues.size() - (duplicates += n)));
        }
        return this.createOrReuseData(data, bits);
    }

    @WrapOperation(method={"onResize(ILjava/lang/Object;)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/Palette;idFor(Ljava/lang/Object;Lnet/minecraft/world/level/chunk/PaletteResize;)I")})
    private int addPresetValues(Palette<T> palette, T object, PaletteResize<T> paletteResize, Operation<Integer> original) {
        this.antiXray$addPresetValues();
        return object == null ? -1 : (Integer)original.call(new Object[]{palette, object, paletteResize});
    }

    @Inject(method={"write(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/PalettedContainer$Data;write(Lnet/minecraft/network/FriendlyByteBuf;Lnet/minecraft/core/IdMap;)V", shift=At.Shift.AFTER)})
    public void setPresetValues(FriendlyByteBuf friendlyByteBuf, CallbackInfo ci) {
        ChunkPacketInfo<BlockState> chunkPacketInfo = Arguments.PACKET_INFO.get();
        Integer chunkSectionIndex = Arguments.CHUNK_SECTION_INDEX.get();
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setPresetValues(chunkSectionIndex, (BlockState[])((BlockState[])this.antiXray$presetValues));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"copy()Lnet/minecraft/world/level/chunk/PalettedContainer;"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/chunk/PalettedContainer;)Lnet/minecraft/world/level/chunk/PalettedContainer;")})
    private PalettedContainer<T> addPresetValuesCopy(PalettedContainer<T> palettedContainer, Operation<PalettedContainer<T>> original) {
        Object[] previous = Arguments.PRESET_VALUES.get();
        Arguments.PRESET_VALUES.set(this.antiXray$presetValues);
        try {
            PalettedContainer palettedContainer2 = (PalettedContainer)original.call(new Object[]{palettedContainer});
            return palettedContainer2;
        }
        finally {
            Arguments.PRESET_VALUES.set(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"recreate()Lnet/minecraft/world/level/chunk/PalettedContainer;"}, at={@At(value="NEW", target="(Ljava/lang/Object;Lnet/minecraft/world/level/chunk/Strategy;)Lnet/minecraft/world/level/chunk/PalettedContainer;")})
    private PalettedContainer<T> addPresetValuesRecreate(Object object, Strategy<T> strategy, Operation<PalettedContainer<T>> original) {
        Object[] previous = Arguments.PRESET_VALUES.get();
        Arguments.PRESET_VALUES.set(this.antiXray$presetValues);
        try {
            PalettedContainer palettedContainer = (PalettedContainer)original.call(new Object[]{object, strategy});
            return palettedContainer;
        }
        finally {
            Arguments.PRESET_VALUES.set(previous);
        }
    }

    @Unique
    private void antiXray$addPresetValues() {
        if (this.antiXray$presetValues != null && !(this.data.configuration() instanceof Configuration.Global)) {
            for (T presetValue : this.antiXray$presetValues) {
                this.data.palette().idFor(presetValue, (PaletteResize)((PalettedContainer)this));
            }
        }
    }
}

