/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.util.controller;

import java.util.Set;
import me.drex.antixray.common.util.controller.ChunkPacketBlockControllerAntiXray;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.PaletteResize;

public class HideChunkPacketBlockController
extends ChunkPacketBlockControllerAntiXray {
    private final BlockState[] presetBlockStatesStone = new BlockState[]{Blocks.STONE.defaultBlockState()};
    private final BlockState[] presetBlockStatesDeepslate = new BlockState[]{Blocks.DEEPSLATE.defaultBlockState()};
    private final BlockState[] presetBlockStatesNetherrack = new BlockState[]{Blocks.NETHERRACK.defaultBlockState()};
    private final BlockState[] presetBlockStatesEndStone = new BlockState[]{Blocks.END_STONE.defaultBlockState()};
    private final int[] presetBlockStateBitsStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor((Object)Blocks.STONE.defaultBlockState(), PaletteResize.noResizeExpected())};
    private final int[] presetBlockStateBitsDeepslateGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor((Object)Blocks.DEEPSLATE.defaultBlockState(), PaletteResize.noResizeExpected())};
    private final int[] presetBlockStateBitsNetherrackGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor((Object)Blocks.NETHERRACK.defaultBlockState(), PaletteResize.noResizeExpected())};
    private final int[] presetBlockStateBitsEndStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.idFor((Object)Blocks.END_STONE.defaultBlockState(), PaletteResize.noResizeExpected())};

    public HideChunkPacketBlockController(Level level, Set<Block> toObfuscate, int maxBlockHeight, int updateRadius, boolean lavaObscures, boolean usePermission) {
        super(level, toObfuscate, maxBlockHeight, updateRadius, lavaObscures, usePermission);
    }

    @Override
    protected int getPresetBlockStatesLength() {
        return 1;
    }

    @Override
    protected int[] getPresetBlockStateBits(Level level, int bottomBlockY) {
        if (level.dimension().equals(Level.NETHER)) {
            return this.presetBlockStateBitsNetherrackGlobal;
        }
        if (level.dimension().equals(Level.END)) {
            return this.presetBlockStateBitsEndStoneGlobal;
        }
        return bottomBlockY >= 0 ? this.presetBlockStateBitsStoneGlobal : this.presetBlockStateBitsDeepslateGlobal;
    }

    @Override
    public BlockState[] getPresetBlockStates(Level level, int bottomBlockY) {
        if (bottomBlockY < this.maxBlockHeight) {
            ResourceKey resourceKey = level.dimension();
            if (resourceKey.equals(Level.NETHER)) {
                return this.presetBlockStatesNetherrack;
            }
            if (resourceKey.equals(Level.END)) {
                return this.presetBlockStatesEndStone;
            }
            return bottomBlockY >= 0 ? this.presetBlockStatesStone : this.presetBlockStatesDeepslate;
        }
        return null;
    }
}

