/*
 * Decompiled with CFR 0.152.
 */
package me.drex.antixray.common.util.controller;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.drex.antixray.common.util.controller.ChunkPacketBlockControllerAntiXray;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.PaletteResize;

public class ObfuscateChunkPacketBlockController
extends ChunkPacketBlockControllerAntiXray {
    private final BlockState[] presetBlockStates;
    private final int[] presetBlockStateBitsGlobal;

    public ObfuscateChunkPacketBlockController(Level level, Set<Block> replacementBlocks, Set<Block> hiddenBlocks, int maxBlockHeight, int updateRadius, boolean lavaObscures, boolean usePermission) {
        super(level, Stream.concat(replacementBlocks.stream(), hiddenBlocks.stream()).collect(Collectors.toSet()), maxBlockHeight, updateRadius, lavaObscures, usePermission);
        BlockState[] blockStateArray;
        LinkedHashSet<BlockState> presetBlockStateSet = new LinkedHashSet<BlockState>();
        for (Block block : hiddenBlocks) {
            if (block == null || block instanceof EntityBlock) continue;
            presetBlockStateSet.add(block.defaultBlockState());
        }
        if (presetBlockStateSet.isEmpty()) {
            BlockState[] blockStateArray2 = new BlockState[1];
            blockStateArray = blockStateArray2;
            blockStateArray2[0] = Blocks.DIAMOND_ORE.defaultBlockState();
        } else {
            blockStateArray = presetBlockStateSet.toArray(new BlockState[0]);
        }
        this.presetBlockStates = blockStateArray;
        this.presetBlockStateBitsGlobal = new int[this.presetBlockStates.length];
        for (int i = 0; i < this.presetBlockStates.length; ++i) {
            this.presetBlockStateBitsGlobal[i] = GLOBAL_BLOCKSTATE_PALETTE.idFor((Object)this.presetBlockStates[i], PaletteResize.noResizeExpected());
        }
    }

    @Override
    protected int getPresetBlockStatesLength() {
        return this.presetBlockStates.length;
    }

    @Override
    protected int[] getPresetBlockStateBits(Level level, int bottomBlockY) {
        return this.presetBlockStateBitsGlobal;
    }

    @Override
    public BlockState[] getPresetBlockStates(Level level, int bottomBlockY) {
        if (bottomBlockY < this.maxBlockHeight) {
            return this.presetBlockStates;
        }
        return null;
    }
}

