/*
 * Decompiled with CFR 0.152.
 */
package haage.gui_time;

import haage.gui_time.GuiTimeConfig;
import java.util.Locale;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_9291;
import net.minecraft.class_9334;

public class GUITimeClient
implements ClientModInitializer {
    private static final class_2960 EXCL_ICON = class_2960.method_60655((String)"gui-time", (String)"textures/gui/exclamation.png");
    private static final class_2960 EXCL_ICON2 = class_2960.method_60655((String)"gui-time", (String)"textures/gui/exclamation_2.png");
    private static final class_2960 PHANTOM_ICON = class_2960.method_60655((String)"gui-time", (String)"textures/gui/phantom.png");
    private static int ticksSinceRest = 0;

    public static void setTicksSinceRest(int ticks) {
        ticksSinceRest = ticks;
    }

    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null) {
                ticksSinceRest = client.field_1724.method_6113() ? 0 : ++ticksSinceRest;
            }
        });
        HudRenderCallback.EVENT.register((ctx, tick) -> {
            int groupX;
            class_310 client = class_310.method_1551();
            if (client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            boolean inOverworld = client.field_1687.method_27983().equals(class_1937.field_25179);
            long dayTicks = client.field_1687.method_8532() % 24000L;
            boolean isNight = dayTicks >= 12540L && dayTicks <= 23458L;
            boolean isThundering = client.field_1687.method_8546();
            boolean isRaining = client.field_1687.method_8419();
            boolean canSleep = isThundering || isRaining && (dayTicks >= 12030L || dayTicks <= 0L) || !isRaining && !isThundering && isNight;
            boolean warnSoon = !canSleep && !isThundering && (isRaining && dayTicks >= 11030L && dayTicks < 12030L || !isRaining && dayTicks >= 11530L && dayTicks < 12540L);
            GuiTimeConfig cfg = GuiTimeConfig.get();
            GuiTimeConfig.Corner corner = cfg.corner;
            GuiTimeConfig.DisplayMode mode = cfg.displayMode;
            int sw = client.method_22683().method_4486();
            int sh = client.method_22683().method_4502();
            class_327 tr = client.field_1772;
            int textW = tr.method_1727("00:00");
            boolean wantExcl = cfg.showSleepIndicator && inOverworld;
            int iconW = mode == GuiTimeConfig.DisplayMode.ICON_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH ? 16 : 0;
            int exclW = wantExcl ? 6 : 0;
            int phantomW = cfg.showPhantomIndicator ? 10 : 0;
            int gap = 2;
            int groupW = 0;
            if (mode == GuiTimeConfig.DisplayMode.ICON_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH) {
                groupW += iconW;
            }
            if (cfg.showPhantomIndicator) {
                groupW += gap + phantomW;
            }
            if (exclW > 0) {
                groupW += gap + exclW;
            }
            if (mode == GuiTimeConfig.DisplayMode.TIME_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH) {
                groupW += gap + textW;
            }
            int groupY = switch (corner) {
                case GuiTimeConfig.Corner.TOP_LEFT -> {
                    groupX = 10;
                    yield 10;
                }
                case GuiTimeConfig.Corner.TOP_RIGHT -> {
                    groupX = sw - 10 - groupW;
                    yield 10;
                }
                case GuiTimeConfig.Corner.TOP_CENTER -> {
                    groupX = (sw - groupW) / 2;
                    yield 10;
                }
                case GuiTimeConfig.Corner.BOTTOM_LEFT -> {
                    groupX = 10;
                    yield sh - 10 - 16;
                }
                default -> {
                    groupX = sw - 10 - groupW;
                    yield sh - 10 - 16;
                }
            };
            class_1799 clockStack = new class_1799((class_1935)class_1802.field_8557);
            clockStack.method_57379(class_9334.field_49614, (Object)new class_9291(null, false));
            boolean right = corner == GuiTimeConfig.Corner.TOP_RIGHT || corner == GuiTimeConfig.Corner.BOTTOM_RIGHT;
            int x = groupX;
            if (!right) {
                if (mode == GuiTimeConfig.DisplayMode.ICON_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH) {
                    ctx.method_51427(clockStack, x, groupY);
                    x += iconW + gap;
                }
                if (cfg.showPhantomIndicator && inOverworld && isNight && ticksSinceRest >= cfg.phantomThresholdTicks) {
                    ctx.method_25290(class_10799.field_56883, PHANTOM_ICON, x, groupY, 0.0f, 0.0f, phantomW, phantomW, phantomW, phantomW);
                    x += phantomW + gap;
                }
                if (wantExcl) {
                    if (warnSoon) {
                        ctx.method_25290(class_10799.field_56883, EXCL_ICON2, x, groupY, 0.0f, 0.0f, exclW, 16, exclW, 16);
                    } else if (canSleep) {
                        ctx.method_25290(class_10799.field_56883, EXCL_ICON, x, groupY, 0.0f, 0.0f, exclW, 16, exclW, 16);
                    }
                }
                x += exclW + gap;
                if (mode == GuiTimeConfig.DisplayMode.TIME_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH) {
                    String timeText = String.format(Locale.ROOT, "%02d:%02d", (int)(((float)dayTicks / 1000.0f + 6.0f) % 24.0f), (int)(((float)dayTicks / 1000.0f + 6.0f) % 1.0f * 60.0f));
                    ctx.method_51433(tr, timeText, x, groupY + 4, -1, true);
                }
            } else {
                if (mode == GuiTimeConfig.DisplayMode.TIME_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH) {
                    String timeText = String.format(Locale.ROOT, "%02d:%02d", (int)(((float)dayTicks / 1000.0f + 6.0f) % 24.0f), (int)(((float)dayTicks / 1000.0f + 6.0f) % 1.0f * 60.0f));
                    ctx.method_51433(tr, timeText, x, groupY + 4, -1, true);
                    x += textW + gap;
                }
                if (wantExcl) {
                    if (warnSoon) {
                        ctx.method_25290(class_10799.field_56883, EXCL_ICON2, x, groupY, 0.0f, 0.0f, exclW, 16, exclW, 16);
                    } else if (canSleep) {
                        ctx.method_25290(class_10799.field_56883, EXCL_ICON, x, groupY, 0.0f, 0.0f, exclW, 16, exclW, 16);
                    }
                }
                x += exclW + gap;
                if (cfg.showPhantomIndicator && inOverworld && isNight && ticksSinceRest >= cfg.phantomThresholdTicks) {
                    ctx.method_25290(class_10799.field_56883, PHANTOM_ICON, x, groupY, 0.0f, 0.0f, phantomW, phantomW, phantomW, phantomW);
                    x += phantomW + gap;
                }
                if (mode == GuiTimeConfig.DisplayMode.ICON_ONLY || mode == GuiTimeConfig.DisplayMode.BOTH) {
                    ctx.method_51427(clockStack, x, groupY);
                }
            }
        });
    }
}

