/*
 * Decompiled with CFR 0.152.
 */
package haage.gui_time;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class GuiTimeConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("gui-time.json");
    private static GuiTimeConfig instance;
    public Corner corner = Corner.BOTTOM_RIGHT;
    public DisplayMode displayMode = DisplayMode.BOTH;
    public boolean showSleepIndicator = true;
    public boolean showPhantomIndicator = true;
    public int phantomThresholdTicks = 72000;

    public static GuiTimeConfig get() {
        if (instance == null) {
            GuiTimeConfig.load();
        }
        return instance;
    }

    public static void load() {
        block9: {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try (BufferedReader r = Files.newBufferedReader(CONFIG_PATH);){
                        instance = (GuiTimeConfig)gson.fromJson((Reader)r, GuiTimeConfig.class);
                        break block9;
                    }
                }
                instance = new GuiTimeConfig();
                GuiTimeConfig.save();
            }
            catch (IOException e) {
                e.printStackTrace();
                instance = new GuiTimeConfig();
            }
        }
    }

    public static void save() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                gson.toJson((Object)GuiTimeConfig.get(), (Appendable)w);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum Corner {
        TOP_LEFT,
        TOP_RIGHT,
        TOP_CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static enum DisplayMode {
        NONE,
        ICON_ONLY,
        TIME_ONLY,
        BOTH;

    }
}

