/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packet.commands.layout.command.LayoutCommandPacket;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LayoutCommand {
    public static final Map<String, List<String>> CACHED_LAYOUT_SUGGESTIONS = Collections.synchronizedMap(new HashMap());

    public static void register() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add((Argument)new TextArgument("layout_name").replaceSuggestions(ArgumentSuggestions.stringCollection(info -> LayoutCommand.getVariableSuggestions((CommandSender)info.sender()))));
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("fmlayout").withArguments(arguments)).withArguments((AbstractArgument[])new Argument[]{new BooleanArgument("enabled")})).withOptionalArguments((AbstractArgument[])new Argument[]{(Argument)new EntitySelectorArgument.ManyPlayers("target_players").withPermission(CommandPermission.OP)})).executes((sender, args) -> {
            String layout_name = (String)args.get("layout_name");
            Boolean enabled = (Boolean)args.get("enabled");
            Collection players = (Collection)args.get("target_players");
            LayoutCommand.setLayoutState(sender, layout_name, Boolean.TRUE.equals(enabled), players);
        }, new ExecutorType[0])).register();
    }

    private static List<String> getVariableSuggestions(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ArrayList<String> l = new ArrayList<String>(Objects.requireNonNullElse(CACHED_LAYOUT_SUGGESTIONS.get(player.getUniqueId().toString()), new ArrayList()));
            if (l.isEmpty()) {
                l.add("<no_layouts_found>");
            }
            return l;
        }
        return new ArrayList<String>();
    }

    private static void setLayoutState(CommandSender sender, String layoutName, boolean enabled, @Nullable Collection<Player> targets) {
        try {
            if (targets == null) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    LayoutCommandPacket packet = new LayoutCommandPacket();
                    packet.layout_name = layoutName;
                    packet.enabled = enabled;
                    PacketHandler.sendToClient(player, packet);
                }
            } else {
                for (Player target : targets) {
                    LayoutCommandPacket packet = new LayoutCommandPacket();
                    packet.layout_name = layoutName;
                    packet.enabled = enabled;
                    PacketHandler.sendToClient(target, packet);
                }
            }
        }
        catch (Exception ex) {
            sender.sendMessage("\u00a7cError while executing /fmlayout command!");
            ex.printStackTrace();
        }
    }
}

