/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packet.commands.variable.command.VariableCommandPacket;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VariableCommand {
    public static final Map<String, List<String>> CACHED_VARIABLE_SUGGESTIONS = Collections.synchronizedMap(new HashMap());

    public static void register() {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add((Argument)new TextArgument("variable_name").replaceSuggestions(ArgumentSuggestions.stringCollection(info -> VariableCommand.getVariableSuggestions((CommandSender)info.sender()))));
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("fmvariable").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("get")})).withArguments(arguments)).executesPlayer((sender, args) -> {
            String variable_name = (String)args.get("variable_name");
            VariableCommand.getVariable((CommandSender)sender, variable_name);
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("fmvariable").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("set")})).withArguments(arguments)).withArguments((AbstractArgument[])new Argument[]{new BooleanArgument("send_chat_feedback")})).withArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("set_to_value").replaceSuggestions(ArgumentSuggestions.strings((String[])new String[]{"<set_to_value>"}))})).withOptionalArguments((AbstractArgument[])new Argument[]{(Argument)new EntitySelectorArgument.ManyPlayers("target_players").withPermission(CommandPermission.OP)})).executes((sender, args) -> {
            String variable_name = (String)args.get("variable_name");
            Boolean send_chat_feedback = (Boolean)args.get("send_chat_feedback");
            String set_to_value = (String)args.get("set_to_value");
            Collection players = (Collection)args.get("target_players");
            if (players != null) {
                for (Player player : players) {
                    VariableCommand.setVariable((CommandSender)player, variable_name, set_to_value, Boolean.TRUE.equals(send_chat_feedback));
                }
            } else {
                VariableCommand.setVariable(sender, variable_name, set_to_value, Boolean.TRUE.equals(send_chat_feedback));
            }
        }, new ExecutorType[0])).register();
    }

    private static List<String> getVariableSuggestions(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ArrayList<String> l = new ArrayList<String>(Objects.requireNonNullElse(CACHED_VARIABLE_SUGGESTIONS.get(player.getUniqueId().toString()), new ArrayList()));
            if (l.isEmpty()) {
                l.add("<no_variables_found>");
            }
            return l;
        }
        return new ArrayList<String>();
    }

    private static void getVariable(CommandSender sender, String variableName) {
        try {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (variableName != null) {
                    VariableCommandPacket packet = new VariableCommandPacket();
                    packet.set = false;
                    packet.variable_name = variableName;
                    PacketHandler.sendToClient(player, packet);
                }
            }
        }
        catch (Exception ex) {
            sender.sendMessage("\u00a7cError while executing command!");
            ex.printStackTrace();
        }
    }

    private static void setVariable(CommandSender sender, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (variableName != null && setToValue != null) {
                    VariableCommandPacket packet = new VariableCommandPacket();
                    packet.set = true;
                    packet.variable_name = variableName;
                    packet.set_to_value = setToValue;
                    packet.feedback = sendFeedback;
                    PacketHandler.sendToClient(player, packet);
                }
            }
        }
        catch (Exception ex) {
            sender.sendMessage("\u00a7cError while executing command!");
            ex.printStackTrace();
        }
    }
}

