/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.networking;

import de.keksuccino.fancymenu.networking.Packet;
import de.keksuccino.fancymenu.networking.PacketCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;

public class PacketRegistry {
    private static final Logger LOGGER = Bukkit.getLogger();
    private static final Map<String, PacketCodec<?>> CODECS = new HashMap();
    private static boolean registrationsAllowed = true;

    public static void register(PacketCodec<?> codec) {
        if (!registrationsAllowed) {
            throw new RuntimeException("Tried to register PacketCodec too late! PacketCodecs need to get registered as early as possible!");
        }
        if (CODECS.containsKey(Objects.requireNonNull(codec.getPacketIdentifier()))) {
            LOGGER.log(Level.WARNING, "[FANCYMENU] PacketCodec with identifier '" + codec.getPacketIdentifier() + "' already registered! Overriding codec!");
        }
        CODECS.put(codec.getPacketIdentifier(), codec);
    }

    public static List<PacketCodec<?>> getCodecs() {
        return new ArrayList(CODECS.values());
    }

    @Nullable
    public static PacketCodec<?> getCodec(String identifier) {
        return CODECS.get(identifier);
    }

    @Nullable
    public static <T extends Packet> PacketCodec<T> getCodecFor(T packet) {
        try {
            for (PacketCodec<?> codec : CODECS.values()) {
                if (codec.getType() != packet.getClass()) continue;
                return codec;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "[FANCYMENU] Failed to get codec for packet!", ex);
        }
        return null;
    }

    public static void endRegistrationPhase() {
        registrationsAllowed = false;
    }
}

