/*
 * Decompiled with CFR 0.152.
 */
package ru.cobaltmc.falling_snow.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowLayerBlock.class})
public class FallingSnowMixin
extends Block {
    public FallingSnowMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean isFree(BlockState blockState) {
        return blockState.isAir() || blockState.liquid() || blockState.canBeReplaced();
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    protected void snowLayerUpdateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2, CallbackInfoReturnable<BlockState> cir) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos below = pos.below();
        if (this.isFree(level.getBlockState(below)) && pos.getY() >= level.getMinBuildHeight()) {
            level.scheduleTick(pos, (Block)((SnowLayerBlock)this), 2);
            cir.setReturnValue((Object)state);
            cir.cancel();
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.isFree(world.getBlockState(pos.below()))) {
            FallingBlockEntity fall = FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
            fall.dropItem = false;
            world.addFreshEntity((Entity)fall);
            world.removeBlock(pos, false);
        }
    }
}

