/*
 * Decompiled with CFR 0.152.
 */
package ru.cobaltmc.falling_snow.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.cobaltmc.falling_snow.ModConfig;

@Mixin(value={SnowLayerBlock.class})
public class SnowLayerBlockMixin
extends Block
implements Fallable {
    public SnowLayerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean isFree(BlockState blockState) {
        return blockState.isAir() || blockState.liquid() || blockState.canBeReplaced() && !blockState.is(Blocks.SNOW);
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    protected void snowLayerUpdateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2, CallbackInfoReturnable<BlockState> cir) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos below = pos.below();
        if (this.isFree(level.getBlockState(below)) && pos.getY() >= level.getMinBuildHeight()) {
            level.scheduleTick(pos, (Block)((SnowLayerBlock)this), 2);
            System.out.println("Pos: " + String.valueOf(below));
            cir.setReturnValue((Object)state);
            cir.cancel();
        }
    }

    public void onLand(Level level, BlockPos blockPos, BlockState blockState, BlockState blockState2, FallingBlockEntity fallingBlockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (ModConfig.getInstance().particles) {
            world.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, fallingBlockEntity.getX(), fallingBlockEntity.getY() + 0.125 * (double)((Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS)).intValue(), fallingBlockEntity.getZ(), 20, 0.35, 0.1, 0.35, 0.03);
        }
        if (ModConfig.getInstance().playSound) {
            world.playSound(null, blockPos, SoundEvents.SNOW_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.isFree(world.getBlockState(pos.below()))) {
            FallingBlockEntity fall = FallingBlockEntity.fall((Level)world, (BlockPos)pos, (BlockState)state);
            fall.dropItem = false;
            world.addFreshEntity((Entity)fall);
            world.removeBlock(pos, false);
        }
    }
}

