/*
 * Decompiled with CFR 0.152.
 */
package ru.cobaltmc.falling_snow.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.cobaltmc.falling_snow.ModConfig;

@Mixin(value={SnowLayerBlock.class})
public class SnowLayerBlockMixin
extends Block
implements Fallable {
    public SnowLayerBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean isFree(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_278721_() || blockState.m_247087_() && !blockState.m_60713_(Blocks.f_50125_);
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    protected void snowLayerUpdateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2, CallbackInfoReturnable<BlockState> cir) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        BlockPos below = pos.m_7495_();
        if (this.isFree(level.m_8055_(below)) && pos.m_123342_() >= level.m_141937_()) {
            level.m_186460_(pos, (Block)((SnowLayerBlock)this), 2);
            System.out.println("Pos: " + String.valueOf(below));
            cir.setReturnValue((Object)state);
            cir.cancel();
        }
    }

    public void m_48792_(Level level, BlockPos blockPos, BlockState blockState, BlockState blockState2, FallingBlockEntity fallingBlockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (ModConfig.getInstance().particles) {
            world.m_8767_((ParticleOptions)ParticleTypes.f_175821_, fallingBlockEntity.m_20185_(), fallingBlockEntity.m_20186_() + 0.125 * (double)((Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_)).intValue(), fallingBlockEntity.m_20189_(), 20, 0.35, 0.1, 0.35, 0.03);
        }
        if (ModConfig.getInstance().playSound) {
            world.m_5594_(null, blockPos, SoundEvents.f_12482_, SoundSource.BLOCKS, 1.0f, 0.9f);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.isFree(world.m_8055_(pos.m_7495_()))) {
            FallingBlockEntity fall = FallingBlockEntity.m_201971_((Level)world, (BlockPos)pos, (BlockState)state);
            fall.f_31943_ = false;
            world.m_7967_((Entity)fall);
            world.m_7471_(pos, false);
        }
    }
}

