# temp4.mcfunction - Normal temperate biomes with day/night cycles

# Set base kht_temperature
scoreboard players set @s kht_base_temp 5

# Start with base kht_temperature
scoreboard players operation @s kht_temperature = @s kht_base_temp

# Apply cold drink effect (-1 kht_temperature for 20 seconds after drinking water)
execute if score @s kht_cold_drink_timer matches 1.. run scoreboard players remove @s kht_temperature 1

execute if score #global kht_weatherCool matches 1 unless score @s kht_has_shade matches 1 run scoreboard players remove @s kht_temperature 1
# Apply day/night cycle effects
execute if score @s kht_game_time matches 1000..11000 unless score @s kht_has_shade matches 1 unless score #global kht_cloads matches 1 run scoreboard players add @s kht_temperature 1
# Night (13000-23000): -1 kht_temperature (colder)
execute if score @s kht_game_time matches 13000..23000 run scoreboard players remove @s kht_temperature 1
# Sunrise/Sunset (0-999, 11001-12999, 23001-23999): no modifier (normal)

# Apply torch heating effects (+2 when holding torch)
execute if entity @s[nbt={SelectedItem:{id:"minecraft:torch"}}] run scoreboard players add @s kht_temperature 2

# Apply water contact effects (-1 when touching water)
execute at @s if block ~ ~ ~ minecraft:water run scoreboard players remove @s kht_temperature 1
execute at @s if block ~ ~1 ~ minecraft:water run scoreboard players remove @s kht_temperature 1
execute at @s if block ~ ~ ~ minecraft:water_cauldron run scoreboard players remove @s kht_temperature 1
# kht_temperature effects based on kht_elevation (only for kht_difficulty 5)
execute as @a[scores={kht_difficulty=5,kht_elevation=0}] run scoreboard players remove @s kht_temperature 2
execute as @a[scores={kht_difficulty=5,kht_elevation=1}] run scoreboard players remove @s kht_temperature 1
execute as @a[scores={kht_difficulty=5,kht_elevation=2}] run scoreboard players remove @s kht_temperature 0
execute as @a[scores={kht_difficulty=5,kht_elevation=3}] run scoreboard players remove @s kht_temperature 1
execute as @a[scores={kht_difficulty=5,kht_elevation=4}] run scoreboard players remove @s kht_temperature 2
# Apply food kht_temperature effects to base kht_temperature
execute as @a[scores={kht_food_temp=5}] run scoreboard players add @s kht_temperature 2
execute as @a[scores={kht_food_temp=4}] run scoreboard players add @s kht_temperature 1
execute as @a[scores={kht_food_temp=2}] run scoreboard players remove @s kht_temperature 1
execute as @a[scores={kht_food_temp=1}] run scoreboard players remove @s kht_temperature 2
# kht_temperature capping - prevent values from going beyond 1-7 range
execute if score @s kht_temperature matches 8.. run scoreboard players set @s kht_temperature 7
execute if score @s kht_temperature matches ..0 run scoreboard players set @s kht_temperature 1