# temp4.mcfunction - Normal temperate biomes with day/night cycles

# Set base temperature
scoreboard players set @s base_temp 5

# Start with base temperature
scoreboard players operation @s temperature = @s base_temp

# Apply cold drink effect (-1 temperature for 20 seconds after drinking water)
execute if score @s cold_drink_timer matches 1.. run scoreboard players remove @s temperature 1

# Apply day/night cycle effects
# Day (1000-11000): +1 temperature (hotter) 
execute if score @s game_time matches 1000..11000 unless score @s has_shade matches 1 run scoreboard players add @s temperature 1
# Night (13000-23000): -1 temperature (colder)
execute if score @s game_time matches 13000..23000 run scoreboard players remove @s temperature 1
# Sunrise/Sunset (0-999, 11001-12999, 23001-23999): no modifier (normal)

# Apply torch heating effects (+2 when holding torch)
execute if entity @s[nbt={SelectedItem:{id:"minecraft:torch"}}] run scoreboard players add @s temperature 2

# Apply water contact effects (-1 when touching water)
execute at @s if block ~ ~ ~ minecraft:water run scoreboard players remove @s temperature 1
execute at @s if block ~ ~1 ~ minecraft:water run scoreboard players remove @s temperature 1
execute at @s if block ~ ~ ~ minecraft:water_cauldron run scoreboard players remove @s temperature 1
# Temperature effects based on elevation (only for difficulty 5)
execute as @a[scores={difficulty=5,elevation=0}] run scoreboard players remove @s temperature 2
execute as @a[scores={difficulty=5,elevation=1}] run scoreboard players remove @s temperature 1
execute as @a[scores={difficulty=5,elevation=2}] run scoreboard players remove @s temperature 0
execute as @a[scores={difficulty=5,elevation=3}] run scoreboard players remove @s temperature 1
execute as @a[scores={difficulty=5,elevation=4}] run scoreboard players remove @s temperature 2
# Apply food temperature effects to base temperature
execute as @a[scores={food_temp=5}] run scoreboard players add @s temperature 2
execute as @a[scores={food_temp=4}] run scoreboard players add @s temperature 1
execute as @a[scores={food_temp=2}] run scoreboard players remove @s temperature 1
execute as @a[scores={food_temp=1}] run scoreboard players remove @s temperature 2
# Temperature capping - prevent values from going beyond 1-7 range
execute if score @s temperature matches 8.. run scoreboard players set @s temperature 7
execute if score @s temperature matches ..0 run scoreboard players set @s temperature 1