# Handle respawn - reset thirst for players who died
execute as @a[scores={deaththirst=1..}] run function thirst:respawn_handler
execute as @a[scores={deaththirst=1..}] run scoreboard players set @s deaththirst 0
# Enable difficulty trigger only for ops
execute as @a[tag=op] run scoreboard players enable @s kht_difficulty

# This runs every tick and overwrites the load value

execute as @a store result score @s game_time run time query daytime

# MOLTEN BIOMES (7) - All Nether biomes have no day/night cycle
execute as @a at @s if biome ~ ~ ~ minecraft:nether_wastes run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:soul_sand_valley run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:crimson_forest run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:warped_forest run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:basalt_deltas run function thirst:biomes/temp7_special

# HOT BIOMES (6) - Desert climates get special night cooling
execute as @a at @s if biome ~ ~ ~ minecraft:desert run function thirst:biomes/temp_desert
execute as @a at @s if biome ~ ~ ~ minecraft:badlands run function thirst:biomes/temp_desert
execute as @a at @s if biome ~ ~ ~ minecraft:eroded_badlands run function thirst:biomes/temp_desert
execute as @a at @s if biome ~ ~ ~ minecraft:wooded_badlands run function thirst:biomes/temp6

# WARM BIOMES (5) - Tropical/humid climates
execute as @a at @s if biome ~ ~ ~ minecraft:savanna run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:savanna_plateau run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_savanna run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:jungle run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:sparse_jungle run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:bamboo_jungle run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:mangrove_swamp run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:swamp run function thirst:biomes/temp5

# NORMAL BIOMES (4) - Temperate climates
execute as @a at @s if biome ~ ~ ~ minecraft:plains run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:sunflower_plains run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:flower_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:birch_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:old_growth_birch_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:dark_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_hills run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_gravelly_hills run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:meadow run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:cherry_grove run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:mushroom_fields run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:beach run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:river run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:ocean run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:lukewarm_ocean run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:deep_lukewarm_ocean run function thirst:biomes/temp4

# CHILLY BIOMES (3) - Cool temperate climates
execute as @a at @s if biome ~ ~ ~ minecraft:stony_shore run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:old_growth_pine_taiga run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:old_growth_spruce_taiga run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:cold_ocean run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:deep_cold_ocean run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:taiga run function thirst:biomes/temp3

# COLD BIOMES (2) - Snowy/mountain climates
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_taiga run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:grove run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_beach run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_plains run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:ice_spikes run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_slopes run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:jagged_peaks run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:frozen_peaks run function thirst:biomes/temp2

# FREEZING BIOMES (1) - Arctic climates
execute as @a at @s if biome ~ ~ ~ minecraft:frozen_ocean run function thirst:biomes/temp1
execute as @a at @s if biome ~ ~ ~ minecraft:deep_frozen_ocean run function thirst:biomes/temp1
execute as @a at @s if biome ~ ~ ~ minecraft:frozen_river run function thirst:biomes/temp1

# SPECIAL FREEZING BIOMES (1) - With no day/night effects
execute as @a at @s if biome ~ ~ ~ minecraft:deep_dark run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:the_end run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:end_highlands run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:end_midlands run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:small_end_islands run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:end_barrens run function thirst:biomes/temp1_special
execute as @a run function thirst:activity_temperature

# Add to tick.mcfunction - 5-block campfire detection in any direction

# Check for lit campfires within 5 blocks in all directions
execute as @a at @s if block ~5 ~ ~ minecraft:campfire[lit=true] run function thirst:campfire_logic
execute as @a at @s if block ~-5 ~ ~ minecraft:campfire[lit=true] run function thirst:campfire_logic
execute as @a at @s if block ~ ~ ~5 minecraft:campfire[lit=true] run function thirst:campfire_logic
execute as @a at @s if block ~ ~ ~-5 minecraft:campfire[lit=true] run function thirst:campfire_logic
execute as @a at @s if block ~ ~5 ~ minecraft:campfire[lit=true] run function thirst:campfire_logic
execute as @a at @s if block ~ ~-5 ~ minecraft:campfire[lit=true] run function thirst:campfire_logic

# campfire_logic.mcfunction - Create this blank function
# (Leave this function empty as requested)

# Assume full sun access (0) by default
scoreboard players set @a has_shade 0

# Check each block from 1 to 30 blocks above player
# Only set to 1 if not already set (so first solid block found sets it)
execute as @a[scores={has_shade=0}] at @s unless block ~ ~1 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~2 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~3 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~4 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~5 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~6 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~7 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~8 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~9 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~10 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~11 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~12 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~13 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~14 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~15 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~16 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~17 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~18 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~19 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~20 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~21 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~22 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~23 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~24 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~25 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~26 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~27 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~28 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~29 ~ minecraft:air run scoreboard players set @s has_shade 1
execute as @a[scores={has_shade=0}] at @s unless block ~ ~30 ~ minecraft:air run scoreboard players set @s has_shade 1

execute as @a at @s if score #global clouds matches 1 run scoreboard players set @s has_shade 1

# Elevation detection (only for difficulty 5)
execute as @a[scores={difficulty=5}] at @s if entity @s[y=-1,dy=1] run scoreboard players set @s elevation 0
execute as @a[scores={difficulty=5}] at @s if entity @s[y=-2,dy=1] run scoreboard players set @s elevation 0
execute as @a[scores={difficulty=5}] at @s if entity @s[y=-3,dy=1] run scoreboard players set @s elevation 0

execute as @a[scores={difficulty=5}] at @s if entity @s[y=0,dy=1] run scoreboard players set @s elevation 1
execute as @a[scores={difficulty=5}] at @s if entity @s[y=1,dy=1] run scoreboard players set @s elevation 1
execute as @a[scores={difficulty=5}] at @s if entity @s[y=2,dy=1] run scoreboard players set @s elevation 1

execute as @a[scores={difficulty=5}] at @s if entity @s[y=37,dy=1] run scoreboard players set @s elevation 1
execute as @a[scores={difficulty=5}] at @s if entity @s[y=38,dy=1] run scoreboard players set @s elevation 1
execute as @a[scores={difficulty=5}] at @s if entity @s[y=39,dy=1] run scoreboard players set @s elevation 1

execute as @a[scores={difficulty=5}] at @s if entity @s[y=40,dy=1] run scoreboard players set @s elevation 2
execute as @a[scores={difficulty=5}] at @s if entity @s[y=41,dy=1] run scoreboard players set @s elevation 2
execute as @a[scores={difficulty=5}] at @s if entity @s[y=42,dy=1] run scoreboard players set @s elevation 2

execute as @a[scores={difficulty=5}] at @s if entity @s[y=97,dy=1] run scoreboard players set @s elevation 2
execute as @a[scores={difficulty=5}] at @s if entity @s[y=98,dy=1] run scoreboard players set @s elevation 2
execute as @a[scores={difficulty=5}] at @s if entity @s[y=99,dy=1] run scoreboard players set @s elevation 2

execute as @a[scores={difficulty=5}] at @s if entity @s[y=100,dy=1] run scoreboard players set @s elevation 3
execute as @a[scores={difficulty=5}] at @s if entity @s[y=101,dy=1] run scoreboard players set @s elevation 3
execute as @a[scores={difficulty=5}] at @s if entity @s[y=102,dy=1] run scoreboard players set @s elevation 3

execute as @a[scores={difficulty=5}] at @s if entity @s[y=147,dy=1] run scoreboard players set @s elevation 3
execute as @a[scores={difficulty=5}] at @s if entity @s[y=148,dy=1] run scoreboard players set @s elevation 3
execute as @a[scores={difficulty=5}] at @s if entity @s[y=149,dy=1] run scoreboard players set @s elevation 3

execute as @a[scores={difficulty=5}] at @s if entity @s[y=150,dy=1] run scoreboard players set @s elevation 4
execute as @a[scores={difficulty=5}] at @s if entity @s[y=151,dy=1] run scoreboard players set @s elevation 4
execute as @a[scores={difficulty=5}] at @s if entity @s[y=152,dy=1] run scoreboard players set @s elevation 4

# Run daily flag timer (0-50 ticks)
execute as @a[scores={kht_dailyflag=0..4999}] run scoreboard players add @s kht_dailyflag 1
execute as @a[scores={kht_dailyflag=5000}] run function thirst:dailyflag
execute as @a[scores={kht_dailyflag=5000}] run scoreboard players set @s kht_dailyflag 0

# Weather timer (1% chance every 1000 ticks - about 50 seconds)
scoreboard players add #global globalDayTimer 1
execute if score #global globalDayTimer matches 1000 store result score #random dummy run random value 1..100
execute if score #global globalDayTimer matches 1000 if score #random dummy matches 1 run function thirst:daily_random_event
execute if score #global globalDayTimer matches 1000 run scoreboard players set #global globalDayTimer 0
# Countdown timer
execute as @a[scores={food_timer=1..}] run scoreboard players remove @s food_timer 1

# Remove effects when timer expires
execute as @a[scores={food_timer=0,food_temp=1..}] run scoreboard players set @s food_temp 3
execute as @a[scores={food_timer=0,food_temp=1..}] run scoreboard players set @s food_temp 3

# Detect drinking and apply cooling effect
execute as @a run function thirst:detect_drinking

# Countdown cold drink timer
execute as @a[scores={cold_drink_timer=1..}] run scoreboard players remove @s cold_drink_timer 1

# Countdown timer for each player's thirst
execute as @a[scores={thirst=1..}] run scoreboard players remove @s thirst_timer 1

# When thirst timer reaches 0, decrease thirst
execute as @a[scores={thirst_timer=..0}] run function thirst:decrease

# Handlers
execute as @a run function thirst:difficulty_handler
# Always update actionbar display
execute as @a run function thirst:display/main_display

# Damage players with 0 thirst
execute as @a[scores={thirst=0}] run function thirst:damage