# Handle respawn - reset thirst for players who died
execute as @a[scores={kht_death_thirst=1..}] run function thirst:respawn_handler
execute as @a[scores={kht_death_thirst=1..}] run scoreboard players set @s kht_death_thirst 0
# Enable kht_difficulty trigger only for ops
execute as @a[tag=op] run scoreboard players enable @s kht_diff_temp
# Only run kht_difficulty handler when someone actually has a trigger value set
execute if entity @a[scores={kht_diff_temp=1..}] run function thirst:kht_difficulty_handler
execute as @a store result score @s kht_game_time run time query daytime

execute as @a run function thirst:display/custom_hud_test

# MOLTEN BIOMES (7) - All Nether biomes have no day/night cycle
execute as @a at @s if biome ~ ~ ~ minecraft:nether_wastes run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:soul_sand_valley run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:crimson_forest run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:warped_forest run function thirst:biomes/temp7_special
execute as @a at @s if biome ~ ~ ~ minecraft:basalt_deltas run function thirst:biomes/temp7_special

# HOT BIOMES (6) - Desert climates get special night cooling
execute as @a at @s if biome ~ ~ ~ minecraft:desert run function thirst:biomes/temp_desert
execute as @a at @s if biome ~ ~ ~ minecraft:badlands run function thirst:biomes/temp_desert
execute as @a at @s if biome ~ ~ ~ minecraft:eroded_badlands run function thirst:biomes/temp_desert
execute as @a at @s if biome ~ ~ ~ minecraft:wooded_badlands run function thirst:biomes/temp6

# WARM BIOMES (5) - Tropical/humid climates
execute as @a at @s if biome ~ ~ ~ minecraft:savanna run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:savanna_plateau run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_savanna run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:jungle run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:sparse_jungle run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:bamboo_jungle run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:mangrove_swamp run function thirst:biomes/temp5
execute as @a at @s if biome ~ ~ ~ minecraft:swamp run function thirst:biomes/temp5

# NORMAL BIOMES (4) - Temperate climates
execute as @a at @s if biome ~ ~ ~ minecraft:plains run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:sunflower_plains run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:flower_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:birch_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:old_growth_birch_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:dark_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_hills run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_forest run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:windswept_gravelly_hills run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:meadow run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:cherry_grove run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:mushroom_fields run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:beach run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:river run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:ocean run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:lukewarm_ocean run function thirst:biomes/temp4
execute as @a at @s if biome ~ ~ ~ minecraft:deep_lukewarm_ocean run function thirst:biomes/temp4

# CHILLY BIOMES (3) - Cool temperate climates
execute as @a at @s if biome ~ ~ ~ minecraft:stony_shore run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:old_growth_pine_taiga run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:old_growth_spruce_taiga run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:cold_ocean run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:deep_cold_ocean run function thirst:biomes/temp3
execute as @a at @s if biome ~ ~ ~ minecraft:taiga run function thirst:biomes/temp3

# COLD BIOMES (2) - Snowy/mountain climates
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_taiga run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:grove run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_beach run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_plains run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:ice_spikes run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:snowy_slopes run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:jagged_peaks run function thirst:biomes/temp2
execute as @a at @s if biome ~ ~ ~ minecraft:frozen_peaks run function thirst:biomes/temp2

# FREEZING BIOMES (1) - Arctic climates
execute as @a at @s if biome ~ ~ ~ minecraft:frozen_ocean run function thirst:biomes/temp1
execute as @a at @s if biome ~ ~ ~ minecraft:deep_frozen_ocean run function thirst:biomes/temp1
execute as @a at @s if biome ~ ~ ~ minecraft:frozen_river run function thirst:biomes/temp1

# SPECIAL FREEZING BIOMES (1) - With no day/night effects
execute as @a at @s if biome ~ ~ ~ minecraft:deep_dark run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:the_end run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:end_highlands run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:end_midlands run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:small_end_islands run function thirst:biomes/temp1_special
execute as @a at @s if biome ~ ~ ~ minecraft:end_barrens run function thirst:biomes/temp1_special
execute as @a run function thirst:activity_kht_temperature

# Check for lit campfires within 5 blocks in all directions
#execute as @a at @s if block ~5 ~ ~ minecraft:campfire[lit=true] run function thirst:item_effects/campfire_logic
#execute as @a at @s if block ~-5 ~ ~ minecraft:campfire[lit=true] run function thirst:item_effects/campfire_logic
#execute as @a at @s if block ~ ~ ~5 minecraft:campfire[lit=true] run function thirst:item_effects/campfire_logic
#execute as @a at @s if block ~ ~ ~-5 minecraft:campfire[lit=true] run function thirst:item_effects/campfire_logic
#execute as @a at @s if block ~ ~5 ~ minecraft:campfire[lit=true] run function thirst:item_effects/campfire_logic
#execute as @a at @s if block ~ ~-5 ~ minecraft:campfire[lit=true] run function thirst:item_effects/campfire_logic

# Assume full sun access (0) by default
scoreboard players set @a kht_has_shade 0

# Check each block from 1 to 30 blocks above player
# Only set to 1 if not already set (so first solid block found sets it)
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~1 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~2 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~3 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~4 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~5 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~6 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~7 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~8 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~9 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~10 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~11 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~12 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~13 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~14 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~15 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~16 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~17 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~18 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~19 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~20 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~21 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~22 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~23 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~24 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~25 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~26 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~27 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~28 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~29 ~ minecraft:air run scoreboard players set @s kht_has_shade 1
execute as @a[scores={kht_has_shade=0}] at @s unless block ~ ~30 ~ minecraft:air run scoreboard players set @s kht_has_shade 1

# Kht_elevation detection (only for kht_difficulty 5)
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=-1,dy=1] run scoreboard players set @s kht_elevation 0
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=-2,dy=1] run scoreboard players set @s kht_elevation 0
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=-3,dy=1] run scoreboard players set @s kht_elevation 0

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=0,dy=1] run scoreboard players set @s kht_elevation 1
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=1,dy=1] run scoreboard players set @s kht_elevation 1
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=2,dy=1] run scoreboard players set @s kht_elevation 1

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=37,dy=1] run scoreboard players set @s kht_elevation 1
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=38,dy=1] run scoreboard players set @s kht_elevation 1
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=39,dy=1] run scoreboard players set @s kht_elevation 1

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=40,dy=1] run scoreboard players set @s kht_elevation 2
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=41,dy=1] run scoreboard players set @s kht_elevation 2
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=42,dy=1] run scoreboard players set @s kht_elevation 2

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=97,dy=1] run scoreboard players set @s kht_elevation 2
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=98,dy=1] run scoreboard players set @s kht_elevation 2
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=99,dy=1] run scoreboard players set @s kht_elevation 2

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=100,dy=1] run scoreboard players set @s kht_elevation 3
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=101,dy=1] run scoreboard players set @s kht_elevation 3
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=102,dy=1] run scoreboard players set @s kht_elevation 3

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=147,dy=1] run scoreboard players set @s kht_elevation 3
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=148,dy=1] run scoreboard players set @s kht_elevation 3
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=149,dy=1] run scoreboard players set @s kht_elevation 3

execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=150,dy=1] run scoreboard players set @s kht_elevation 4
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=151,dy=1] run scoreboard players set @s kht_elevation 4
execute as @a[scores={kht_difficulty=5}] at @s if entity @s[y=152,dy=1] run scoreboard players set @s kht_elevation 4

# Detect player activities
function thirst:activity/detect_activity

# Apply activity effects to thirst/kht_temperature
execute if score #global kht_second_timer matches 0 as @a[tag=currently_walking] run function thirst:activity/walking_effects
execute if score #global kht_second_timer matches 0 as @a[tag=currently_kht_jumping] run function thirst:activity/kht_jumping_effects
execute if score #global kht_second_timer matches 0 as @a[tag=currently_swimming] run function thirst:activity/swimming_effects
execute if score #global kht_second_timer matches 0 as @a[tag=currently_fighting] run function thirst:activity/combat_effects
execute if score #global kht_second_timer matches 0 as @a[tag=currently_kht_running] run function thirst:activity/kht_running_effects
execute if score #global kht_second_timer matches 0 as @a[scores={kht_difficulty=4}] run function thirst:hunger/custom_hunger1
execute if score #global kht_second_timer matches 0 as @a[scores={kht_difficulty=5}] run function thirst:hunger/custom_hunger2
# Run daily flag timer (0-50 ticks)
execute as @a[scores={kht_dailyflag=0..4999}] run scoreboard players add @s kht_dailyflag 1
execute as @a[scores={kht_dailyflag=5000}] run function thirst:dailyflag
execute as @a[scores={kht_dailyflag=5000}] run scoreboard players set @s kht_dailyflag 0

# Second timer (cycles 0-19, triggers at 20)
scoreboard players add #global kht_second_timer 1
execute if score #global kht_second_timer matches 20 run scoreboard players set #global kht_second_timer 0

# Apply activity effects once per second
execute if score #global kht_second_timer matches 0 as @a[tag=currently_kht_running] run scoreboard players remove @s kht_thirst_timer 64
execute if score #global kht_second_timer matches 0 as @a[tag=currently_kht_running,tag=currently_kht_jumping] run scoreboard players remove @s kht_thirst_timer 32
execute if score #global kht_second_timer matches 0 as @a[tag=currently_swimming] run scoreboard players remove @s kht_thirst_timer 6
execute if score #global kht_second_timer matches 0 as @a[tag=currently_fighting] run scoreboard players remove @s kht_thirst_timer 64

# Weather timer countdown (when kht_cloads = 1)
execute if score #global kht_cloads matches 1 run scoreboard players add #global kht_weatherTimer 1
execute if score #global kht_weatherTimer matches 7200.. run function thirst:weather/end_weather

# Weather timer (1% chance every 1000 ticks - about 50 seconds)
scoreboard players add #global kht_globalDayTimer 1
execute if score #global kht_globalDayTimer matches 1000 store result score #random dummy run random value 1..100
execute if score #global kht_globalDayTimer matches 1000 if score #random dummy matches 1 run function thirst:flags/daily_random_event
execute if score #global kht_globalDayTimer matches 1000 run scoreboard players set #global kht_globalDayTimer 0
# Countdown timer
execute as @a[scores={kht_food_timer=1..}] run scoreboard players remove @s kht_food_timer 1

# Remove effects when timer expires
execute as @a[scores={kht_food_timer=0,kht_food_temp=1..}] run scoreboard players set @s kht_food_temp 3
execute as @a[scores={kht_food_timer=0,kht_food_temp=1..}] run scoreboard players set @s kht_food_temp 3

# Enable triggers for all players
scoreboard players enable @a kht_display_toggle
scoreboard players enable @a[tag=kht_admin] kht_master_display

# Handle new players (set them to master default)
execute as @a unless score @s kht_display_mode matches 1.. run function thirst:display/setup_new_player

# Handle personal display toggle
execute as @a if score @s kht_display_toggle matches 1 run function thirst:display/set_personal_custom
execute as @a if score @s kht_display_toggle matches 2 run function thirst:display/set_personal_unicode

# Handle master display commands (admin only)
execute as @a[tag=kht_admin] if score @s kht_master_display matches 1 run function thirst:display/set_master_custom  
execute as @a[tag=kht_admin] if score @s kht_master_display matches 2 run function thirst:display/set_master_unicode

# Reset triggers after use
scoreboard players reset @a[scores={kht_display_toggle=1..}] kht_display_toggle
scoreboard players reset @a[scores={kht_master_display=1..}] kht_master_display

# Detect drinking and apply cooling effect
execute as @a run function thirst:detect_drinking

# Countdown cold drink timer
execute as @a[scores={kht_cold_drink_timer=1..}] run scoreboard players remove @s kht_cold_drink_timer 1

# Countdown timer for each player's thirst
execute as @a[scores={kht_thirst=1..}] run scoreboard players remove @s thirst_timer 1

# When thirst timer reaches 0, decrease thirst
execute as @a[scores={kht_thirst_timer=..0}] run function thirst:decrease

# Always update actionbar display
execute as @a run function thirst:display/main_display

# Damage players with 0 thirst
execute as @a[scores={kht_thirst=0}] run function thirst:damage