/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;

public class AstralReaction
extends Reaction {
    public AstralReaction(String alias) {
        super(alias, 0);
    }

    @Override
    public boolean isPerfect(CrucibleBlockEntity crucible) {
        return true;
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        super.run(crucible);
        crucible.addPower((Power)Powers.ASTRAL_POWER.get(), 1600);
        crucible.expendPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValues.CURSE_RATE.get());
    }

    @Override
    public Reaction.Status conditionsMet(CrucibleBlockEntity crucible) {
        if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 0) {
            return Reaction.Status.REACTING;
        }
        return Reaction.Status.STABLE;
    }
}

