/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.function.Function;

public class EffectReaction
extends FreeEffectReaction {
    int cost;

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> effect, int numReagents) {
        super(alias, effect, numReagents);
        this.cost = WorldSpecificValue.get(alias + "cost", 10, 20);
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Power required_power) {
        super(alias, function, required_power);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Power ... required_powers) {
        super(alias, function, required_powers);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        super.run(crucible);
        for (Power p : this.reagents.keySet()) {
            crucible.expendPower(p, (int)((double)this.cost / (double)this.reagents.size()) + 1);
            crucible.setDirty();
        }
    }
}

