/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.function.Function;

public class FreeEffectReaction
extends Reaction {
    protected Function<CrucibleBlockEntity, CrucibleBlockEntity> effectFunction;

    public FreeEffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> effect, int numReagents) {
        super(alias, numReagents);
        this.effectFunction = effect;
    }

    public FreeEffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Power ... required_powers) {
        super(alias, 0);
        this.effectFunction = function;
        for (Power required_power : required_powers) {
            this.reagents.put(required_power, WorldSpecificValue.get(alias + required_power + "required", 1, 400));
        }
    }

    public FreeEffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Power required_power, int num_additionals) {
        super(alias, num_additionals);
        this.effectFunction = function;
        this.reagents.put(required_power, WorldSpecificValue.get(alias + "required", 1, 400));
    }

    @Override
    public String toString() {
        return super.toString() + " - effect reaction";
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        super.run(crucible);
        if (this.effectFunction != null) {
            this.effectFunction.apply(crucible);
        }
    }
}

