/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.ShulkerCrucibleBlock;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.BlockMoveChecker;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ReactionEffects {
    public static CrucibleBlockEntity explosion(CrucibleBlockEntity c) {
        BlockPos pos = c.m_58899_();
        ParticleScribe.drawParticleZigZag(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123762_, pos, c.areaMemory.fetch(c.m_58904_(), (Block)Registration.GOLD_SYMBOL.get()), 20, 7, 0.8f);
        if (c.areaMemory.exists(c.m_58904_(), (Block)Registration.IRON_SYMBOL.get())) {
            ParticleScribe.drawParticleZigZag(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123762_, c.areaMemory.fetch(c.m_58904_(), (Block)Registration.GOLD_SYMBOL.get()), c.areaMemory.fetch(c.m_58904_(), (Block)Registration.IRON_SYMBOL.get()), 20, 7, 0.8f);
        } else {
            SpecialCaseMan.checkEmptySpecialCases(c);
            c.expendPower();
            c.m_58904_().m_7731_(pos, (BlockState)c.m_58904_().m_8055_(pos).m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
            c.m_58904_().m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
            if (c.areaMemory.exists(c.m_58904_(), (Block)Registration.GOLD_SYMBOL.get())) {
                c.m_58904_().m_7471_(c.areaMemory.fetch(c.m_58904_(), (Block)Registration.GOLD_SYMBOL.get()), true);
            }
        }
        return c;
    }

    public static CrucibleBlockEntity foaming(CrucibleBlockEntity c) {
        BlockPos symbol_position = c.areaMemory.fetch(c.m_58904_(), (Block)Registration.GOLD_SYMBOL.get());
        if (symbol_position == null) {
            return c;
        }
        c.m_58904_().m_7731_(symbol_position, ((Block)Registration.ACTIVE_GOLD_FOAM.get()).m_49966_(), 2);
        ParticleScribe.drawParticleZigZag(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123806_, (float)c.m_58899_().m_123341_() + 0.5f, (float)c.m_58899_().m_123342_() + 0.5625f, (float)c.m_58899_().m_123343_() + 0.5f, (double)symbol_position.m_123341_() + 0.5, (double)symbol_position.m_123342_() + 0.5, (double)symbol_position.m_123343_() + 0.5, 12, 7, 0.4);
        return c;
    }

    public static CrucibleBlockEntity smoke(CrucibleBlockEntity c) {
        if ((double)c.m_58904_().f_46441_.m_188501_() < 0.4) {
            AABB aoe = new AABB(c.m_58899_());
            aoe = aoe.m_82400_(3.0);
            List nearby_ents = c.m_58904_().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (!CrystalIronItem.effectNotBlocked(e, 1)) continue;
                e.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 1));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1));
            }
        }
        return c;
    }

    public static CrucibleBlockEntity salt(CrucibleBlockEntity c) {
        if (c.getTotalPowerLevel() < WorldSpecificValue.get("salt_overflow_threshold", 1000, 1300)) {
            ItemEntity salt_drop = new ItemEntity(c.m_58904_(), (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5, (double)c.m_58899_().m_123343_() + 0.6, ((Item)Registration.SALT.get()).m_7968_());
            c.m_58904_().m_7967_((Entity)salt_drop);
        } else {
            CrucibleBlockEntity.empty(c.m_58904_(), c.m_58899_(), c.m_58900_(), c);
            if (c.m_58900_().m_60734_() instanceof ShulkerCrucibleBlock) {
                ItemEntity shell_drop = new ItemEntity(c.m_58904_(), (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5, (double)c.m_58899_().m_123343_() + 0.6, Items.f_42748_.m_7968_());
                c.m_58904_().m_7967_((Entity)shell_drop);
            }
            c.m_58904_().m_7731_(c.m_58899_(), ((Block)Registration.SALTY_CRUCIBLE.get()).m_49966_(), 2);
            c.m_58904_().m_5594_(null, c.m_58899_(), SoundEvents.f_11986_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return c;
    }

    public static CrucibleBlockEntity discharge(CrucibleBlockEntity c) {
        c.electricCharge += 5;
        if (c.electricCharge > 21) {
            BlockPos potential_rod = c.areaMemory.fetch(c.m_58904_(), Blocks.f_152587_);
            if (potential_rod != null) {
                if (!c.m_58904_().f_46443_) {
                    ((LightningRodBlock)Blocks.f_152587_).m_153760_(c.m_58904_().m_8055_(potential_rod), c.m_58904_(), potential_rod);
                    ParticleScribe.drawParticleZigZag(c.m_58904_(), (ParticleOptions)ParticleTypes.f_175830_, (float)c.m_58899_().m_123341_() + 0.5f, (float)c.m_58899_().m_123342_() + 0.5625f, (float)c.m_58899_().m_123343_() + 0.5f, (double)potential_rod.m_123341_() + 0.5, (double)potential_rod.m_123342_() + 0.5, (double)potential_rod.m_123343_() + 0.5, 8, 10, 0.6);
                    c.m_58904_().m_5594_(null, potential_rod, (SoundEvent)Registration.ZAP_SOUND.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else {
                AABB aoe = new AABB(c.m_58899_());
                aoe = aoe.m_82400_((double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue());
                List nearby_ents = c.m_58904_().m_45976_(LivingEntity.class, aoe);
                LivingEntity victim = null;
                for (LivingEntity e : nearby_ents) {
                    if (victim != null && !(e.m_20238_(Vec3.m_82512_((Vec3i)c.m_58899_())) < victim.m_20238_(Vec3.m_82512_((Vec3i)c.m_58899_()))) || !BeamHelper.hasLineOfSight(c.m_58904_(), Vec3.m_82512_((Vec3i)c.m_58899_()), e.m_20299_(0.0f), ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, c.m_58900_().m_60734_())) continue;
                    victim = e;
                }
                if (victim == null) {
                    return c;
                }
                if (!c.m_58904_().f_46443_) {
                    if (CrystalIronItem.effectNotBlocked(victim, 2)) {
                        victim.m_6469_(c.m_58904_().m_269111_().m_269425_(), 5.0f);
                    }
                    ParticleScribe.drawParticleZigZag(c.m_58904_(), (ParticleOptions)ParticleTypes.f_175830_, (float)c.m_58899_().m_123341_() + 0.5f, (float)c.m_58899_().m_123342_() + 0.5625f, (float)c.m_58899_().m_123343_() + 0.5f, victim.m_20185_(), (double)(victim.m_20192_() / 2.0f) + victim.m_20186_(), victim.m_20189_(), 8, 10, 0.3);
                    c.m_58904_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)Registration.ZAP_SOUND.get(), SoundSource.BLOCKS, 0.5f, 0.98f + c.m_58904_().f_46441_.m_188501_() * 0.05f);
                }
            }
            c.electricCharge = 0;
        }
        c.m_6596_();
        return c;
    }

    public static CrucibleBlockEntity levitation(CrucibleBlockEntity c) {
        AABB aoe = new AABB(c.m_58899_());
        aoe = aoe.m_82400_(12.0);
        List nearby_ents = c.m_58904_().m_45976_(LivingEntity.class, aoe);
        BlockPos origin_pos = c.m_58899_();
        for (LivingEntity victim : nearby_ents) {
            if (CrystalIronItem.effectNotBlocked(victim, 1)) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 1));
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    CriteriaTriggers.BE_LEVITATED_TRIGGER.trigger(player);
                }
            }
            ParticleScribe.drawParticleZigZag(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123810_, (double)origin_pos.m_123341_() + 0.5, (double)origin_pos.m_123342_() + 0.5625, (double)origin_pos.m_123343_() + 0.5, victim.m_20185_(), victim.m_20188_() - 0.2, victim.m_20189_(), 8, 7, 0.74);
            float pitch = 0.8f + c.m_58904_().f_46441_.m_188501_() * 0.1f;
            c.m_58904_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.BLOCKS, 0.3f, pitch);
            c.m_58904_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.BLOCKS, 0.3f, pitch / 2.0f);
        }
        return c;
    }

    public static CrucibleBlockEntity slowfall(CrucibleBlockEntity crucible) {
        AABB aoe = new AABB(crucible.m_58899_());
        aoe = aoe.m_82400_(12.0);
        List nearby_ents = crucible.m_58904_().m_45976_(LivingEntity.class, aoe);
        for (LivingEntity victim : nearby_ents) {
            if (CrystalIronItem.effectNotBlocked(victim, 1)) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 1));
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    CriteriaTriggers.BE_SLOWFALLED_TRIGGER.trigger(player);
                }
            }
            ParticleScribe.drawParticleRing(crucible.m_58904_(), (ParticleOptions)ParticleTypes.f_123810_, crucible.m_58899_(), 0.5, 0.6, 1);
            crucible.m_58904_().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_11822_, SoundSource.BLOCKS, 0.1f, 1.2f);
        }
        if (crucible.linked_crystal != null && crucible.getPowerLevel((Power)Powers.LIGHT_POWER.get()) > WorldSpecificValue.get("levitationcost", 10, 30)) {
            ReactionEffects.craftSecretScale(crucible);
        }
        return crucible;
    }

    private static void craftSecretScale(CrucibleBlockEntity crucible) {
        for (Entity entity : CrucibleBlock.getEntitesInside(crucible.m_58899_(), crucible.m_58904_())) {
            ItemEntity item_entity;
            if (!(entity instanceof ItemEntity) || !(item_entity = (ItemEntity)entity).m_32055_().m_150930_((Item)Registration.PHANTOM_RESIDUE.get())) continue;
            ParticleScribe.drawParticleZigZag(crucible.m_58904_(), (ParticleOptions)ParticleTypes.f_123810_, crucible.m_58899_().m_123341_(), crucible.m_58899_().m_123342_(), crucible.m_58899_().m_123343_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 25, 10, 0.9);
            crucible.m_58904_().m_5594_(null, crucible.m_58899_(), SoundEvents.f_12376_, SoundSource.BLOCKS, 0.8f, 0.8f);
            int count = item_entity.m_32055_().m_41613_();
            item_entity.m_6074_();
            ItemStack drop_stack = ((Item)Registration.SECRET_SCALE.get()).m_7968_();
            drop_stack.m_41764_(count);
            ItemEntity secret_scale = new ItemEntity(crucible.m_58904_(), (double)crucible.m_58899_().m_123341_() + 0.5, (double)crucible.m_58899_().m_123342_() + 0.6, (double)crucible.m_58899_().m_123343_() + 0.5, drop_stack);
            secret_scale.m_32010_(20);
            crucible.m_58904_().m_7967_((Entity)secret_scale);
            crucible.m_58904_().m_7731_(crucible.m_58899_(), (BlockState)crucible.m_58900_().m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public static CrucibleBlockEntity growth(CrucibleBlockEntity c) {
        Random random = new Random();
        BlockPos target = c.m_58899_().m_7918_(random.nextInt(-32, 32), random.nextInt(-1, 0), random.nextInt(-32, 32));
        if (Objects.requireNonNull(c.m_58904_()).m_8055_(target).m_60734_() instanceof BonemealableBlock) {
            ((BonemealableBlock)c.m_58904_().m_8055_(target).m_60734_()).m_214148_((ServerLevel)c.m_58904_(), c.m_58904_().f_46441_, target, c.m_58904_().m_8055_(target));
        }
        return c;
    }

    public static CrucibleBlockEntity flamethrower(CrucibleBlockEntity c) {
        if (c.m_58904_() == null) {
            return c;
        }
        AABB blast_zone = new AABB(c.m_58899_());
        blast_zone = blast_zone.m_82377_(2.0, 5.0, 2.0);
        List nearby_ents = c.m_58904_().m_45976_(LivingEntity.class, blast_zone);
        for (LivingEntity e : nearby_ents) {
            if (!BeamHelper.hasLineOfSight(c.m_58904_(), c.m_58899_().m_252807_(), e.m_20299_(0.0f), ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, c.m_58900_().m_60734_())) continue;
            e.m_6469_(c.m_58904_().m_269111_().m_269387_(), 4.0f);
            e.m_7311_(140);
        }
        return c;
    }

    public static CrucibleBlockEntity sunlight(CrucibleBlockEntity c) {
        int range = 12;
        AABB aoe = new AABB(c.m_58899_());
        aoe = aoe.m_82400_((double)range);
        List nearby_monsters = c.m_58904_().m_45976_(Monster.class, aoe);
        for (Monster m : nearby_monsters) {
            if (!m.m_6336_().equals(MobType.f_21641_) || !(m.m_20318_(0.0f).m_82554_(c.m_58899_().m_252807_()) < (double)range)) continue;
            m.m_6469_(c.m_58904_().m_269111_().m_269387_(), 3.0f);
            m.m_20254_(5);
        }
        ParticleScribe.drawParticleRing(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123810_, c.m_58899_(), 0.6f, 12.0, 20);
        return c;
    }

    public static CrucibleBlockEntity blockfall(CrucibleBlockEntity c) {
        Level level = c.m_58904_();
        RandomSource random = level.f_46441_;
        BlockPos symbol_pos = c.areaMemory.fetch(level, (Block)Registration.GOLD_SYMBOL.get());
        if (symbol_pos == null) {
            return c;
        }
        for (int i = 0; i < 10; ++i) {
            BlockState target_state;
            BlockPos target = symbol_pos.m_7918_(random.m_216339_(-4, 4), random.m_216339_(0, 4), random.m_216339_(-4, 4));
            if (target == c.m_58899_() || target == symbol_pos || (target_state = level.m_8055_(target)).m_60795_() || !BlockMoveChecker.canMakeBlockFall(c.m_58904_(), target, target_state)) continue;
            FallingBlockEntity.m_201971_((Level)level, (BlockPos)target, (BlockState)target_state);
            ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ParticleTypes.f_123810_, c.m_58899_(), target, 8, 32, 0.7f);
            ItemEntity drop = new ItemEntity(level, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.6, (double)c.m_58899_().m_123343_() + 0.5, ((Item)Registration.MOTION_SALT.get()).m_7968_());
            level.m_7967_((Entity)drop);
        }
        return c;
    }

    public static CrucibleBlockEntity immobilize(CrucibleBlockEntity crucible) {
        Level level = crucible.m_58904_();
        if (level == null) {
            return crucible;
        }
        AABB aoe = new AABB(crucible.m_58899_());
        aoe = aoe.m_82400_(2.0);
        List nearby = level.m_45976_(LivingEntity.class, aoe);
        for (LivingEntity living : nearby) {
            MobEffectInstance stop;
            Player player;
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.f_123789_, crucible.m_58899_());
            if (!CrystalIronItem.effectNotBlocked(living, 1)) continue;
            if (living instanceof Player && (player = (Player)living).m_6144_()) {
                stop = new MobEffectInstance(MobEffects.f_19597_, 50);
                player.m_7292_(stop);
                continue;
            }
            stop = new MobEffectInstance((MobEffect)Registration.IMMOBILE.get(), 50, 0, true, false, true);
            living.m_7292_(stop);
        }
        return crucible;
    }

    public static CrucibleBlockEntity creation(CrucibleBlockEntity crucible) {
        Level level = Objects.requireNonNull(crucible.m_58904_());
        if ((double)level.f_46441_.m_188501_() < 0.2) {
            crucible.expendPower((Power)Powers.CURSE_POWER.get(), 3);
            for (BlockPos creation_point : ReactionEffects.getCreationPoints(crucible.m_58899_())) {
                if (!level.m_8055_(creation_point).m_60795_() || !level.m_46749_(creation_point)) continue;
                level.m_7731_(creation_point, ((Block)Registration.UNFORMED_MATTER.get()).m_49966_(), 2);
                level.m_46672_(creation_point, (Block)Registration.UNFORMED_MATTER.get());
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)Registration.STARDUST_PARTICLE, crucible.m_58899_(), creation_point, 10, 5, 0.5);
                break;
            }
        }
        return crucible;
    }

    public static Set<BlockPos> getCreationPoints(BlockPos origin) {
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        Random wsv_source = WorldSpecificValue.getSource("creation_points");
        while (points.size() < 3) {
            points.add(origin.m_7918_(wsv_source.nextInt(0, 3) * 2 - 3, wsv_source.nextInt(0, 2) * 2 + 2, wsv_source.nextInt(0, 3) * 2 - 3));
        }
        return points;
    }
}

