/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.AnnihilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.AssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.AstralReaction;
import dev.hyperlynx.reactive.alchemy.rxn.AstralSynthesisReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CatalystEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CurseAssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.DecomposeReaction;
import dev.hyperlynx.reactive.alchemy.rxn.EffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.alchemy.rxn.SynthesisReaction;
import dev.hyperlynx.reactive.datagen.ReactionAdvancementGenerator;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReactionMan {
    static boolean initialized = false;
    static boolean initializer_lock = false;
    private static final ReactionMap REACTIONS = new ReactionMap();
    public static ArrayList<Power> BASE_POWER_LIST = new ArrayList();

    public ReactionMan() {
        ReactionAdvancementGenerator.add("curse_assimilation");
        ReactionAdvancementGenerator.add("vital_kill");
        ReactionAdvancementGenerator.add("vital_eat");
        ReactionAdvancementGenerator.add("verdant_consume");
        ReactionAdvancementGenerator.add("vital_consume");
        ReactionAdvancementGenerator.add("verdant_growth");
        ReactionAdvancementGenerator.add("vital_growth");
        ReactionAdvancementGenerator.add("discharge_annihilation");
        ReactionAdvancementGenerator.add("smoke_annihilation");
        ReactionAdvancementGenerator.add("salt_annihilation");
        ReactionAdvancementGenerator.add("x_synthesis");
        ReactionAdvancementGenerator.add("y_synthesis");
        ReactionAdvancementGenerator.add("z_synthesis");
        ReactionAdvancementGenerator.add("growth");
        ReactionAdvancementGenerator.add("flames");
        ReactionAdvancementGenerator.add("levitation");
        ReactionAdvancementGenerator.add("sunlight");
        ReactionAdvancementGenerator.add("immobilize");
        ReactionAdvancementGenerator.add("soul_to_warp");
        ReactionAdvancementGenerator.add("warp_to_soul");
        ReactionAdvancementGenerator.add("compound_degradation");
        ReactionAdvancementGenerator.add("explosion_effect");
        ReactionAdvancementGenerator.add("formation_effect");
        ReactionAdvancementGenerator.add("block_fall_effect");
        ReactionAdvancementGenerator.add("slowfall_effect");
        ReactionAdvancementGenerator.add("astral_synthesis");
        ReactionAdvancementGenerator.add("astral");
        ReactionAdvancementGenerator.add("astral_curse_annihilation");
    }

    public List<Reaction> getReactions() {
        if (!initialized) {
            this.constructReactions();
        }
        return REACTIONS.values().stream().toList();
    }

    public List<String> getReactionAliases() {
        if (!initialized) {
            this.constructReactions();
        }
        return REACTIONS.keySet().stream().toList();
    }

    public Reaction get(String alias) {
        if (!initialized) {
            this.constructReactions();
        }
        return (Reaction)REACTIONS.get(alias);
    }

    private void constructReactions() {
        if (initializer_lock) {
            return;
        }
        initializer_lock = true;
        BASE_POWER_LIST.add((Power)Powers.BLAZE_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.WARP_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.SOUL_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.LIGHT_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.MIND_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.VITAL_POWER.get());
        BASE_POWER_LIST = WorldSpecificValue.shuffle("power_list_order", BASE_POWER_LIST);
        REACTIONS.add(new CurseAssimilationReaction("curse_assimilation"));
        REACTIONS.add(new AssimilationReaction("vital_kill", (Power)Powers.ACID_POWER.get(), (Power)Powers.VITAL_POWER.get()));
        REACTIONS.add(new AssimilationReaction("vital_eat", (Power)Powers.VITAL_POWER.get(), (Power)Powers.BODY_POWER.get()));
        int vvr = WorldSpecificValues.VERDANT_VITAL_RELATIONSHIP.get();
        switch (vvr) {
            case 2: {
                REACTIONS.add(new AssimilationReaction("verdant_consume", (Power)Powers.VERDANT_POWER.get(), (Power)Powers.VITAL_POWER.get()));
                break;
            }
            case 3: {
                REACTIONS.add(new AssimilationReaction("vital_consume", (Power)Powers.VITAL_POWER.get(), (Power)Powers.VERDANT_POWER.get()));
                break;
            }
            case 4: {
                REACTIONS.add(new SynthesisReaction("verdant_growth", (Power)Powers.VERDANT_POWER.get(), new Power[]{(Power)Powers.VITAL_POWER.get(), (Power)Powers.BODY_POWER.get()}));
                break;
            }
            case 5: {
                REACTIONS.add(new SynthesisReaction("vital_growth", (Power)Powers.VITAL_POWER.get(), new Power[]{(Power)Powers.VERDANT_POWER.get(), (Power)Powers.LIGHT_POWER.get()}));
            }
        }
        REACTIONS.add(new AnnihilationReaction("discharge_annihilation", BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(3), ReactionEffects::discharge));
        REACTIONS.add(new AnnihilationReaction("smoke_annihilation", BASE_POWER_LIST.get(1), BASE_POWER_LIST.get(4), ReactionEffects::smoke));
        REACTIONS.add(new AnnihilationReaction("salt_annihilation", BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(5), ReactionEffects::salt));
        REACTIONS.add(new SynthesisReaction("x_synthesis", (Power)Powers.X_POWER.get(), new Power[]{BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(1)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new SynthesisReaction("y_synthesis", (Power)Powers.Y_POWER.get(), new Power[]{BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(3)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new SynthesisReaction("z_synthesis", (Power)Powers.Z_POWER.get(), new Power[]{BASE_POWER_LIST.get(4), BASE_POWER_LIST.get(5)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new EffectReaction("growth", ReactionEffects::growth, (Power)Powers.VERDANT_POWER.get(), (Power)Powers.MIND_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new FreeEffectReaction("flames", ReactionEffects::flamethrower, (Power)Powers.BLAZE_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new FreeEffectReaction("levitation", ReactionEffects::levitation, (Power)Powers.LIGHT_POWER.get()).setStimulus(Reaction.Stimulus.END_CRYSTAL));
        REACTIONS.add(new EffectReaction("sunlight", ReactionEffects::sunlight, (Power)Powers.LIGHT_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new EffectReaction("immobilize", ReactionEffects::immobilize, (Power)Powers.WARP_POWER.get(), (Power)Powers.VERDANT_POWER.get()).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
        switch (WorldSpecificValues.CONDUIT_POWER.get()) {
            case 1: {
                REACTIONS.add(new DecomposeReaction("soul_to_warp", (Power)Powers.SOUL_POWER.get(), new Power[]{(Power)Powers.WARP_POWER.get()}).setStimulus(Reaction.Stimulus.END_CRYSTAL));
                break;
            }
            case 2: {
                REACTIONS.add(new DecomposeReaction("warp_to_soul", (Power)Powers.WARP_POWER.get(), new Power[]{(Power)Powers.SOUL_POWER.get()}).setStimulus(Reaction.Stimulus.END_CRYSTAL));
            }
        }
        int order = WorldSpecificValues.EFFECT_ORDER.get();
        switch (order) {
            case 1: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.X_POWER.get(), new Power[]{BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(1)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new CatalystEffectReaction("slowfall_effect", ReactionEffects::slowfall, (Power)Powers.Z_POWER.get(), (Item)Registration.PHANTOM_RESIDUE.get()).markAlwaysPerfect());
                break;
            }
            case 2: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.Y_POWER.get(), new Power[]{BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(3)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new CatalystEffectReaction("slowfall_effect", ReactionEffects::slowfall, (Power)Powers.X_POWER.get(), (Item)Registration.PHANTOM_RESIDUE.get()).markAlwaysPerfect());
                break;
            }
            case 3: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.Z_POWER.get(), new Power[]{BASE_POWER_LIST.get(4), BASE_POWER_LIST.get(5)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new CatalystEffectReaction("slowfall_effect", ReactionEffects::slowfall, (Power)Powers.Y_POWER.get(), (Item)Registration.PHANTOM_RESIDUE.get()).markAlwaysPerfect());
            }
        }
        REACTIONS.add(new AstralSynthesisReaction("astral_synthesis", (Power)Powers.ASTRAL_POWER.get(), new Power[]{(Power)Powers.X_POWER.get(), (Power)Powers.Y_POWER.get(), (Power)Powers.Z_POWER.get()}).markAlwaysPerfect());
        REACTIONS.add(new AstralReaction("astral"));
        REACTIONS.add(new AnnihilationReaction("astral_curse_annihilation", (Power)Powers.ASTRAL_POWER.get(), (Power)Powers.CURSE_POWER.get(), ReactionEffects::creation).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
        MinecraftForge.EVENT_BUS.post((Event)new ReactionConstructEvent());
        initialized = true;
        initializer_lock = false;
    }

    public static void addReactions(Reaction ... reactions) {
        REACTIONS.addAll(reactions);
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.reset();
    }

    public void reset() {
        initialized = false;
        REACTIONS.clear();
        BASE_POWER_LIST.clear();
        MinecraftForge.EVENT_BUS.post((Event)new ReactionResetEvent());
    }

    protected static class ReactionMap
    extends HashMap<String, Reaction> {
        protected ReactionMap() {
        }

        public Reaction add(Reaction reaction) {
            String alias = reaction.alias;
            if (((List)ConfigMan.SERVER.disabledReactions.get()).contains(alias)) {
                return null;
            }
            return super.put(reaction.alias, reaction);
        }

        public void addAll(Reaction ... reactions) {
            for (Reaction reaction : reactions) {
                this.add(reaction);
            }
        }
    }

    public static class ReactionConstructEvent
    extends Event {
    }

    public static class ReactionResetEvent
    extends Event {
    }
}

