/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.Registration;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GatewayBlockEntity
extends TheEndPortalBlockEntity {
    private int tick_count;
    public GlobalPos target;
    private int warp_cooldown = 0;
    private final String TARGET_POS_TAG = "Target";
    private final String TARGET_DIMENSION_TAG = "Dimension";
    private final String COOLDOWN_TAG = "Cooldown";

    public GatewayBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Registration.GATEWAY_BE.get(), pos, blockState);
        Random random = new Random(pos.hashCode());
        this.tick_count = random.nextInt(0, 12000);
    }

    public boolean m_6665_(Direction face) {
        return true;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!(t instanceof GatewayBlockEntity)) {
            return;
        }
        GatewayBlockEntity gateway = (GatewayBlockEntity)t;
        if (level.m_5776_()) {
            ++gateway.tick_count;
        } else if (gateway.isOnCooldown()) {
            --gateway.warp_cooldown;
        }
    }

    public float totalTick(float partialTick) {
        return (float)this.tick_count + partialTick;
    }

    public void setCooldown(int cooldown) {
        this.warp_cooldown = cooldown;
    }

    public boolean isOnCooldown() {
        return this.warp_cooldown > 0;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.target == null) {
            return;
        }
        tag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target.m_122646_()));
        tag.m_128365_("Dimension", (Tag)StringTag.m_129297_((String)String.valueOf(this.target.m_122640_().m_135782_())));
        tag.m_128365_("Cooldown", (Tag)IntTag.m_128679_((int)this.warp_cooldown));
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        BlockPos pos;
        super.m_142466_(tag);
        try {
            pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Target"));
        }
        catch (ClassCastException exception) {
            return;
        }
        ResourceLocation location = new ResourceLocation(tag.m_128423_("Dimension").m_7916_());
        this.target = GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location), (BlockPos)pos);
        this.warp_cooldown = tag.m_128451_("Cooldown");
    }
}

