/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeRodBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape X_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    protected static final VoxelShape Y_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BlazeRodBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Direction.Axis)state.m_61143_((Property)f_55923_)).m_122478_()) {
            return Y_SHAPE;
        }
        if (((Direction.Axis)state.m_61143_((Property)f_55923_)).equals((Object)Direction.Axis.X)) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            AABB bubble_box = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_()).m_83215_().m_82338_(pos);
            if (!level.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_)) {
                bubble_box.m_165893_(0.8);
            }
            ParticleScribe.drawParticleBox(level, (ParticleOptions)ParticleTypes.f_123774_, bubble_box, 2);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor level_access, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level_access.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level_access));
        }
        return super.m_7417_(state, direction, state2, level_access, pos, pos2);
    }
}

