/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.advancements.FlagCriterion;
import dev.hyperlynx.reactive.be.DisplacedBlockEntity;
import dev.hyperlynx.reactive.util.BlockMoveChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplacedBlock
extends Block
implements EntityBlock {
    public DisplacedBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60971_((state, getter, pos) -> false).m_60955_().m_222994_().m_60978_(1.0f).m_155956_(-1.0f).m_60918_(SoundType.f_56728_).m_278166_(PushReaction.IGNORE));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.m_123341_() + rng.m_188501_();
            double y = (float)pos.m_123342_() + rng.m_188501_();
            double z = (float)pos.m_123343_() + rng.m_188501_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static boolean displace(BlockState state_to_be_displaced, BlockPos pos, Level level, int duration) {
        if (!level.f_46443_) {
            FlagCriterion.triggerForNearbyPlayers((ServerLevel)level, CriteriaTriggers.SEE_DISPLACEMENT_TRIGGER, pos, 16);
        }
        return DisplacedBlock.displaceWithChain(state_to_be_displaced, pos, level, duration, 0, null);
    }

    public static boolean displaceWithChain(BlockState state_to_be_displaced, BlockPos pos, Level level, int duration, int depth, BlockPos chain) {
        if (level.m_7702_(pos) != null || !BlockMoveChecker.canDisplaceBlock(level, pos, state_to_be_displaced) || state_to_be_displaced.m_60795_()) {
            return false;
        }
        level.m_7731_(pos, ((Block)Registration.DISPLACED_BLOCK.get()).m_49966_(), 2);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof DisplacedBlockEntity)) {
            System.err.println("Displaced Block Entity didn't attach...? Report this to hyperlynx!");
            return false;
        }
        DisplacedBlockEntity displaced = (DisplacedBlockEntity)be;
        displaced.setSelfState(state_to_be_displaced);
        displaced.chain_target = chain;
        displaced.depth = depth;
        level.m_186460_(pos, (Block)Registration.DISPLACED_BLOCK.get(), duration);
        return true;
    }

    private boolean shouldNotReappear(ServerLevel level, BlockPos pos, DisplacedBlockEntity self_entity) {
        if (self_entity.getSelfState() == null) {
            return true;
        }
        boolean ret = level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.VOLT_CELL.get());
        if (self_entity.chain_target != null) {
            ret = ret || level.m_8055_(self_entity.chain_target).m_60713_((Block)Registration.DISPLACED_BLOCK.get());
        }
        return ret;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rng) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof DisplacedBlockEntity)) {
            ReactiveMod.LOGGER.error("Something went wrong restoring block from displaced block. Report this to hyperlynx! I hope it wasn't expensive...");
            level.m_7731_(pos, Blocks.f_49994_.m_49966_(), 2);
            return;
        }
        DisplacedBlockEntity displaced = (DisplacedBlockEntity)blockentity;
        if (this.shouldNotReappear(level, pos, displaced)) {
            if (displaced.first_tick) {
                level.m_186460_(pos, (Block)Registration.DISPLACED_BLOCK.get(), 2 + displaced.depth);
                displaced.first_tick = false;
            } else {
                level.m_186460_(pos, (Block)Registration.DISPLACED_BLOCK.get(), 20);
            }
            return;
        }
        level.m_46597_(pos, displaced.getSelfState());
        level.m_46672_(pos, (Block)this);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        DisplacedBlock.reform(level, pos);
        level.m_5594_(null, pos, SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 0.8f);
        return true;
    }

    private static void reform(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DisplacedBlockEntity) {
            DisplacedBlockEntity displaced = (DisplacedBlockEntity)blockEntity;
            if (displaced.getSelfState().m_60734_() instanceof DisplacedBlock) {
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 0.6f);
                return;
            }
            if (level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.VOLT_CELL.get())) {
                level.m_46961_(pos.m_7495_(), true);
            }
            level.m_46597_(pos, displaced.getSelfState());
        } else {
            ReactiveMod.LOGGER.error("Didn't find a valid block entity associated with the displaced block at {}! Report this to hyperlynx!", (Object)pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean moving) {
        if (new_state.m_60713_((Block)Registration.DISPLACED_BLOCK.get())) {
            return;
        }
        DisplacedBlock.reform(level, pos);
        super.m_6810_(state, level, pos, new_state, moving);
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        BlockEntity entity = getter.m_7702_(pos);
        if (!(entity instanceof DisplacedBlockEntity)) {
            return ItemStack.f_41583_;
        }
        DisplacedBlockEntity displaced_entity = (DisplacedBlockEntity)entity;
        if (displaced_entity.getSelfState().m_60734_() instanceof DisplacedBlock) {
            return ItemStack.f_41583_;
        }
        return displaced_entity.getSelfState().m_60734_().m_7397_(getter, pos, state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DisplacedBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState p_48758_) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }
}

