/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.fx.gui;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.net.litmus.LitmusData;
import dev.hyperlynx.reactive.util.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.NotNull;

public class LitmusScreen
extends Screen {
    List<Component> power_lines;
    List<Component> reaction_lines;
    private List<LitmusScreenComponent> lines_to_draw;
    int y = 0;
    int page = 0;
    int max_page = 0;
    private Button page_backward;
    private Button page_forward;
    private static final int BOX_WIDTH = 180;
    private static final int BOX_HEIGHT = 200;
    private final List<Color> decoration_colors = new ArrayList<Color>();
    static int PAGE_LENGTH = 16;
    private static final ResourceLocation PAPER_BACKGROUND = ReactiveMod.location("textures/gui/litmus.png");
    private static final List<Rect> DECORATIONS = List.of(new Rect(28, 3, 44, 4), new Rect(127, 3, 135, 4), new Rect(8, 195, 15, 196), new Rect(90, 3, 99, 4), new Rect(135, 195, 151, 196), new Rect(123, 195, 133, 196), new Rect(80, 195, 89, 196), new Rect(44, 195, 52, 196), new Rect(164, 3, 171, 4), new Rect(105, 3, 109, 4));

    public LitmusScreen(LitmusData data) {
        super((Component)Component.m_237115_((String)"item.reactive.litmus_paper"));
        this.reaction_lines = data.reaction_lines();
        this.power_lines = data.power_lines();
        assert (Minecraft.m_91087_().f_91074_ != null);
    }

    private int getBoxCenterY() {
        return this.f_96544_ / 2;
    }

    private int getBoxTopY() {
        return this.getBoxCenterY() - 100;
    }

    private int getBoxBottomY() {
        return this.getBoxCenterY() + 100;
    }

    private int getBoxCenterX() {
        return this.f_96543_ / 2;
    }

    private int getBoxLeftX() {
        return this.getBoxCenterX() - 90;
    }

    private int getBoxRightX() {
        return this.getBoxCenterX() + 90;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        ArrayList<LitmusScreenComponent> lines = new ArrayList<LitmusScreenComponent>(List.of(new LitmusScreenComponent((Component)Component.m_237115_((String)"text.reactive.measurement_header").m_130940_((Boolean)ConfigMan.COMMON.litmusScreen.get() != false ? ChatFormatting.BOLD : ChatFormatting.GRAY), false, true)));
        lines.addAll(this.power_lines.stream().map(line -> new LitmusScreenComponent((Component)line, true, false)).toList());
        lines.add(new LitmusScreenComponent((Component)Component.m_237119_(), false, false));
        lines.add(new LitmusScreenComponent((Component)Component.m_237115_((String)"text.reactive.reaction_header").m_130940_((Boolean)ConfigMan.COMMON.litmusScreen.get() != false ? ChatFormatting.BOLD : ChatFormatting.GRAY), false, true));
        lines.addAll(this.reaction_lines.stream().map(line -> new LitmusScreenComponent((Component)line, false, false)).toList());
        this.lines_to_draw = lines;
        this.page_backward = Button.m_253074_((Component)Component.m_237113_((String)"<"), LitmusScreen::pageBackward).m_253136_();
        this.page_backward.m_93674_(20);
        this.page_backward.m_264152_(this.getBoxLeftX() - this.page_backward.m_5711_(), this.getBoxTopY() + 8);
        this.page_backward.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.page_backward);
        this.page_forward = Button.m_253074_((Component)Component.m_237113_((String)">"), LitmusScreen::pageForward).m_253136_();
        this.page_forward.m_93674_(20);
        this.page_forward.m_264152_(this.getBoxRightX(), this.getBoxTopY() + 8);
        this.page_forward.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.page_forward);
        this.primeDecorations();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.page_forward.f_93624_ = this.page < this.max_page;
        this.page_backward.f_93624_ = this.page > 0;
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        for (LitmusScreenLine line : this.paginate(this.lines_to_draw)) {
            this.renderLine(graphics, line.sequence, line.power_text);
        }
        this.renderDecorations(graphics);
        this.y = 0;
    }

    private void renderLine(GuiGraphics graphics, FormattedCharSequence sequence, boolean power_text) {
        int line_width = this.f_96547_.m_92724_(sequence);
        graphics.m_280649_(this.f_96547_, sequence, this.getBoxCenterX() - line_width / 2, this.getBoxTopY() + 20 + this.y, 0xFFFFFF, power_text);
        this.y += 10;
    }

    private List<LitmusScreenLine> paginate(List<LitmusScreenComponent> components) {
        this.max_page = (components.size() - 1) / PAGE_LENGTH;
        LinkedList<LitmusScreenLine> paginated = new LinkedList<LitmusScreenLine>();
        for (LitmusScreenComponent c : components) {
            if (c.component.equals(Component.m_237119_())) {
                paginated.add(new LitmusScreenLine(FormattedCharSequence.f_13691_, false, false));
                continue;
            }
            List lines = this.f_96547_.m_92923_((FormattedText)c.component, 180);
            for (FormattedCharSequence sequence : lines) {
                paginated.add(new LitmusScreenLine(sequence, c.power_text, c.header));
            }
        }
        for (int i = 0; i < this.page * PAGE_LENGTH; ++i) {
            if (((LitmusScreenLine)paginated.get((int)0)).header && i == this.page * PAGE_LENGTH - 1) continue;
            paginated.remove(0);
        }
        while (paginated.size() > PAGE_LENGTH) {
            paginated.remove(paginated.size() - 1);
        }
        if (((LitmusScreenLine)paginated.get((int)(paginated.size() - 1))).header) {
            paginated.remove(paginated.size() - 1);
        }
        return paginated;
    }

    private static void pageForward(Button button) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof LitmusScreen) {
            LitmusScreen lit_screen = (LitmusScreen)screen;
            if (lit_screen.page < lit_screen.max_page) {
                ++lit_screen.page;
            }
            lit_screen.y = 0;
        }
    }

    private static void pageBackward(Button button) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof LitmusScreen) {
            LitmusScreen lit_screen = (LitmusScreen)screen;
            if (lit_screen.page > 0) {
                --lit_screen.page;
            }
            lit_screen.y = 0;
        }
    }

    private void primeDecorations() {
        this.decoration_colors.clear();
        if (!((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get()).booleanValue()) {
            return;
        }
        for (Component line : this.power_lines) {
            TextColor color = line.m_7383_().m_131135_();
            if (color == null) continue;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (color.m_131265_() == BiomeColors.m_108811_((BlockAndTintGetter)player.m_9236_(), (BlockPos)player.m_20097_()) || this.decoration_colors.size() >= DECORATIONS.size()) continue;
            if (line.getString().contains(Component.m_237115_((String)"power.reactive.astral").getString().toUpperCase())) {
                this.decoration_colors.add(new Color(-1));
                continue;
            }
            this.decoration_colors.add(new Color(color.m_131265_()));
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
        graphics.m_280509_(this.f_96543_ / 2 - 90, this.getBoxTopY(), this.f_96543_ / 2 + 90, this.getBoxTopY() + 200, 0x60606060);
        graphics.m_280218_(PAPER_BACKGROUND, this.getBoxLeftX(), this.getBoxTopY(), 0, 0, 180, 224);
    }

    private void renderDecorations(GuiGraphics graphics) {
        for (int i = 0; i < this.decoration_colors.size(); ++i) {
            if (this.decoration_colors.get((int)i).hex == -1) {
                graphics.m_285944_(RenderType.m_173242_(), this.getBoxLeftX(), this.getBoxTopY() + 2, this.getBoxLeftX() + 180, this.getBoxTopY() + 6, -1);
                graphics.m_285944_(RenderType.m_173242_(), this.getBoxLeftX(), this.getBoxBottomY() - 6, this.getBoxLeftX() + 180, this.getBoxBottomY() - 2, -1);
                return;
            }
            Rect rect = DECORATIONS.get(i);
            graphics.m_280509_(rect.x1 + this.getBoxLeftX(), rect.y1 + this.getBoxTopY(), rect.x2 + this.getBoxLeftX() + 1, rect.y2 + this.getBoxTopY() + 1, 0xFF000000 | this.decoration_colors.get((int)i).hex);
        }
    }

    record LitmusScreenComponent(Component component, boolean power_text, boolean header) {
    }

    record LitmusScreenLine(FormattedCharSequence sequence, boolean power_text, boolean header) {
    }

    private record Rect(int x1, int y1, int x2, int y2) {
    }
}

