/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.fx.renderers.rxn;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import dev.hyperlynx.reactive.fx.renderers.rxn.ReactionRenderer;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraftforge.fml.ModList;

public class ReactionRenderers {
    public Map<String, ReactionRenderer> RENDERERS = new HashMap<String, ReactionRenderer>();

    public ReactionRenderers() {
        this.RENDERERS.put("curse_assimilation", this::curseRing);
        this.RENDERERS.put("discharge_annihilation", this::annihilationSmoke);
        this.RENDERERS.put("smoke_annihilation", this::smoke);
        this.RENDERERS.put("growth", this::growth);
        this.RENDERERS.put("flames", this::flamethrower);
        this.RENDERERS.put("astral_curse_annihilation", this::creation);
    }

    public Iterable<ReactionRenderer> getRenderers(Iterable<String> aliases) {
        if (ModList.get().isLoaded("kubejs")) {
            ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.requestRenderers();
        }
        ArrayList<ReactionRenderer> ret = new ArrayList<ReactionRenderer>();
        for (String alias : aliases) {
            if (!this.RENDERERS.containsKey(alias)) continue;
            ret.add(this.RENDERERS.get(alias));
        }
        return ret;
    }

    public void smoke(CrucibleBlockEntity crucible) {
        ParticleScribe.drawParticleCrucibleTop(crucible.m_58904_(), (ParticleOptions)ParticleTypes.f_123755_, crucible.m_58899_(), 0.3f);
    }

    public void annihilationSmoke(CrucibleBlockEntity reactor) {
        ParticleScribe.drawParticleCrucibleTop(reactor.m_58904_(), (ParticleOptions)ParticleTypes.f_123762_, reactor.m_58899_(), 0.2f);
    }

    public void curseRing(CrucibleBlockEntity reactor) {
        ParticleScribe.drawParticleRing(reactor.m_58904_(), (ParticleOptions)ParticleTypes.f_123783_, reactor.m_58899_(), 0.45, 0.7, 1);
    }

    public void growth(CrucibleBlockEntity reactor) {
        ParticleScribe.drawParticleCrucibleTop(reactor.m_58904_(), (ParticleOptions)ParticleTypes.f_123748_, reactor.m_58899_(), 0.1f);
    }

    public void flamethrower(CrucibleBlockEntity reactor) {
        if (reactor.m_58904_() == null) {
            return;
        }
        if (reactor.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 20) {
            ParticleScribe.drawParticleCrucibleTop(reactor.m_58904_(), (ParticleOptions)ParticleTypes.f_123745_, reactor.m_58899_(), 0.1f, 0.0, 0.1, 0.0);
        } else {
            ParticleScribe.drawParticleCrucibleTop(reactor.m_58904_(), (ParticleOptions)ParticleTypes.f_123744_, reactor.m_58899_(), 0.1f, 0.0, 0.1, 0.0);
        }
    }

    public void creation(CrucibleBlockEntity reactor) {
        Set<BlockPos> points = ReactionEffects.getCreationPoints(reactor.m_58899_());
        for (BlockPos pos : points) {
            if (!reactor.m_58904_().m_8055_(pos).m_60795_()) continue;
            ParticleScribe.drawParticleSphere(Objects.requireNonNull(reactor.m_58904_()), (ParticleOptions)Registration.STARDUST_PARTICLE, pos, 0.5, 1.0, 1);
        }
    }

    public void astral(CrucibleBlockEntity reactor) {
        if (reactor.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) < reactor.getTotalPowerLevel()) {
            ParticleScribe.drawParticleRing(reactor.m_58904_(), (ParticleOptions)Registration.STARDUST_PARTICLE.m_6012_(), reactor.m_58899_(), 0.45, 0.7, 1);
        }
    }
}

