/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.integration.jei.SlotManager;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class TransmuteRecipeCategory
implements IRecipeCategory<TransmuteRecipe> {
    SlotManager slot_manager = new SlotManager();

    public TransmuteRecipeCategory() {
        this.slot_manager.addSlot("reactant", 1, 1);
        this.slot_manager.addSlot("product", 55, 1);
        this.slot_manager.addSlot("center_reagent", 28, 22);
        this.slot_manager.addSlot("mid_left_reagent", 19, 22);
        this.slot_manager.addSlot("mid_right_reagent", 37, 22);
        this.slot_manager.addSlot("left_reagent", 10, 22);
        this.slot_manager.addSlot("right_reagent", 46, 22);
    }

    @Nullable
    public ResourceLocation getRegistryName(TransmuteRecipe recipe) {
        return recipe.m_6423_();
    }

    public RecipeType<TransmuteRecipe> getRecipeType() {
        return RecipeType.create((String)"reactive", (String)"transmute", TransmuteRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"title.reactive.transmute");
    }

    public IDrawable background() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/tf_jei.png"), 2, 2, 72, 39);
    }

    public IDrawable getBackground() {
        return this.background();
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransmuteRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input_slot = this.slot_manager.buildSlot(builder, "reactant", RecipeIngredientRole.INPUT);
        input_slot.addItemStacks(List.of(recipe.getReactant().m_43908_()));
        IRecipeSlotBuilder output_slot = this.slot_manager.buildSlot(builder, "product", RecipeIngredientRole.OUTPUT);
        output_slot.addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        switch (recipe.getReagents().size()) {
            case 1: {
                IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "center_reagent", RecipeIngredientRole.CATALYST);
                power_slot.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(0));
                break;
            }
            case 2: {
                IRecipeSlotBuilder power_slotl = this.slot_manager.buildSlot(builder, "mid_left_reagent", RecipeIngredientRole.CATALYST);
                power_slotl.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(0));
                IRecipeSlotBuilder power_slotr = this.slot_manager.buildSlot(builder, "mid_right_reagent", RecipeIngredientRole.CATALYST);
                power_slotr.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(1));
                break;
            }
            case 3: {
                IRecipeSlotBuilder power_slotl = this.slot_manager.buildSlot(builder, "left_reagent", RecipeIngredientRole.CATALYST);
                power_slotl.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(0));
                IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "center_reagent", RecipeIngredientRole.CATALYST);
                power_slot.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(1));
                IRecipeSlotBuilder power_slotr = this.slot_manager.buildSlot(builder, "right_reagent", RecipeIngredientRole.CATALYST);
                power_slotr.addIngredient((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, (Object)recipe.getReagents().get(2));
                break;
            }
            default: {
                IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "center_reagent", RecipeIngredientRole.CATALYST);
                power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, recipe.getReagents());
            }
        }
    }

    public void draw(TransmuteRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        if (recipe.needs_electricity) {
            this.drawElectricLabel(gui);
        }
        this.slot_manager.drawSlotBackgrounds(gui, List.of("reactant", "product"));
        switch (recipe.getReagents().size()) {
            case 2: {
                this.slot_manager.drawSlotBackgrounds(gui, List.of("mid_left_reagent", "mid_right_reagent"));
                break;
            }
            case 3: {
                this.slot_manager.drawSlotBackgrounds(gui, List.of("left_reagent", "center_reagent", "right_reagent"));
                break;
            }
            default: {
                this.slot_manager.drawSlotBackground(gui, "center_reagent");
            }
        }
    }

    private void drawElectricLabel(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.m_91087_();
        int width = minecraft.f_91062_.m_92895_("Charge");
        int center = this.getBackground().getWidth() / 2;
        int x = center - width / 2;
        int y = 11;
        gui.m_280488_(minecraft.f_91062_, "Charge", x, y, 895144);
    }
}

